/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gt;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.gt.GTTools;
import ptolemy.actor.gt.NamedObjVariable;
import ptolemy.data.expr.ScopeExtendingAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ActorScopeExtender
extends ScopeExtendingAttribute {
    private List<Object> _attributeList;
    private long _version = -1L;

    public ActorScopeExtender(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public List<?> attributeList() {
        long version = this.workspace().getVersion();
        if (this._attributeList == null || version > this._version) {
            this._attributeList = new LinkedList<Object>(super.attributeList());
            NamedObj scope = this.getContainer();
            Collection<?> children = GTTools.getChildren(scope, true, true, true, true);
            for (Object childObject : children) {
                NamedObj child = (NamedObj)childObject;
                if (child instanceof ActorScopeExtender) continue;
                try {
                    NamedObjVariable variable = NamedObjVariable.getNamedObjVariable(child, true);
                    if (variable == null) continue;
                    this._attributeList.add(variable);
                }
                catch (IllegalActionException e) {
                    throw new InternalErrorException(e);
                }
            }
            this._version = version;
        }
        return Collections.unmodifiableList(this._attributeList);
    }

    @Override
    public Attribute getAttribute(String name) {
        NamedObj scope = this.getContainer();
        NamedObj child = GTTools.getChild(scope, name, true, true, true, true);
        if (child instanceof ActorScopeExtender) {
            child = GTTools.getChild(scope, name, false, true, true, true);
        }
        if (child == null) {
            return super.getAttribute(name);
        }
        try {
            NamedObjVariable actorVariable = NamedObjVariable.getNamedObjVariable(child, true);
            return actorVariable;
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
    }
}

