/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor;

import java.util.HashMap;
import ptolemy.actor.Actor;
import ptolemy.actor.AtomicActor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.IOPort;
import ptolemy.graph.DirectedGraph;
import ptolemy.graph.Edge;
import ptolemy.graph.Graph;
import ptolemy.graph.Node;

public class GraphReader {
    private static final boolean _debug = false;
    private HashMap _actorMap = new HashMap();

    public Graph convert(CompositeActor compositeActor) {
        Graph graph = this._initializeGraph(compositeActor);
        for (Object entity : compositeActor.deepEntityList()) {
            if (entity instanceof AtomicActor || entity instanceof CompositeActor) {
                Actor actor = (Actor)entity;
                Node newNode = graph.addNodeWeight(this._computeNodeWeight(actor));
                this._actorMap.put(actor, newNode);
                this._processNewNode(graph, newNode, actor);
                continue;
            }
            throw new RuntimeException("Unsupported deep entity type: " + entity.getClass().getName() + " (value = " + entity + ")");
        }
        for (Actor source : compositeActor.deepEntityList()) {
            for (IOPort outPort : source.outputPortList()) {
                for (IOPort inPort : outPort.deepConnectedInPortList()) {
                    Actor sink = (Actor)((Object)inPort.getContainer());
                    if (!graph.containsNode((Node)this._actorMap.get(sink))) continue;
                    Edge newEdge = graph.addEdge((Node)this._actorMap.get(source), (Node)this._actorMap.get(sink), this._computeEdgeWeight(outPort, inPort));
                    this._processNewEdge(graph, newEdge, outPort, inPort);
                }
            }
        }
        this._transformTopology(graph);
        return graph;
    }

    protected Object _computeEdgeWeight(IOPort sourcePort, IOPort sinkPort) {
        return sinkPort;
    }

    protected Object _computeNodeWeight(Actor actor) {
        return actor;
    }

    protected Graph _initializeGraph(CompositeActor compositeActor) {
        return new DirectedGraph();
    }

    protected void _processNewEdge(Graph graph, Edge edge, IOPort sourcePort, IOPort sinkPort) {
    }

    protected void _processNewNode(Graph graph, Node node, Actor actor) {
    }

    protected void _transformTopology(Graph graph) {
    }
}

