/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import data.VoxelOrderDataSource;
import data.WildBS_DT_DataSynth;
import imaging.Scheme;
import inverters.ModelIndex;
import java.util.Random;
import tractography.BS_DT_TractographyImage;

public class WildBS_DT_TractographyImage
extends BS_DT_TractographyImage {
    private final float[][][][] data;
    private final WildBS_DT_DataSynth dataSynth;

    public WildBS_DT_TractographyImage(float[][][][] fArray, double[] dArray, int[][][] nArray, Scheme scheme, Random random) {
        super(new int[]{fArray.length, fArray[0].length, fArray[0][0].length}, dArray, nArray, new ModelIndex[]{ModelIndex.LDT}, scheme, random);
        this.data = fArray;
        this.dataSynth = new WildBS_DT_DataSynth(null, scheme, -1, random);
        this.computeIsotropicMask();
    }

    @Override
    protected double[] nextBootstrapSample(int n, int n2, int n3) {
        this.dataSynth.setSourceData(this.data[n][n2][n3]);
        return this.dataSynth.nextVoxel();
    }

    public static final WildBS_DT_TractographyImage getBS_TractographyImage(String string, String string2, Scheme scheme, int[][][] nArray, double[][][] dArray, double d, int[] nArray2, double[] dArray2, Random random) {
        int n = nArray2[0];
        int n2 = nArray2[1];
        int n3 = nArray2[2];
        int n4 = scheme.numMeasurements();
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string, n4, string2);
        float[][][][] fArray = new float[nArray2[0]][nArray2[1]][nArray2[2]][n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    fArray[k][j][i] = new float[n4];
                    double[] dArray3 = voxelOrderDataSource.nextVoxel();
                    for (int i2 = 0; i2 < n4; ++i2) {
                        fArray[k][j][i][i2] = (float)dArray3[i2];
                    }
                }
            }
        }
        int[][][] nArray3 = nArray;
        if (nArray3 == null) {
            nArray3 = new int[n][n2][n3];
        }
        WildBS_DT_TractographyImage wildBS_DT_TractographyImage = new WildBS_DT_TractographyImage(fArray, dArray2, nArray3, scheme, random);
        if (dArray != null) {
            wildBS_DT_TractographyImage.computeIsotropicMask(dArray, d);
        }
        return wildBS_DT_TractographyImage;
    }
}

