/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import data.VoxelOrderDataSource;
import imaging.Scheme;
import inverters.ModelIndex;
import java.util.Random;
import tractography.BS_DT_TractographyImage;
import tractography.TractographyImage;

public class RepBS_DT_TractographyImage
extends BS_DT_TractographyImage {
    private final float[][][][][] data;
    private final int numRepeats;

    public RepBS_DT_TractographyImage(float[][][][][] fArray, double[] dArray, int[][][] nArray, ModelIndex[] modelIndexArray, Scheme scheme, Random random) {
        super(new int[]{fArray.length, fArray[0].length, fArray[0][0].length}, dArray, nArray, modelIndexArray, scheme, random);
        this.data = fArray;
        this.numRepeats = fArray[0][0][0].length;
        this.computeIsotropicMask();
    }

    @Override
    protected double[] nextBootstrapSample(int n, int n2, int n3) {
        double[] dArray = new double[this.numMeasurements];
        for (int i = 0; i < this.numMeasurements; ++i) {
            int n4 = this.ran.nextInt(this.numRepeats);
            dArray[i] = this.data[n][n2][n3][n4][i];
        }
        return dArray;
    }

    public static final RepBS_DT_TractographyImage getBS_TractographyImage(String[] stringArray, String string, Scheme scheme, ModelIndex[] modelIndexArray, int[][][] nArray, double[][][] dArray, double d, int[] nArray2, double[] dArray2, Random random) {
        Object object;
        int n = nArray2[0];
        int n2 = nArray2[1];
        int n3 = nArray2[2];
        int n4 = stringArray.length;
        int n5 = scheme.numMeasurements();
        float[][][][][] fArray = new float[n][n2][n3][n4][n5];
        for (int i = 0; i < n4; ++i) {
            object = new VoxelOrderDataSource(stringArray[i], n5, string);
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    for (int i2 = 0; i2 < n; ++i2) {
                        double[] dArray3 = ((VoxelOrderDataSource)object).nextVoxel();
                        for (int i3 = 0; i3 < n5; ++i3) {
                            fArray[i2][k][j][i][i3] = (float)dArray3[i3];
                        }
                    }
                }
            }
        }
        int[][][] nArray3 = nArray;
        if (nArray3 == null) {
            nArray3 = new int[n][n2][n3];
        }
        object = new RepBS_DT_TractographyImage(fArray, dArray2, nArray3, modelIndexArray, scheme, random);
        if (dArray != null) {
            ((TractographyImage)object).computeIsotropicMask(dArray, d);
        }
        return object;
    }
}

