/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.Random;
import misc.LoggedException;
import tractography.PICoACGRandomizer;
import tractography.PICoBinghamRandomizer;
import tractography.PICoRandomizer;
import tractography.PICoTractographyImage;
import tractography.PICoWatsonRandomizer;

public enum PICoPDF {
    ACG("acg", 3),
    BINGHAM("bingham", 2),
    WATSON("watson", 1);

    public final String name;
    public final int numParams;

    private PICoPDF(String string2, int n2) {
        this.name = string2;
        this.numParams = n2;
    }

    public String toString() {
        return this.name;
    }

    public static PICoPDF getPDF(String string) {
        for (PICoPDF pICoPDF : PICoPDF.values()) {
            if (!string.equals(pICoPDF.name)) continue;
            return pICoPDF;
        }
        throw new LoggedException("Unsupported PICo PDF type " + string);
    }

    public PICoRandomizer getRandomizer(PICoTractographyImage pICoTractographyImage, Random random) {
        switch (this) {
            case ACG: {
                return new PICoACGRandomizer(pICoTractographyImage, random);
            }
            case BINGHAM: {
                return new PICoBinghamRandomizer(pICoTractographyImage, random);
            }
            case WATSON: {
                return new PICoWatsonRandomizer(pICoTractographyImage, random);
            }
        }
        throw new LoggedException("Unknown PICo PDF " + this.name);
    }
}

