/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.Random;
import numerics.ACG_Distribution;
import numerics.AxialDistribution;
import numerics.Vector3D;
import tractography.PICoTractographyImage;
import tractography.SimplePICoRandomizer;

public class PICoACGRandomizer
extends SimplePICoRandomizer {
    private final PICoTractographyImage image;
    private final Random ran;

    protected PICoACGRandomizer(PICoTractographyImage pICoTractographyImage, Random random) {
        super(pICoTractographyImage.xDataDim(), pICoTractographyImage.yDataDim(), pICoTractographyImage.zDataDim());
        this.image = pICoTractographyImage;
        this.ran = random;
    }

    @Override
    protected AxialDistribution[] getPDFs(int n, int n2, int n3) {
        double[] dArray = this.image.getPICoPDFParams(n, n2, n3);
        Vector3D[] vector3DArray = this.image.getEigenvectors(n, n2, n3);
        AxialDistribution[] axialDistributionArray = new ACG_Distribution[vector3DArray.length / 3];
        for (int i = 0; i < axialDistributionArray.length; ++i) {
            Vector3D[] vector3DArray2 = new Vector3D[]{vector3DArray[3 * i], vector3DArray[3 * i + 1], vector3DArray[3 * i + 2]};
            axialDistributionArray[i] = new ACG_Distribution(vector3DArray2, new double[]{dArray[i * 0], dArray[i * 3 + 1], dArray[i * 3 + 2]}, this.ran);
        }
        return axialDistributionArray;
    }
}

