/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import Jama.Matrix;
import imaging.Scheme;
import inverters.ModelIndex;
import java.text.DecimalFormat;
import java.util.Random;
import misc.DT;
import numerics.ACG_Fitter;
import numerics.BinghamFitter;
import numerics.ConvergenceException;
import numerics.EigenSystem3D;
import numerics.RealMatrix;
import numerics.Vector3D;
import numerics.WatsonFitter;
import tractography.DT_LookupTableGenerator;

public class OneTensorLUTGenerator
extends DT_LookupTableGenerator {
    public OneTensorLUTGenerator(Scheme scheme, double d, double d2, Random random) {
        super(scheme, d, d2, random);
    }

    @Override
    public double[][][][] generateLUT(double d, double d2, double d3, int n, ModelIndex modelIndex, boolean bl, boolean bl2, boolean bl3) {
        if (d2 < 1.0) {
            return this.generateFA_LUT(d, d2, d3, n, modelIndex, bl, bl2, bl3);
        }
        return this.generateEV_LUT(d, d2, d3, n, modelIndex, bl, bl2, bl3);
    }

    public double[][][][] generateFA_LUT(double d, double d2, double d3, int n, ModelIndex modelIndex, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        double d4 = 0.0;
        double[][][][] dArray = new double[3][1][1 + (int)Math.round((d2 - d) / d3)][];
        int n2 = 0;
        d4 = d;
        double d5 = dArray[0][0].length;
        DecimalFormat decimalFormat = new DecimalFormat("00.00");
        while (n2 < dArray[0][0].length) {
            System.err.print("\r ... " + decimalFormat.format(100.0 * (double)n2 / d5) + "% completed");
            DT[] dTArray = OneTensorLUTGenerator.getNoisyTensors(new DT[]{this.getTensor(d4, this.trace, this.ran)}, new double[]{1.0}, modelIndex, this.imPars, this.snr, n, this.ran)[0];
            Vector3D[] vector3DArray = new Vector3D[n];
            int n3 = 0;
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                if (dTArray[i] == null) {
                    ++n3;
                    continue;
                }
                double[][] dArray2 = dTArray[i].sortedEigenSystem();
                blArray[i] = true;
                vector3DArray[i] = new Vector3D(dArray2[1][0], dArray2[2][0], dArray2[3][0]);
            }
            if ((double)n3 > 5.0 * (double)n / 100.0) {
                double d6 = (double)n3 * 100.0 / (double)n;
                System.err.println("Warning: discarding " + d6 + " % of samples at point : (" + d4 + ")");
            }
            Vector3D[] vector3DArray2 = new Vector3D[n - n3];
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                if (!blArray[i]) continue;
                vector3DArray2[n4++] = vector3DArray[i];
            }
            vector3DArray = vector3DArray2;
            dArray[0][0][n2] = bl ? this.getWatsonConcentrationParams(vector3DArray) : new double[1];
            dArray[1][0][n2] = bl2 ? this.getBinghamConcentrationParams(vector3DArray) : new double[2];
            dArray[2][0][n2] = bl3 ? this.getACGConcentrationParams(vector3DArray) : new double[3];
            ++n2;
            d4 += d3;
        }
        System.err.println();
        return dArray;
    }

    public double[][][][] generateEV_LUT(double d, double d2, double d3, int n, ModelIndex modelIndex, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        double d4 = d;
        double d5 = d2;
        double[][][][] dArray = new double[3][1 + (int)Math.round((d2 - d) / d3)][1 + (int)Math.round((d5 - d4) / d3)][];
        int n2 = 0;
        int n3 = 0;
        double d6 = d;
        double d7 = d4;
        double d8 = (double)(dArray[0].length * (dArray[0].length + 1)) / 2.0;
        DecimalFormat decimalFormat = new DecimalFormat("00.00");
        while (n2 < dArray[0].length) {
            System.err.print("\r ... " + decimalFormat.format(100.0 * (double)n2 * (double)(n2 + 1) / (2.0 * d8)) + "% completed");
            while (n3 < dArray[0][0].length) {
                if (n2 < n3) {
                    dArray[0][n2][n3] = new double[1];
                    dArray[1][n2][n3] = new double[2];
                    dArray[2][n2][n3] = new double[3];
                    ++n3;
                    d7 += d3;
                    continue;
                }
                DT[] dTArray = OneTensorLUTGenerator.getNoisyTensors(new DT[]{this.getTensor(d6, d7, this.trace, this.ran)}, new double[]{1.0}, modelIndex, this.imPars, this.snr, n, this.ran)[0];
                Vector3D[] vector3DArray = new Vector3D[n];
                int n4 = 0;
                boolean[] blArray = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    if (dTArray[i] == null) {
                        ++n4;
                        continue;
                    }
                    double[][] dArray2 = dTArray[i].sortedEigenSystem();
                    blArray[i] = true;
                    vector3DArray[i] = new Vector3D(dArray2[1][0], dArray2[2][0], dArray2[3][0]);
                }
                if ((double)n4 > 5.0 * (double)n / 100.0) {
                    double d9 = (double)n4 * 100.0 / (double)n;
                    System.err.println("Warning: discarding " + d9 + " % of samples at point : (" + d6 + ", " + d7 + ")");
                }
                Vector3D[] vector3DArray2 = new Vector3D[n - n4];
                int n5 = 0;
                for (int i = 0; i < n; ++i) {
                    if (!blArray[i]) continue;
                    vector3DArray2[n5++] = vector3DArray[i];
                }
                vector3DArray = vector3DArray2;
                dArray[0][n2][n3] = bl ? this.getWatsonConcentrationParams(vector3DArray) : new double[1];
                dArray[1][n2][n3] = bl2 ? this.getBinghamConcentrationParams(vector3DArray) : new double[2];
                dArray[2][n2][n3] = bl3 ? this.getACGConcentrationParams(vector3DArray) : new double[3];
                ++n3;
                d7 += d3;
            }
            ++n2;
            d6 += d3;
            n3 = 0;
            d7 = d4;
        }
        System.err.println();
        return dArray;
    }

    protected double[] getWatsonConcentrationParams(Vector3D[] vector3DArray) {
        EigenSystem3D eigenSystem3D = WatsonFitter.tBarEigenSystem(vector3DArray);
        return new double[]{WatsonFitter.fitKappa(eigenSystem3D, vector3DArray)};
    }

    protected double[] getBinghamConcentrationParams(Vector3D[] vector3DArray) {
        EigenSystem3D eigenSystem3D = BinghamFitter.tBarEigenSystem(vector3DArray);
        try {
            double[] dArray = BinghamFitter.bngpar(eigenSystem3D.eigenvalues[1], eigenSystem3D.eigenvalues[2]);
            return new double[]{dArray[0], dArray[1]};
        }
        catch (ConvergenceException convergenceException) {
            return new double[]{0.0, 0.0};
        }
    }

    protected double[] getACGConcentrationParams(Vector3D[] vector3DArray) {
        RealMatrix realMatrix = ACG_Fitter.findA(vector3DArray);
        Matrix matrix = new Matrix(3, 3);
        matrix.set(0, 0, realMatrix.entries[0][0]);
        matrix.set(0, 1, realMatrix.entries[0][1]);
        matrix.set(0, 2, realMatrix.entries[0][2]);
        matrix.set(1, 0, realMatrix.entries[1][0]);
        matrix.set(1, 1, realMatrix.entries[1][1]);
        matrix.set(1, 2, realMatrix.entries[1][2]);
        matrix.set(2, 0, realMatrix.entries[2][0]);
        matrix.set(2, 1, realMatrix.entries[2][1]);
        matrix.set(2, 2, realMatrix.entries[2][2]);
        EigenSystem3D eigenSystem3D = EigenSystem3D.sort(matrix.eig());
        return new double[]{eigenSystem3D.eigenvalues[0], eigenSystem3D.eigenvalues[1], eigenSystem3D.eigenvalues[2]};
    }
}

