/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.Hashtable;
import java.util.Set;
import misc.LoggedException;
import numerics.Vector3D;
import tractography.HistBin;

public class Histogram {
    private Hashtable<Object, HistBin> histogram;
    private int dimensions;
    private double binSize;
    private boolean useLog;

    public Histogram(int n, double d, boolean bl) {
        this.dimensions = n;
        this.binSize = d;
        this.useLog = bl;
        if (this.dimensions == 1) {
            this.histogram = new Hashtable();
        } else if (this.dimensions == 2) {
            this.histogram = new Hashtable();
        } else {
            throw new LoggedException("Histogram must be either 1 or 2 dimensional.  requested " + this.dimensions + "D histogram");
        }
    }

    public Histogram(double d, boolean bl) {
        this(1, d, bl);
    }

    public void add(Vector3D vector3D, double d, double d2) {
        String string = "";
        if (this.dimensions == 1) {
            string = this.getKey1D(d, d2);
        } else if (this.dimensions == 2) {
            string = this.getKey2D(d, d2);
        }
        HistBin histBin = this.histogram.get(string);
        if (histBin == null) {
            int n = (int)(d / this.binSize);
            int n2 = (int)(d2 / this.binSize);
            if (this.useLog) {
                n = (int)(Math.log(d) / this.binSize);
                n2 = (int)(Math.log(d2) / this.binSize);
                histBin = new HistBin(Math.exp((double)n * this.binSize), Math.exp((double)n2 * this.binSize));
            } else {
                histBin = new HistBin((double)n * this.binSize, (double)n2 * this.binSize);
            }
            this.histogram.put(string, histBin);
        }
        histBin.addDirToList(vector3D);
    }

    public Set getEntrySet() {
        return this.histogram.entrySet();
    }

    private String getKey1D(double d, double d2) {
        int n = (int)(d / this.binSize);
        int n2 = (int)(d2 / this.binSize);
        int n3 = (int)(((double)n * this.binSize + (double)n2 * this.binSize) / this.binSize);
        if (this.useLog) {
            n = (int)(Math.log(d) / this.binSize);
            n2 = (int)(Math.log(d2) / this.binSize);
            n3 = (int)(Math.log(Math.exp((double)n2 * this.binSize) + Math.exp((double)n2 * this.binSize)) / this.binSize);
        }
        return Integer.toString(n3);
    }

    private String getKey2D(double d, double d2) {
        int n = (int)(d / this.binSize);
        int n2 = (int)(d2 / this.binSize);
        if (this.useLog) {
            n = (int)(Math.log(d) / this.binSize);
            n2 = (int)(Math.log(d2) / this.binSize);
        }
        return Integer.toString(n) + Integer.toString(n2);
    }
}

