/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.ArrayList;
import numerics.Point3D;
import tractography.RegionOfInterest;
import tractography.Voxel;

public final class FreeFormROI
implements RegionOfInterest {
    private final double xVoxelDim;
    private final double yVoxelDim;
    private final double zVoxelDim;
    private final int xDataDim;
    private final int yDataDim;
    private final int zDataDim;
    private final short[][][] data;
    private final short minRegionIndex;
    private final short maxRegionIndex;
    private final int numberOfRegions;

    public FreeFormROI(short[][][] sArray, double[] dArray) {
        this(sArray, dArray[0], dArray[1], dArray[2]);
    }

    public FreeFormROI(short[][][] sArray, double d, double d2, double d3) {
        this.data = sArray;
        this.xDataDim = this.data.length;
        this.yDataDim = this.data[0].length;
        this.zDataDim = this.data[0][0].length;
        short s = Short.MAX_VALUE;
        short s2 = 0;
        boolean[] blArray = new boolean[Short.MAX_VALUE];
        int n = 0;
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    short s3 = this.data[k][j][i];
                    if (s3 > s2) {
                        s2 = s3;
                    }
                    if (s3 > 0 && s3 < s) {
                        s = s3;
                    }
                    if (s3 <= 0 || blArray[s3]) continue;
                    blArray[s3] = true;
                    ++n;
                }
            }
        }
        this.numberOfRegions = n;
        this.minRegionIndex = s;
        this.maxRegionIndex = s2;
        this.xVoxelDim = d;
        this.yVoxelDim = d2;
        this.zVoxelDim = d3;
    }

    public FreeFormROI(short[][][] sArray, short s, double[] dArray) {
        this(sArray, s, dArray[0], dArray[1], dArray[2]);
    }

    public FreeFormROI(short[][][] sArray, short s, double d, double d2, double d3) {
        this.xDataDim = sArray.length;
        this.yDataDim = sArray[0].length;
        this.zDataDim = sArray[0][0].length;
        this.data = new short[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    if (sArray[k][j][i] != s) continue;
                    this.data[k][j][i] = s;
                }
            }
        }
        this.minRegionIndex = s;
        this.maxRegionIndex = s;
        this.xVoxelDim = d;
        this.yVoxelDim = d2;
        this.zVoxelDim = d3;
        this.numberOfRegions = 1;
    }

    public static FreeFormROI[] getRegions(short[][][] sArray, double d, double d2, double d3) {
        int n;
        int n2;
        int n3;
        int n4;
        short s = Short.MAX_VALUE;
        short s2 = 0;
        int n5 = sArray.length;
        int n6 = sArray[0].length;
        int n7 = sArray[0][0].length;
        for (int i = 0; i < n7; ++i) {
            for (n4 = 0; n4 < n6; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    if (sArray[n3][n4][i] < s && sArray[n3][n4][i] > 0) {
                        s = sArray[n3][n4][i];
                    }
                    if (sArray[n3][n4][i] <= s2) continue;
                    s2 = sArray[n3][n4][i];
                }
            }
        }
        if (s2 == 0) {
            return new FreeFormROI[0];
        }
        boolean[] blArray = new boolean[s2 - s + 1];
        n4 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                for (n = 0; n < n5; ++n) {
                    if (sArray[n][n2][n3] <= 0 || blArray[sArray[n][n2][n3] - s]) continue;
                    ++n4;
                    blArray[sArray[n][n2][n3] - s] = true;
                }
            }
        }
        FreeFormROI[] freeFormROIArray = new FreeFormROI[n4];
        n2 = 0;
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            freeFormROIArray[n2++] = new FreeFormROI(sArray, (short)(s + n), d, d2, d3);
        }
        return freeFormROIArray;
    }

    @Override
    public boolean containsVoxel(int n, int n2, int n3) {
        return this.data[n][n2][n3] > 0;
    }

    @Override
    public boolean containsMMPoint(Point3D point3D) {
        int n = (int)(point3D.x / this.xVoxelDim);
        int n2 = (int)(point3D.y / this.yVoxelDim);
        int n3 = (int)(point3D.z / this.zVoxelDim);
        return this.data[n][n2][n3] > 0;
    }

    @Override
    public Voxel[] getVoxels() {
        ArrayList<Voxel> arrayList = new ArrayList<Voxel>(100);
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    if (this.data[k][j][i] <= 0) continue;
                    arrayList.add(new Voxel(k, j, i));
                }
            }
        }
        Voxel[] voxelArray = new Voxel[arrayList.size()];
        return arrayList.toArray(voxelArray);
    }

    @Override
    public Point3D[] getSeedPoints() {
        ArrayList<Point3D> arrayList = new ArrayList<Point3D>(100);
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    if (this.data[k][j][i] <= 0) continue;
                    arrayList.add(new Point3D(((double)k + 0.5) * this.xVoxelDim, ((double)j + 0.5) * this.yVoxelDim, ((double)i + 0.5) * this.zVoxelDim));
                }
            }
        }
        Point3D[] point3DArray = new Point3D[arrayList.size()];
        return arrayList.toArray(point3DArray);
    }

    @Override
    public int numberOfRegions() {
        return this.numberOfRegions;
    }

    @Override
    public RegionOfInterest getRegion(int n) {
        if (n >= 0 && n < this.maxRegionIndex - this.minRegionIndex + 1) {
            return new FreeFormROI(this.data, (short)(this.minRegionIndex + n), this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
        }
        throw new IllegalArgumentException("ROI index out of bounds. This ROI contains " + this.numberOfRegions() + " regions");
    }
}

