/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import numerics.Point3D;
import numerics.Vector3D;
import tractography.ConnectionProbabilityImage;
import tractography.RegionOfInterest;
import tractography.Tract;
import tractography.TractCollection;
import tractography.TractographyImage;

public abstract class FibreTracker {
    protected short[][][] visitedVoxel = null;
    public static final boolean FORWARD = true;
    public static final boolean BACKWARD = false;
    protected final double ipThreshold;
    protected final double xVoxelDim;
    protected final double yVoxelDim;
    protected final double zVoxelDim;
    protected final int xDataDim;
    protected final int yDataDim;
    protected final int zDataDim;
    private final double xUBound;
    private final double yUBound;
    private final double zUBound;
    protected final boolean[][][] isotropic;
    protected final TractographyImage image;
    short[] zeros;

    protected FibreTracker(TractographyImage tractographyImage, double d) {
        this.ipThreshold = d;
        this.xDataDim = tractographyImage.xDataDim();
        this.yDataDim = tractographyImage.yDataDim();
        this.zDataDim = tractographyImage.zDataDim();
        this.xVoxelDim = tractographyImage.xVoxelDim();
        this.yVoxelDim = tractographyImage.yVoxelDim();
        this.zVoxelDim = tractographyImage.zVoxelDim();
        this.xUBound = (double)this.xDataDim * this.xVoxelDim;
        this.yUBound = (double)this.yDataDim * this.yVoxelDim;
        this.zUBound = (double)this.zDataDim * this.zVoxelDim;
        this.visitedVoxel = new short[this.xDataDim][this.yDataDim][this.zDataDim];
        this.isotropic = tractographyImage.getIsotropicMask();
        this.image = tractographyImage;
        this.zeros = new short[this.zDataDim];
    }

    public final TractCollection trackPaths(RegionOfInterest regionOfInterest) {
        Point3D[] point3DArray = regionOfInterest.getSeedPoints();
        TractCollection tractCollection = new TractCollection(point3DArray.length + 1, 100.0);
        for (int i = 0; i < point3DArray.length; ++i) {
            tractCollection.addTractCollection(this.trackFromSeed(point3DArray[i]));
        }
        return tractCollection;
    }

    public TractCollection trackFromSeed(Point3D point3D) {
        TractCollection tractCollection = new TractCollection(4, 100.0);
        if (!this.inBounds(point3D)) {
            Tract tract = new Tract(2, 100.0);
            tract.addPoint(point3D);
            tractCollection.addTract(tract);
            return tractCollection;
        }
        int n = (int)(point3D.x / this.xVoxelDim);
        int n2 = (int)(point3D.y / this.yVoxelDim);
        int n3 = (int)(point3D.z / this.zVoxelDim);
        int n4 = this.image.numberOfPDs(n, n2, n3);
        for (int i = 0; i < n4; ++i) {
            Tract tract = this.trackFromSeed(point3D, i, true);
            Tract tract2 = this.trackFromSeed(point3D, i, false);
            tract.joinTract(tract2);
            tractCollection.addTract(tract);
            for (int j = 0; j < this.xDataDim; ++j) {
                for (int k = 0; k < this.yDataDim; ++k) {
                    System.arraycopy(this.zeros, 0, this.visitedVoxel[j][k], 0, this.zDataDim);
                }
            }
        }
        return tractCollection;
    }

    public TractCollection trackFromSeed(Point3D point3D, int n) {
        TractCollection tractCollection = new TractCollection(2, 100.0);
        if (!this.inBounds(point3D)) {
            Tract tract = new Tract(2, 100.0);
            tract.addPoint(point3D);
            tractCollection.addTract(tract);
            return tractCollection;
        }
        int n2 = (int)(point3D.x / this.xVoxelDim);
        int n3 = (int)(point3D.y / this.yVoxelDim);
        int n4 = (int)(point3D.z / this.zVoxelDim);
        int n5 = this.image.numberOfPDs(n2, n3, n4);
        Tract tract = this.trackFromSeed(point3D, n, true);
        Tract tract2 = this.trackFromSeed(point3D, n, false);
        tract.joinTract(tract2);
        tractCollection.addTract(tract);
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                System.arraycopy(this.zeros, 0, this.visitedVoxel[i][j], 0, this.zDataDim);
            }
        }
        return tractCollection;
    }

    protected abstract Tract trackFromSeed(Point3D var1, int var2, boolean var3);

    protected final boolean inBounds(Point3D point3D) {
        double d = point3D.x;
        double d2 = point3D.y;
        double d3 = point3D.z;
        return d >= 0.0 && d2 >= 0.0 && d3 >= 0.0 && d < (double)this.xDataDim * this.xVoxelDim && d2 < (double)this.yDataDim * this.yVoxelDim && d3 < (double)this.zDataDim * this.zVoxelDim;
    }

    public final TractCollection getConnectingPaths(RegionOfInterest regionOfInterest, RegionOfInterest regionOfInterest2) {
        Point3D point3D;
        int n;
        int n2;
        int n3;
        TractCollection tractCollection = new TractCollection(200, 100.0);
        TractCollection tractCollection2 = this.trackPaths(regionOfInterest);
        block0: for (n3 = 0; n3 < tractCollection2.numberOfTracts(); ++n3) {
            n2 = tractCollection2.getTract(n3).numberOfPoints();
            for (n = 0; n < n2; ++n) {
                point3D = tractCollection2.getTract(n3).getPoint(n);
                if (!regionOfInterest2.containsMMPoint(point3D)) continue;
                tractCollection.addTract(tractCollection2.getTract(n3));
                continue block0;
            }
        }
        tractCollection2 = this.trackPaths(regionOfInterest2);
        block2: for (n3 = 0; n3 < tractCollection2.numberOfTracts(); ++n3) {
            n = tractCollection2.getTract(n3).numberOfPoints();
            for (n2 = 0; n2 < n; ++n2) {
                point3D = tractCollection2.getTract(n3).getPoint(n2);
                if (!regionOfInterest.containsMMPoint(point3D)) continue;
                tractCollection.addTract(tractCollection2.getTract(n3));
                continue block2;
            }
        }
        return tractCollection;
    }

    protected double[][][] connectionProbability(Point3D point3D, int n) {
        ConnectionProbabilityImage connectionProbabilityImage = new ConnectionProbabilityImage(this.xDataDim, this.yDataDim, this.zDataDim, this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
        for (int i = 0; i < n; ++i) {
            TractCollection tractCollection = this.trackFromSeed(point3D);
            connectionProbabilityImage.processTracts(tractCollection);
        }
        return connectionProbabilityImage.getConnectionProbabilities();
    }

    public double ipThreshold() {
        return this.ipThreshold;
    }

    protected Vector3D[] getPDs(int n, int n2, int n3) {
        return this.image.getPDs(n, n2, n3);
    }

    public TractCollection getPICoTracts(Point3D point3D, int n) {
        int n2 = this.image.numberOfPDs((int)(point3D.x / this.xVoxelDim), (int)(point3D.y / this.yVoxelDim), (int)(point3D.z / this.zVoxelDim));
        TractCollection tractCollection = new TractCollection(n2 * n + 1, 100.0);
        for (int i = 0; i < n; ++i) {
            TractCollection tractCollection2 = this.trackFromSeed(point3D);
            tractCollection.addTractCollection(tractCollection2);
        }
        return tractCollection;
    }
}

