/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import numerics.Point3D;
import tractography.RegionOfInterest;
import tractography.Voxel;

final class CubicVoxelRegion
implements RegionOfInterest {
    protected final int iminX;
    protected final int iminY;
    protected final int iminZ;
    protected final int imaxX;
    protected final int imaxY;
    protected final int imaxZ;
    protected final double minXMM;
    protected final double minYMM;
    protected final double minZMM;
    protected final double maxXMM;
    protected final double maxYMM;
    protected final double maxZMM;
    private final double xVoxelDim;
    private final double yVoxelDim;
    private final double zVoxelDim;

    private CubicVoxelRegion() {
        this.iminX = 0;
        this.iminY = 0;
        this.iminZ = 0;
        this.imaxX = 0;
        this.imaxY = 0;
        this.imaxZ = 0;
        this.xVoxelDim = 1.0;
        this.yVoxelDim = 1.0;
        this.zVoxelDim = 1.0;
        this.minXMM = (double)this.iminX * this.xVoxelDim;
        this.minYMM = (double)this.iminY * this.yVoxelDim;
        this.minZMM = (double)this.iminZ * this.zVoxelDim;
        this.maxXMM = (double)(this.imaxX + 1) * this.xVoxelDim;
        this.maxYMM = (double)(this.imaxY + 1) * this.yVoxelDim;
        this.maxZMM = (double)(this.imaxZ + 1) * this.zVoxelDim;
    }

    public CubicVoxelRegion(int[] nArray, double[] dArray) {
        this(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], dArray[0], dArray[1], dArray[2]);
    }

    public CubicVoxelRegion(int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, double d3) {
        if (n <= n2) {
            this.iminX = n;
            this.imaxX = n2;
        } else {
            this.iminX = n2;
            this.imaxX = n;
        }
        if (n3 <= n4) {
            this.iminY = n3;
            this.imaxY = n4;
        } else {
            this.iminY = n4;
            this.imaxY = n3;
        }
        if (n5 <= n6) {
            this.iminZ = n5;
            this.imaxZ = n6;
        } else {
            this.iminZ = n6;
            this.imaxZ = n5;
        }
        this.xVoxelDim = d;
        this.yVoxelDim = d2;
        this.zVoxelDim = d3;
        this.minXMM = (double)this.iminX * this.xVoxelDim;
        this.minYMM = (double)this.iminY * this.yVoxelDim;
        this.minZMM = (double)this.iminZ * this.zVoxelDim;
        this.maxXMM = (double)(this.imaxX + 1) * this.xVoxelDim;
        this.maxYMM = (double)(this.imaxY + 1) * this.yVoxelDim;
        this.maxZMM = (double)(this.imaxZ + 1) * this.zVoxelDim;
    }

    public int getMinXVoxel() {
        return this.iminX;
    }

    public int getMinYVoxel() {
        return this.iminY;
    }

    public int getMinZVoxel() {
        return this.iminZ;
    }

    public int getMaxXVoxel() {
        return this.imaxX;
    }

    public int getMaxYVoxel() {
        return this.imaxY;
    }

    public int getMaxZVoxel() {
        return this.imaxZ;
    }

    @Override
    public boolean containsVoxel(int n, int n2, int n3) {
        return n >= this.iminX && n <= this.imaxX && n2 >= this.iminY && n2 <= this.imaxY && n3 >= this.iminZ && n3 <= this.imaxZ;
    }

    @Override
    public boolean containsMMPoint(Point3D point3D) {
        return point3D.x >= this.minXMM && point3D.x < this.maxXMM && point3D.y >= this.minYMM && point3D.y < this.maxYMM && point3D.z >= this.minZMM && point3D.z < this.maxZMM;
    }

    @Override
    public Voxel[] getVoxels() {
        Voxel[] voxelArray = new Voxel[(this.imaxX - this.iminX + 1) * (this.imaxY - this.iminY + 1) * (this.imaxZ - this.iminZ + 1)];
        int n = 0;
        for (int i = this.iminZ; i <= this.imaxZ; ++i) {
            for (int j = this.iminY; j <= this.imaxY; ++j) {
                for (int k = this.iminX; k <= this.imaxX; ++k) {
                    voxelArray[n++] = new Voxel(k, j, i);
                }
            }
        }
        return voxelArray;
    }

    @Override
    public Point3D[] getSeedPoints() {
        Point3D[] point3DArray = new Point3D[(this.imaxX - this.iminX + 1) * (this.imaxY - this.iminY + 1) * (this.imaxZ - this.iminZ + 1)];
        int n = 0;
        for (int i = this.iminZ; i <= this.imaxZ; ++i) {
            for (int j = this.iminY; j <= this.imaxY; ++j) {
                for (int k = this.iminX; k <= this.imaxX; ++k) {
                    point3DArray[n++] = new Point3D(((double)k + 0.5) * this.xVoxelDim, ((double)j + 0.5) * this.yVoxelDim, ((double)i + 0.5) * this.zVoxelDim);
                }
            }
        }
        return point3DArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CubicVoxelRegion)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        CubicVoxelRegion cubicVoxelRegion = (CubicVoxelRegion)object;
        return this.iminX == cubicVoxelRegion.iminX && this.imaxX == cubicVoxelRegion.imaxX && this.iminY == cubicVoxelRegion.iminY && this.imaxY == cubicVoxelRegion.imaxY && this.iminZ == cubicVoxelRegion.iminZ && this.imaxZ == cubicVoxelRegion.imaxZ && this.xVoxelDim == cubicVoxelRegion.xVoxelDim && this.yVoxelDim == cubicVoxelRegion.yVoxelDim && this.zVoxelDim == cubicVoxelRegion.zVoxelDim;
    }

    public String toString() {
        String string = "CubicRegion (VOXEL BOUNDS):\n";
        string = string + "xMin: " + this.iminX + "\txMax: " + this.imaxX + "\n";
        string = string + "yMin: " + this.iminY + "\tyMax: " + this.imaxY + "\n";
        string = string + "zMin: " + this.iminZ + "\tzMax: " + this.imaxZ + "\n";
        return string;
    }

    @Override
    public int numberOfRegions() {
        return 1;
    }

    @Override
    public RegionOfInterest getRegion(int n) {
        if (n == 0) {
            return this;
        }
        throw new IllegalArgumentException("ROI index out of bounds. This ROI contains " + this.numberOfRegions() + " regions");
    }
}

