/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.logging.Logger;
import numerics.Vector3D;
import tractography.FreeFormROI;
import tractography.TargetCP_Image;
import tractography.TractCollection;
import tractography.Voxel;

public class ConnectivitySegmentedImage {
    private static Logger logger = Logger.getLogger("camino.tractography.ConnectivitySegmentedImage");
    private final double xVoxelDim;
    private final double yVoxelDim;
    private final double zVoxelDim;
    private final int xDataDim;
    private final int yDataDim;
    private final int zDataDim;
    private FreeFormROI roi = null;
    private Voxel[] seedList = null;
    private int numSeeds = 0;
    private short[][][] targets;
    private int minTargetIndex = 0;
    private int maxTargetIndex = 0;
    private int numTargets = 0;
    private boolean directional = false;
    private Vector3D forwards = null;
    private boolean countFirstEntry = true;
    private short[][][][] labelledSeedImage = null;
    private int[][][][] targetSCImage;
    private double[][][][] targetCPImage;
    TargetCP_Image[] seedTargetCP;

    public ConnectivitySegmentedImage(FreeFormROI freeFormROI, short[][][] sArray, double d, double d2, double d3) {
        int n;
        this.roi = freeFormROI;
        this.seedList = this.roi.getVoxels();
        this.numSeeds = this.seedList.length;
        this.seedTargetCP = new TargetCP_Image[this.numSeeds];
        for (n = 0; n < this.numSeeds; ++n) {
            this.seedTargetCP[n] = new TargetCP_Image(sArray, d, d2, d3);
        }
        this.targets = sArray;
        this.xDataDim = sArray.length;
        this.yDataDim = sArray[0].length;
        this.zDataDim = sArray[0][0].length;
        this.xVoxelDim = d;
        this.yVoxelDim = d2;
        this.zVoxelDim = d3;
        for (n = 0; n < this.xDataDim; ++n) {
            for (int i = 0; i < this.yDataDim; ++i) {
                for (int j = 0; j < this.zDataDim; ++j) {
                    if (sArray[n][i][j] > 0 && sArray[n][i][j] < this.minTargetIndex) {
                        this.minTargetIndex = sArray[n][i][j];
                    }
                    if (sArray[n][i][j] <= 0 || sArray[n][i][j] <= this.maxTargetIndex) continue;
                    this.maxTargetIndex = sArray[n][i][j];
                }
            }
        }
        this.numTargets = this.maxTargetIndex - this.minTargetIndex + 1;
    }

    public void processTracts(int n, TractCollection tractCollection) {
        this.labelledSeedImage = null;
        this.targetSCImage = null;
        this.targetCPImage = null;
        this.seedTargetCP[n].processTracts(tractCollection);
    }

    public short[][][][] getSegmentedSeeds() {
        int n;
        short[][][][] sArray;
        int n2;
        int n3 = n2 = this.directional ? 2 : 1;
        if (this.labelledSeedImage == null) {
            sArray = new short[n2][this.xDataDim][this.yDataDim][this.zDataDim];
            int[][][][] nArray = new int[n2][this.xDataDim][this.yDataDim][this.zDataDim];
            double[][][][] dArray = new double[n2][this.xDataDim][this.yDataDim][this.zDataDim];
            for (n = 0; n < this.numSeeds; ++n) {
                int[][] nArray2 = this.seedTargetCP[n].getStreamlineCountsArray();
                double d = this.seedTargetCP[n].totalStreamlines();
                int n4 = this.seedList[n].x;
                int n5 = this.seedList[n].y;
                int n6 = this.seedList[n].z;
                for (int i = 0; i < n2; ++i) {
                    int n7 = 0;
                    short s = 0;
                    for (int j = this.minTargetIndex; j < this.numTargets; ++j) {
                        if (nArray2[i][j] <= n7) continue;
                        n7 = nArray2[i][j];
                        s = (short)j;
                    }
                    sArray[i][n4][n5][n6] = s;
                    nArray[i][n4][n5][n6] = n7;
                    dArray[i][n4][n5][n6] = d > 0.0 ? (double)n7 / d : 0.0;
                }
            }
            this.targetCPImage = dArray;
            this.targetSCImage = nArray;
            this.labelledSeedImage = sArray;
        }
        sArray = new short[n2][this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < this.xDataDim; ++j) {
                for (n = 0; n < this.yDataDim; ++n) {
                    System.arraycopy(this.labelledSeedImage[i][j][n], 0, sArray[i][j][n], 0, this.zDataDim);
                }
            }
        }
        return sArray;
    }

    public double[][][][] getMaxTargetCP() {
        if (this.targetCPImage == null) {
            this.getSegmentedSeeds();
        }
        int n = this.targetCPImage.length;
        double[][][][] dArray = new double[n][this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.xDataDim; ++j) {
                for (int k = 0; k < this.yDataDim; ++k) {
                    System.arraycopy(this.targetCPImage[i][j][k], 0, dArray[i][j][k], 0, this.zDataDim);
                }
            }
        }
        return dArray;
    }

    public int[][][][] getMaxTargetSC() {
        if (this.targetSCImage == null) {
            this.getSegmentedSeeds();
        }
        int n = this.targetSCImage.length;
        int[][][][] nArray = new int[n][this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.xDataDim; ++j) {
                for (int k = 0; k < this.yDataDim; ++k) {
                    System.arraycopy(this.targetSCImage[i][j][k], 0, nArray[i][j][k], 0, this.zDataDim);
                }
            }
        }
        return nArray;
    }

    public void setDirectional(Vector3D vector3D) {
        this.forwards = vector3D.normalized();
        this.directional = true;
        for (int i = 0; i < this.numSeeds; ++i) {
            this.seedTargetCP[i].setDirectional(this.forwards);
        }
    }

    public void setCountFirstEntry(boolean bl) {
        this.countFirstEntry = bl;
        for (int i = 0; i < this.numSeeds; ++i) {
            this.seedTargetCP[i].setCountFirstEntry(this.countFirstEntry);
        }
    }
}

