/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import imaging.Scheme;
import java.util.Random;
import misc.LoggedException;
import numerics.Vector3D;
import numerics.WatsonDistribution;
import sphfunc.ISCodes;
import sphfunc.ISCodesException;
import tractography.PICoRandomizer;

public abstract class BayesDiracRandomizer {
    protected Vector3D[] vectors;
    protected Vector3D[] negVectors;
    protected int numVectors;
    protected final float[][][][] data;
    protected final int xDataDim;
    protected final int yDataDim;
    protected final int zDataDim;
    protected final Scheme scheme;
    protected final int numMeas;
    protected final double[][] q;
    protected final double[] modQ;
    protected final Vector3D[] g;
    protected final double[] b;
    protected final double[] diffusionTimes;
    protected final double[][] vDotG;
    protected double[][] curvePrior = null;
    private double curvePriorKappa = 0.0;
    private double curvePriorGamma = 0.0;
    private boolean useCurvePrior = false;
    protected float[][][][] likelihood;
    private int functionsCalculated = 0;
    private final int FUNCTION_CACHE_LIMIT;
    protected PICoRandomizer externalPriors = null;
    protected final Random ran;
    private int lastRandomizedIndex = 0;

    public BayesDiracRandomizer(float[][][][] fArray, Scheme scheme, Random random) {
        this(fArray, scheme, 1, random);
    }

    public BayesDiracRandomizer(float[][][][] fArray, Scheme scheme, int n, Random random) {
        this.data = fArray;
        this.scheme = scheme;
        this.ran = random;
        this.initializeSphericalPointSet(n);
        long l = Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        this.FUNCTION_CACHE_LIMIT = (int)(l / (long)(8 * this.vectors.length));
        this.xDataDim = fArray.length;
        this.yDataDim = fArray[0].length;
        this.zDataDim = fArray[0][0].length;
        this.numMeas = fArray[0][0][0].length;
        this.q = new double[this.numMeas][];
        this.modQ = new double[this.numMeas];
        this.g = new Vector3D[this.numMeas];
        this.b = new double[this.numMeas];
        this.diffusionTimes = scheme.getDiffusionTimes();
        this.vDotG = new double[this.numMeas][this.numVectors];
        for (int i = 0; i < this.numMeas; ++i) {
            this.q[i] = scheme.getQ(i);
            this.modQ[i] = Math.sqrt(this.q[i][0] * this.q[i][0] + this.q[i][1] * this.q[i][1] + this.q[i][2] * this.q[i][2]);
            this.b[i] = this.modQ[i] * this.modQ[i] * this.diffusionTimes[i];
            if (this.b[i] > 0.0) {
                this.g[i] = new Vector3D(this.q[i][0] / this.modQ[i], this.q[i][1] / this.modQ[i], this.q[i][2] / this.modQ[i]);
                for (int j = 0; j < this.numVectors; ++j) {
                    this.vDotG[i][j] = this.g[i].dot(this.vectors[j]);
                }
                continue;
            }
            this.g[i] = new Vector3D(1.0, 0.0, 0.0);
        }
        this.likelihood = new float[this.xDataDim][this.yDataDim][this.zDataDim][];
    }

    protected abstract void computeLikelihood(int var1, int var2, int var3);

    public final Vector3D[] getRandomizedPDs(int n, int n2, int n3) {
        if (this.likelihood[n][n2][n3] == null) {
            ++this.functionsCalculated;
            if (this.functionsCalculated > this.FUNCTION_CACHE_LIMIT) {
                this.clearCache();
            }
            this.computeLikelihood(n, n2, n3);
        }
        float f = this.ran.nextFloat();
        float[] fArray = new float[this.numVectors];
        for (int i = 0; i < this.numVectors; ++i) {
            float f2 = i > 0 ? fArray[i - 1] : 0.0f;
            fArray[i] = f2 + this.likelihood[n][n2][n3][i] * 1.000002f;
            if (!(f <= fArray[i])) continue;
            this.lastRandomizedIndex = i;
            return new Vector3D[]{this.vectors[i]};
        }
        String string = "";
        for (int i = 0; i < this.numVectors; ++i) {
            string = string + i + "\t" + fArray[i] + "\n";
        }
        System.err.println("CDF: " + string);
        throw new LoggedException("target value (" + f + ") is greater than CDF of all vectors in " + "voxel " + n + " " + n2 + " " + n3);
    }

    public final Vector3D[] getRandomizedPDs(int n, int n2, int n3, Vector3D vector3D) {
        int n4;
        if (!this.useCurvePrior) {
            return this.getRandomizedPDs(n, n2, n3);
        }
        if (this.likelihood[n][n2][n3] == null) {
            ++this.functionsCalculated;
            if (this.functionsCalculated > this.FUNCTION_CACHE_LIMIT) {
                this.clearCache();
            }
            this.computeLikelihood(n, n2, n3);
        }
        float f = this.ran.nextFloat();
        float[] fArray = new float[this.numVectors];
        int n5 = this.lastRandomizedIndex;
        if (!vector3D.equals(this.vectors[n5]) && !vector3D.equals(this.negVectors[n5])) {
            n5 = -1;
            for (n4 = 0; n4 < this.numVectors; ++n4) {
                if (!this.vectors[n4].equals(vector3D) && !this.negVectors[n4].equals(vector3D)) continue;
                n5 = n4;
                break;
            }
        }
        if (n5 > -1) {
            for (n4 = 0; n4 < this.numVectors; ++n4) {
                float f2 = (float)((double)this.likelihood[n][n2][n3][n4] * this.curvePrior[n5][n4]);
                float f3 = n4 > 0 ? fArray[n4 - 1] : 0.0f;
                fArray[n4] = f3 + f2;
            }
        } else {
            throw new IllegalArgumentException("Previous direction is not one of the PDF samples");
        }
        float f4 = f * fArray[this.numVectors - 1];
        for (int i = 0; i < this.numVectors; ++i) {
            if (!(f4 <= fArray[i])) continue;
            this.lastRandomizedIndex = i;
            if (this.vectors[i].dot(vector3D) < 0.0) {
                return new Vector3D[]{this.negVectors[i]};
            }
            return new Vector3D[]{this.vectors[i]};
        }
        String string = "";
        for (int i = 0; i < this.numVectors; ++i) {
            string = string + i + "\t" + fArray[i] + "\n";
        }
        System.err.println("CDF: " + string);
        throw new LoggedException("target value (" + f4 + ") is greater than CDF of all vectors in " + "voxel " + n + " " + n2 + " " + n3);
    }

    public void setCurvatureK(double d) {
        if (!(d >= 0.0)) {
            throw new LoggedException("Can only use positive concentration for curve prior");
        }
        this.curvePriorKappa = d;
        if (d == 0.0) {
            this.useCurvePrior = false;
            this.curvePrior = null;
            return;
        }
        this.useCurvePrior = true;
        this.curvePriorKappa = d;
        this.curvePriorGamma = 0.0;
        this.curvePrior = new double[this.numVectors][this.numVectors];
        for (int i = 0; i < this.numVectors; ++i) {
            for (int j = 0; j <= i; ++j) {
                this.curvePrior[i][j] = WatsonDistribution.pdf(this.vectors[i], this.vectors[j], this.curvePriorKappa);
                this.curvePrior[j][i] = this.curvePrior[i][j];
            }
        }
    }

    public void setCurvatureG(double d) {
        if (!(d >= 0.0)) {
            throw new LoggedException("Can only use positive concentration for curve prior");
        }
        this.curvePriorGamma = d;
        if (d == 0.0) {
            this.useCurvePrior = false;
            this.curvePrior = null;
            return;
        }
        this.useCurvePrior = true;
        this.curvePriorGamma = d;
        this.curvePriorKappa = 0.0;
        this.curvePrior = new double[this.numVectors][this.numVectors];
        for (int i = 0; i < this.numVectors; ++i) {
            for (int j = 0; j <= i; ++j) {
                this.curvePrior[i][j] = Math.pow(Math.abs(this.vectors[i].dot(this.vectors[j])), d);
                this.curvePrior[j][i] = this.curvePrior[i][j];
            }
        }
    }

    public void setExternalPriors(PICoRandomizer pICoRandomizer) {
        this.externalPriors = pICoRandomizer;
    }

    private void clearCache() {
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    this.likelihood[k][j][i] = null;
                }
            }
        }
    }

    protected static double exp(double d) {
        long l = (long)(1512775.0 * d + 1.072632447E9);
        return Double.longBitsToDouble(l << 32);
    }

    public void initializeSphericalPointSet(int n) {
        try {
            double[][] dArray = ISCodes.getPointSet((int)n).data;
            this.numVectors = dArray.length;
            this.vectors = new Vector3D[this.numVectors];
            this.negVectors = new Vector3D[this.numVectors];
            for (int i = 0; i < dArray.length; ++i) {
                this.vectors[i] = new Vector3D(dArray[i][0], dArray[i][1], dArray[i][2]);
                this.negVectors[i] = new Vector3D(-dArray[i][0], -dArray[i][1], -dArray[i][2]);
            }
        }
        catch (ISCodesException iSCodesException) {
            throw new LoggedException(iSCodesException);
        }
    }
}

