/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import misc.LoggedException;

public class FileOutput {
    private String filename = "";
    private BufferedWriter writer = null;

    public FileOutput(String string) {
        this.filename = string;
        try {
            this.writer = new BufferedWriter(new FileWriter(this.filename));
        }
        catch (IOException iOException) {
            this.error("Can't open file: " + this.filename);
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            this.error("Can't close file: " + this.filename);
        }
    }

    public final synchronized void writeInteger(int n) {
        try {
            this.writer.write(Integer.toString(n));
        }
        catch (IOException iOException) {
            this.error("writeInteger failed for file: " + this.filename);
        }
    }

    public final synchronized void writeLong(long l) {
        try {
            this.writer.write(Long.toString(l));
        }
        catch (IOException iOException) {
            this.error("writeLong failed for file: " + this.filename);
        }
    }

    public final synchronized void writeDouble(double d) {
        try {
            this.writer.write(Double.toString(d));
        }
        catch (IOException iOException) {
            this.error("writeDouble failed for file: " + this.filename);
        }
    }

    public final synchronized void writeFloat(float f) {
        try {
            this.writer.write(Float.toString(f));
        }
        catch (IOException iOException) {
            this.error("writeFloat failed for file: " + this.filename);
        }
    }

    public final synchronized void writeCharacter(char c) {
        try {
            this.writer.write(c);
        }
        catch (IOException iOException) {
            this.error("writeCharacter failed for file: " + this.filename);
        }
    }

    public final synchronized void writeString(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            this.error("writeString failed for file: " + this.filename);
        }
    }

    public final synchronized void writeNewline() {
        try {
            this.writer.write("\n");
        }
        catch (IOException iOException) {
            this.error("writeNewline failed for file: " + this.filename);
        }
    }

    private void error(String string) {
        throw new LoggedException(string + " \nUnable to continue executing program.");
    }
}

