/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import misc.LoggedException;

public class FileInput {
    private String filename = "";
    private BufferedReader reader = null;
    private boolean eof = false;

    public FileInput(String string) {
        this.filename = string;
        try {
            this.reader = new BufferedReader(new FileReader(this.filename));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new LoggedException("WARNING: Can't open file: " + this.filename);
        }
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            throw new LoggedException("Can't close file: " + this.filename);
        }
    }

    public boolean eof() {
        return this.eof;
    }

    public final synchronized int readInteger() {
        if (this.eof) {
            throw new LoggedException("Tried to read past end of file");
        }
        String string = "";
        int n = 0;
        try {
            string = this.reader.readLine();
            if (string == null) {
                this.eof = true;
            }
        }
        catch (IOException iOException) {
            throw new LoggedException("readInteger failed for file: " + this.filename);
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LoggedException(numberFormatException);
        }
        return n;
    }

    public final synchronized long readLong() {
        if (this.eof) {
            throw new LoggedException("Tried to read past end of file");
        }
        String string = "";
        long l = 0L;
        try {
            string = this.reader.readLine();
            if (string == null) {
                this.eof = true;
            }
        }
        catch (IOException iOException) {
            throw new LoggedException("readLong failed for file: " + this.filename);
        }
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LoggedException(numberFormatException);
        }
        return l;
    }

    public final synchronized double readDouble() {
        if (this.eof) {
            throw new LoggedException("Tried to read past end of file");
        }
        String string = "";
        double d = 0.0;
        try {
            string = this.reader.readLine();
            if (string == null) {
                this.eof = true;
            }
        }
        catch (IOException iOException) {
            throw new LoggedException("readDouble failed for file: " + this.filename);
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LoggedException(numberFormatException);
        }
        return d;
    }

    public final synchronized float readFloat() {
        if (this.eof) {
            throw new LoggedException("Tried to read past end of file");
        }
        String string = "";
        float f = 0.0f;
        try {
            string = this.reader.readLine();
            if (string == null) {
                this.eof = true;
            }
        }
        catch (IOException iOException) {
            throw new LoggedException("readFloat failed for file: " + this.filename);
        }
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LoggedException(numberFormatException);
        }
        return f;
    }

    public final synchronized char readCharacter() {
        if (this.eof) {
            throw new LoggedException("Tried to read past end of file");
        }
        char c = ' ';
        try {
            int n = this.reader.read();
            if (n == -1) {
                this.eof = true;
            } else {
                c = (char)n;
            }
        }
        catch (IOException iOException) {
            throw new LoggedException("readCharacter failed for file: " + this.filename);
        }
        return c;
    }

    public final synchronized String readString() {
        if (this.eof) {
            throw new LoggedException("Tried to read past end of file");
        }
        String string = "";
        try {
            string = this.reader.readLine();
            if (string == null) {
                this.eof = true;
            }
        }
        catch (IOException iOException) {
            throw new LoggedException("readString failed for file: " + this.filename);
        }
        return string;
    }
}

