/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import tools.LEFilterInputStream;

public class EndianNeutralDataInputStream
implements DataInput {
    private final DataInput reader;
    private final InputStream in;

    public EndianNeutralDataInputStream(InputStream inputStream, boolean bl) {
        this.in = inputStream;
        this.reader = bl ? new LEFilterInputStream(inputStream) : new DataInputStream(inputStream);
    }

    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.reader.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.reader.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.reader.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.reader.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.reader.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.reader.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.reader.readInt();
    }

    public long readUnsignedInt() throws IOException {
        int n = this.readInt();
        return (long)n & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() throws IOException {
        return this.reader.readLong();
    }

    @Override
    public String readUTF() throws IOException {
        return this.reader.readUTF();
    }

    @Override
    public final double readDouble() throws IOException {
        return this.reader.readDouble();
    }

    @Override
    public final float readFloat() throws IOException {
        return this.reader.readFloat();
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return this.reader.skipBytes(n);
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.reader.readFully(byArray);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.reader.readFully(byArray, n, n2);
    }

    @Override
    @Deprecated
    public final String readLine() throws IOException {
        throw new UnsupportedOperationException("Can't use this deprecated method");
    }
}

