/*
 * Decompiled with CFR 0.152.
 */
package tools;

import apps.SphFuncPD_Stats;
import data.BootstrapDataSynthFromInput;
import data.BootstrapDataSynthFromSimulationInput;
import data.BootstrapDataSynthesizer;
import data.DataSource;
import data.DataSynthFromBallStickInput;
import data.DataSynthFromDT_Input;
import data.DataSynthFromInput;
import data.DataSynthFromMultiTensorInput;
import data.DataSynthFromThreeTensorInput;
import data.DataSynthFromTwoTensorInput;
import data.DataSynthesizer;
import data.GaussianMixture;
import data.ModelPDF;
import data.OutputManager;
import data.StandardTestFunctions;
import data.SyntheticBootstrapper;
import data.VoxelOrderDW_DataSource;
import data.VoxelOrderDataSource;
import data.WildBS_DT_DataSynth;
import imaging.B_MatrixScheme;
import imaging.ImageHeader;
import imaging.Scheme;
import imaging.SchemeV0;
import imaging.SchemeV1;
import imaging.SchemeV3;
import inverters.ModelIndex;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Random;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Logger;
import misc.DT;
import misc.LoggedException;
import misc.SphericalPoints;
import numerics.MTRandom;
import numerics.Rotations;
import numerics.SphericalHarmonics;
import simulation.DiffusionSimulation;
import simulation.SimulationParams;
import simulation.dynamics.StepGeneratorFactory;
import sphfunc.MaxEntProfile;
import sphfunc.RBF_Sum;
import sphfunc.SphericalFunction;
import sphfunc.TuchRBF_Sum;
import tools.DB;
import tools.FileInput;

public class CL_Initializer {
    private static Logger logger = Logger.getLogger("camino.tools.CL_Initializer");
    public static final int BALLSTICKVALSPERVOXEL = 7;
    public static final int ONETENVALSPERVOXEL = 8;
    public static final int TWOTENVALSPERVOXEL = 17;
    public static final int THREETENVALSPERVOXEL = 24;
    public static int testFunction = -1;
    public static boolean nonStandardTestFunction = false;
    public static boolean brownianSimulation = false;
    public static SimulationParams simParams = null;
    public static double DIFF_CONST = 2.02E-9;
    public static double volFrac = 1.0;
    public static int[] dataDims = new int[]{0, 0, 0};
    public static double[] voxelDims = new double[]{0.0, 0.0, 0.0};
    public static double centreDist = 0.0;
    public static double[] testFunctionData = new double[0];
    public static ModelIndex[] inversionIndices = new ModelIndex[]{ModelIndex.LDT};
    public static int rotationIndex = 0;
    public static int numVoxels = 0;
    public static int sequenceIndex = 0;
    public static boolean sequenceIndexSet = false;
    public static double diffusionTime = -1.0;
    public static double lambda1 = -1.0;
    public static double dt2rotangle = 0.0;
    public static double dt2mix = -1.0;
    public static double scale = -1.0;
    public static int numElements = -1;
    public static int M = -1;
    public static int N = -1;
    public static double modQ = -1.0;
    public static double qScale = 1.0;
    public static double tauScale = 1.0;
    public static double SNR = -1.0;
    public static int bootstrap = -1;
    public static String wildBootstrapModel = null;
    public static String[] bsDataFiles = null;
    public static int seed = 36558013;
    public static String voxelClassMap = null;
    public static int maxTensorComponents = 2;
    public static double gamma_k = 1.84037;
    public static double gamma_beta = 7.8E-7;
    public static ModelIndex[][] classifiedModelIndices = new ModelIndex[][]{{ModelIndex.LDT}, {ModelIndex.LDT}, {ModelIndex.LDT}, {ModelIndex.POSPOS, ModelIndex.LDT}};
    public static String inputFile = null;
    public static String bgMaskFile = null;
    public static String schemeFile = null;
    public static double sigma = -1.0;
    public static String noiseType = "rician";
    public static String outlierMapFile = null;
    public static String noiseVarianceMapFile = null;
    public static String residualVectorMapFile = null;
    public static String matrixFile;
    public static boolean lrNormalize;
    public static boolean lrLog;
    public static String inputDataType;
    public static String bgMaskType;
    public static String inputModel;
    public static int basisType;
    public static int pointSetInd;
    public static boolean pointSetIndSet;
    public static int numPDsIO;
    public static int maxOrder;
    public static double f1;
    public static double f2;
    public static double f3;
    public static double[] kernelParams;
    public static int mePointSet;
    public static int skipEvery;
    public static double BACKGROUNDTHRESHOLD;
    public static double CSFTHRESHOLD;
    public static Scheme imPars;
    public static ModelPDF p;
    public static DataSource data;
    public static DataSource bgMask;
    private static boolean[] parsed;
    public static String transformFile;
    public static String transformFileX;
    public static String transformFileY;
    public static String transformFileZ;
    public static String reorientation;

    private CL_Initializer() {
    }

    public static void CL_init(String[] stringArray) {
        int n;
        int n2;
        parsed = new boolean[stringArray.length];
        for (n2 = 0; n2 < parsed.length; ++n2) {
            CL_Initializer.parsed[n2] = false;
        }
        n2 = 0;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            int n3;
            Object[] objectArray;
            if (stringArray[n].equals("-argfile")) {
                try {
                    stringArray = CL_Initializer.augmentArgs(stringArray, stringArray[n + 1]);
                    objectArray = new boolean[stringArray.length];
                    for (n3 = 0; n3 < n; ++n3) {
                        objectArray[n3] = parsed[n3];
                    }
                    for (n3 = n; n3 < objectArray.length; ++n3) {
                        objectArray[n3] = false;
                    }
                    parsed = objectArray;
                    CL_Initializer.markAsParsed(n);
                    CL_Initializer.markAsParsed(n + 1);
                }
                catch (Exception exception) {
                    throw new LoggedException(exception.toString() + "\nAttempting to continue...");
                }
            }
            if (stringArray[n].equals("-testfunc")) {
                testFunction = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-gaussmix")) {
                nonStandardTestFunction = true;
                int n4 = Integer.parseInt(stringArray[n + 1]);
                testFunctionData = new double[1 + n4 * 7];
                CL_Initializer.testFunctionData[0] = n4;
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
                for (n3 = 0; n3 < n4 * 7; ++n3) {
                    try {
                        CL_Initializer.testFunctionData[n3 + 1] = Double.parseDouble(stringArray[n + n3 + 2]);
                        CL_Initializer.parsed[n + n3 + 2] = true;
                        continue;
                    }
                    catch (Exception exception) {
                        throw new LoggedException("Enter {Dxx, Dxy, Dxz, Dyy, Dyz, Dzz, mix} for each component diffusion tensor.");
                    }
                }
            }
            if (stringArray[n].equals("-delta")) {
                throw new LoggedException("-delta option disabled.  Needs fixing.");
            }
            if (stringArray[n].equals("-rotation")) {
                rotationIndex = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-inversion")) {
                inversionIndices = ModelIndex.getIndices(new String[]{stringArray[n + 1]});
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-model")) {
                objectArray = new String[1000];
                n3 = 0;
                while (n3 + n + 1 < stringArray.length && !stringArray[n + n3 + 1].startsWith("-")) {
                    objectArray[n3] = stringArray[n + n3 + 1];
                    ++n3;
                }
                String[] stringArray2 = new String[n3];
                System.arraycopy(objectArray, 0, stringArray2, 0, n3);
                inversionIndices = ModelIndex.getIndices(stringArray2);
                CL_Initializer.markAsParsed(n, n3 + 1);
            }
            if (stringArray[n].equals("-bootstrap")) {
                bootstrap = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-seed")) {
                seed = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-voxels")) {
                numVoxels = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-bmx")) {
                sequenceIndex = Integer.parseInt(stringArray[n + 1]);
                sequenceIndexSet = true;
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-voxelelements")) {
                numElements = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-fixedmodq")) {
                M = Integer.parseInt(stringArray[n + 1]);
                N = Integer.parseInt(stringArray[n + 2]);
                modQ = Double.parseDouble(stringArray[n + 3]);
                diffusionTime = Double.parseDouble(stringArray[n + 4]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
                CL_Initializer.markAsParsed(n + 2);
                CL_Initializer.markAsParsed(n + 3);
                CL_Initializer.markAsParsed(n + 4);
            }
            if (stringArray[n].equals("-qscale")) {
                qScale = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-tau")) {
                diffusionTime = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-tauscale")) {
                tauScale = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-lambda1")) {
                lambda1 = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-scale")) {
                scale = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-dt2rotangle")) {
                dt2rotangle = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-dt2mix")) {
                dt2mix = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-snr")) {
                SNR = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-outputfile")) {
                OutputManager.outputFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-gzip")) {
                OutputManager.gzipOut = true;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equals("-inputfile")) {
                inputFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-bsdatafiles")) {
                objectArray = new String[1000];
                n3 = 0;
                while (n3 + n + 1 < stringArray.length && !stringArray[n3 + n + 1].startsWith("-")) {
                    objectArray[n3] = stringArray[n + n3 + 1];
                    ++n3;
                }
                bsDataFiles = new String[n3];
                bootstrap = n3;
                System.arraycopy(objectArray, 0, bsDataFiles, 0, n3);
                CL_Initializer.markAsParsed(n, n3 + 1);
            }
            if (stringArray[n].equals("-wildbsmodel")) {
                wildBootstrapModel = stringArray[n + 1];
                bootstrap = 1;
                CL_Initializer.markAsParsed(n, 2);
            }
            if (stringArray[n].equals("-bgmask")) {
                bgMaskFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-schemefile")) {
                schemeFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-voxclassmap")) {
                voxelClassMap = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-outliermap")) {
                outlierMapFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-noisemap")) {
                noiseVarianceMapFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-residualmap")) {
                residualVectorMapFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-matrix")) {
                matrixFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-normalize")) {
                lrNormalize = true;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equals("-log")) {
                lrLog = true;
                CL_Initializer.markAsParsed(n);
            }
            if (stringArray[n].equals("-sigma")) {
                sigma = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-noisetype")) {
                noiseType = stringArray[n + 1].toLowerCase();
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-inputdatatype")) {
                inputDataType = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-outputdatatype")) {
                OutputManager.outputDataType = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-maskdatatype")) {
                bgMaskType = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-inputmodel")) {
                inputModel = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-basistype")) {
                if (stringArray[n + 1].equals("rbf")) {
                    basisType = 1;
                } else if (stringArray[n + 1].equals("sh")) {
                    basisType = 2;
                } else {
                    throw new LoggedException("Unrecognized basis type: " + stringArray[n + 1]);
                }
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-order")) {
                maxOrder = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-pointset")) {
                pointSetInd = Integer.parseInt(stringArray[n + 1]);
                pointSetIndSet = true;
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-maxcomponents")) {
                maxTensorComponents = Integer.parseInt(stringArray[n + 1]);
                bl = true;
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-classifiedmodels")) {
                int n5 = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
                String[] stringArray3 = new String[n5];
                for (int i = 0; i < n5; ++i) {
                    stringArray3[i] = stringArray[n + 2 + i];
                    CL_Initializer.markAsParsed(n + 2 + i);
                }
                classifiedModelIndices = ModelIndex.getClassifiedModelIndices(stringArray3);
            }
            if (stringArray[n].equals("-rbfpointset")) {
                RBF_Sum.setPoints(SphericalPoints.getElecPointSet(Integer.parseInt(stringArray[n + 1])));
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-rbfsigma")) {
                TuchRBF_Sum.setSigma(Double.parseDouble(stringArray[n + 1]));
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-filter")) {
                CL_Initializer.markAsParsed(n);
                if (stringArray[n + 1].equals("SPIKE")) {
                    kernelParams = new double[2];
                    CL_Initializer.kernelParams[0] = 0.0;
                    CL_Initializer.kernelParams[1] = Double.parseDouble(stringArray[n + 2]);
                    CL_Initializer.markAsParsed(n + 1);
                    CL_Initializer.markAsParsed(n + 2);
                } else if (stringArray[n + 1].equals("PAS")) {
                    kernelParams = new double[2];
                    CL_Initializer.kernelParams[0] = 1.0;
                    CL_Initializer.kernelParams[1] = Double.parseDouble(stringArray[n + 2]);
                    CL_Initializer.markAsParsed(n + 1);
                    CL_Initializer.markAsParsed(n + 2);
                } else if (stringArray[n + 1].equals("TENSOR")) {
                    CL_Initializer.kernelParams[0] = 2.0;
                    CL_Initializer.kernelParams[1] = Double.parseDouble(stringArray[n + 2]);
                    CL_Initializer.markAsParsed(n + 1);
                    CL_Initializer.markAsParsed(n + 2);
                } else {
                    throw new LoggedException("Unrecognized filter type: " + stringArray[n + 1]);
                }
            }
            if (stringArray[n].equals("-mepointset")) {
                mePointSet = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-ftest")) {
                f1 = Double.parseDouble(stringArray[n + 1]);
                f2 = Double.parseDouble(stringArray[n + 2]);
                f3 = Double.parseDouble(stringArray[n + 3]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
                CL_Initializer.markAsParsed(n + 2);
                CL_Initializer.markAsParsed(n + 3);
            }
            if (stringArray[n].equals("-bgthresh")) {
                BACKGROUNDTHRESHOLD = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-csfthresh")) {
                CSFTHRESHOLD = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-numpds")) {
                numPDsIO = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
                n2 = 1;
            }
            if (stringArray[n].equals("-density")) {
                SphFuncPD_Stats.setDensity(Integer.parseInt(stringArray[n + 1]));
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-searchradius")) {
                SphericalFunction.setSearchRadius(Double.parseDouble(stringArray[n + 1]));
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-paramscale")) {
                SphericalFunction.SFPD_PARAMSCALE = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-meanthreshscale")) {
                SphFuncPD_Stats.setPdThresh(Double.parseDouble(stringArray[n + 1]));
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-stdthresh")) {
                SphFuncPD_Stats.setStdsFromMeanF(Double.parseDouble(stringArray[n + 1]));
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-nooutput")) {
                SphFuncPD_Stats.setNoOutput(true);
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-v")) {
                DB.setVerbosity(Integer.parseInt(stringArray[n + 1]));
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-trans")) {
                transformFile = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-xtrans")) {
                transformFileX = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-ytrans")) {
                transformFileY = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-ztrans")) {
                transformFileZ = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-reorientation")) {
                reorientation = stringArray[n + 1];
                CL_Initializer.markAsParsed(n);
                CL_Initializer.markAsParsed(n + 1);
            }
            if (stringArray[n].equals("-gamma")) {
                gamma_k = Double.parseDouble(stringArray[n + 1]);
                gamma_beta = Double.parseDouble(stringArray[n + 2]);
                CL_Initializer.markAsParsed(n, 3);
            }
            if (stringArray[n].equals("-walkers")) {
                SimulationParams.sim_N_walkers = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-tmax")) {
                SimulationParams.sim_tmax = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-p")) {
                SimulationParams.sim_p = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-G")) {
                SimulationParams.sim_G = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                SimulationParams.sim_G_set = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-del")) {
                SimulationParams.sim_delta = Double.parseDouble(stringArray[n + 1]);
                SimulationParams.sim_delta_set = true;
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-DEL")) {
                SimulationParams.sim_DELTA = Double.parseDouble(stringArray[n + 1]);
                SimulationParams.sim_DELTA_set = true;
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-diffusivity")) {
                DIFF_CONST = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-D1")) {
                SimulationParams.sim_cyl_D1 = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-D2")) {
                SimulationParams.sim_cyl_D2 = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-crossangle")) {
                SimulationParams.sim_cAngle = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-compartmentsignal")) {
                if (stringArray[n + 1].equalsIgnoreCase("EXTRAONLY")) {
                    SimulationParams.sim_compartmentSignal = 1;
                    brownianSimulation = true;
                    CL_Initializer.markAsParsed(n, 2);
                }
                if (stringArray[n + 1].equalsIgnoreCase("INTRAONLY")) {
                    SimulationParams.sim_compartmentSignal = 2;
                    brownianSimulation = true;
                    CL_Initializer.markAsParsed(n, 2);
                }
                if (!stringArray[n + 1].equalsIgnoreCase("ALL")) continue;
                SimulationParams.sim_compartmentSignal = 3;
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-volfrac")) {
                volFrac = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-gridsize") || stringArray[n].equals("-datadims")) {
                CL_Initializer.dataDims[0] = Integer.parseInt(stringArray[n + 1]);
                CL_Initializer.dataDims[1] = Integer.parseInt(stringArray[n + 2]);
                CL_Initializer.dataDims[2] = Integer.parseInt(stringArray[n + 3]);
                CL_Initializer.markAsParsed(n, 4);
                continue;
            }
            if (stringArray[n].equals("-voxeldims")) {
                CL_Initializer.voxelDims[0] = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.voxelDims[1] = Double.parseDouble(stringArray[n + 2]);
                CL_Initializer.voxelDims[2] = Double.parseDouble(stringArray[n + 3]);
                CL_Initializer.markAsParsed(n, 4);
                continue;
            }
            if (stringArray[n].equals("-centredist")) {
                centreDist = Double.parseDouble(stringArray[n + 1]);
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-initial")) {
                if (stringArray[n + 1].equalsIgnoreCase("uniform")) {
                    SimulationParams.sim_initial = 1;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("spike") || stringArray[n + 1].equalsIgnoreCase("delta")) {
                    SimulationParams.sim_initial = 0;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("special")) {
                    SimulationParams.sim_initial = 2;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("intra")) {
                    SimulationParams.sim_initial = 3;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("extra")) {
                    SimulationParams.sim_initial = 4;
                    CL_Initializer.markAsParsed(n + 1);
                } else {
                    logger.warning("simulation initial conditions '" + stringArray[n + 1] + "' default value (UNIFORM) will be used");
                }
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-duration")) {
                SimulationParams.duration = Double.parseDouble(stringArray[n + 1]);
                SimulationParams.trajectories = true;
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-trajfile")) {
                SimulationParams.trajFile = stringArray[n + 1];
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-separateruns")) {
                SimulationParams.sim_separate_runs = true;
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-facets")) {
                SimulationParams.sim_num_facets = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-geometry") || stringArray[n].equals("-substrate")) {
                if (stringArray[n + 1].equalsIgnoreCase("cell-iso")) {
                    SimulationParams.sim_geomType = 0;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("cell-striped")) {
                    SimulationParams.sim_geomType = 1;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("cell-fixedfrac")) {
                    SimulationParams.sim_geomType = 3;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("cell-modular")) {
                    SimulationParams.sim_geomType = 2;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("cell-perc")) {
                    SimulationParams.sim_geomType = 4;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("cylinder")) {
                    SimulationParams.sim_geomType = 5;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("inflammation")) {
                    SimulationParams.sim_geomType = 7;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("facetted")) {
                    SimulationParams.sim_geomType = 8;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("ply")) {
                    SimulationParams.sim_geomType = 9;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("percolation")) {
                    SimulationParams.sim_geomType = 10;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("myelinated")) {
                    SimulationParams.sim_geomType = 11;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("crossing")) {
                    SimulationParams.sim_geomType = 12;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("distribcylinder")) {
                    SimulationParams.sim_geomType = 6;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("empty")) {
                    SimulationParams.sim_geomType = 13;
                    CL_Initializer.markAsParsed(n + 1);
                } else {
                    logger.warning("unrecognised geometry type '" + stringArray[n + 1] + "' will use default");
                }
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-substrateinfo")) {
                SimulationParams.substrateInfo = true;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-packing")) {
                if (stringArray[n + 1].equalsIgnoreCase("square")) {
                    SimulationParams.sim_cyl_pack = 1;
                    CL_Initializer.markAsParsed(n + 1);
                } else if (stringArray[n + 1].equalsIgnoreCase("hex")) {
                    SimulationParams.sim_cyl_pack = 2;
                    CL_Initializer.markAsParsed(n + 1);
                } else {
                    logger.warning("cylinder packing '" + stringArray[n + 1] + "' not supported. will default to hexagonal packing");
                }
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-numcylinders")) {
                SimulationParams.sim_cyl_dist_size = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-cylinderminrad")) {
                SimulationParams.sim_cyl_min_r = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-cylindermaxrad")) {
                SimulationParams.sim_cyl_max_r = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-cylinderrad")) {
                SimulationParams.sim_cyl_r = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-cylinderinnerrad")) {
                SimulationParams.sim_cyl_r1 = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-cylindersep")) {
                SimulationParams.sim_cyl_R = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-increments")) {
                SimulationParams.sim_inflamm_increments = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-onlyrun")) {
                SimulationParams.sim_onlyRun = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-voxelsize")) {
                SimulationParams.sim_voxelSize = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-plyfile")) {
                SimulationParams.sim_plyfile = new String(stringArray[n + 1]);
                String string = SimulationParams.sim_plyfile.substring(SimulationParams.sim_plyfile.length() - 4);
                if (!string.equalsIgnoreCase(".ply")) {
                    SimulationParams.sim_plyfile = SimulationParams.sim_plyfile + ".ply";
                }
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-steptype")) {
                if (stringArray[n + 1].equals("fixedlength")) {
                    SimulationParams.sim_stepType = 1;
                    CL_Initializer.markAsParsed(n + 1);
                } else {
                    logger.warning("step type '" + stringArray[n + 1] + "' unknown. default " + "(fixedlegnth) generator will be used");
                }
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n);
                continue;
            }
            if (stringArray[n].equals("-substratesize")) {
                SimulationParams.sim_L = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-latticesize")) {
                SimulationParams.sim_L = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-cellsize")) {
                SimulationParams.sim_l = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-stripethickness")) {
                SimulationParams.sim_stripethickness = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-pperc")) {
                SimulationParams.sim_p_perc = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-fixedfrac")) {
                SimulationParams.sim_fixedFrac = Double.parseDouble(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (stringArray[n].equals("-modfill")) {
                SimulationParams.sim_modFill = Integer.parseInt(stringArray[n + 1]);
                brownianSimulation = true;
                CL_Initializer.markAsParsed(n, 2);
                continue;
            }
            if (!stringArray[n].equals("-modfree")) continue;
            SimulationParams.sim_modFree = Integer.parseInt(stringArray[n + 1]);
            brownianSimulation = true;
            CL_Initializer.markAsParsed(n, 2);
        }
        if (n2 == 0 && inputModel != null) {
            if (inputModel.equals("dt")) {
                numPDsIO = 1;
            } else if (inputModel.equals("twotensor")) {
                numPDsIO = 2;
            } else if (inputModel.equals("threetensor")) {
                numPDsIO = 3;
            } else if (inputModel.equals("pico")) {
                numPDsIO = 1;
            } else if (inputModel.equals("ballstick")) {
                numPDsIO = 1;
            } else if (inputModel.equals("bayesdirac")) {
                numPDsIO = 1;
            } else if (inputModel.equals("multitensor")) {
                numPDsIO = maxTensorComponents;
            }
        } else if (n2 != 0 && inputModel != null) {
            n = 0;
            if (inputModel.equals("dt")) {
                if (numPDsIO != 1) {
                    n = 1;
                }
            } else if (inputModel.equals("twotensor")) {
                if (numPDsIO != 2) {
                    n = 1;
                }
            } else if (inputModel.equals("threetensor")) {
                if (numPDsIO != 3) {
                    n = 1;
                }
            } else if (inputModel.equals("ballstick") && numPDsIO != 1) {
                n = 1;
            }
            if (n != 0) {
                throw new LoggedException("Wrong number of PDs (" + numPDsIO + ") specified for input model " + inputModel);
            }
        }
        if (!bl && inputModel != null) {
            if (inputModel.equals("dt")) {
                maxTensorComponents = 1;
            } else if (inputModel.equals("twotensor")) {
                maxTensorComponents = 2;
            } else if (inputModel.equals("threetensor")) {
                maxTensorComponents = 3;
            }
        } else if (bl && inputModel != null) {
            n = 0;
            if (inputModel.equals("dt")) {
                if (maxTensorComponents != 1) {
                    n = 1;
                }
            } else if (inputModel.equals("twotensor")) {
                if (maxTensorComponents != 2) {
                    n = 1;
                }
            } else if (inputModel.equals("threetensor") && maxTensorComponents != 3) {
                n = 1;
            }
            if (n != 0) {
                throw new LoggedException("Wrong number of tensor components (" + maxTensorComponents + ") specified for input model " + inputModel);
            }
        }
    }

    public static final void checkParsing(String[] stringArray) {
        if (parsed == null) {
            RuntimeException runtimeException = new RuntimeException("attempt to check command line argument parsing made before parsing has been attempted!");
            StackTraceElement[] stackTraceElementArray = runtimeException.getStackTrace();
            String string = new String();
            logger.severe(runtimeException.toString());
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                string = string + stackTraceElementArray[i] + "\n";
            }
            logger.severe(string);
            throw runtimeException;
        }
        for (int i = 0; i < parsed.length; ++i) {
            if (parsed[i]) continue;
            logger.warning("WARNING: couldn't parse arg " + i + ": '" + stringArray[i] + "'");
        }
    }

    public static String[] augmentArgs(String[] stringArray, String string) throws FileNotFoundException {
        int n;
        Scanner scanner = new Scanner(new File(string));
        Vector<String> vector = new Vector<String>();
        while (scanner.hasNext()) {
            vector.add(scanner.next());
        }
        scanner.close();
        String[] stringArray2 = new String[stringArray.length + vector.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = stringArray[n];
        }
        for (n = 0; n < vector.size(); ++n) {
            stringArray2[stringArray.length + n] = (String)vector.elementAt(n);
        }
        return stringArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initImagingScheme() {
        if (M >= 0) {
            imPars = new SchemeV0(M, N, qScale * modQ, tauScale * diffusionTime);
            return;
        } else if (schemeFile != null) {
            int n = CL_Initializer.getSchemeVersion(schemeFile);
            if (n == 0) {
                imPars = new SchemeV0(schemeFile, qScale, tauScale);
                return;
            } else if (n == 1) {
                imPars = new SchemeV1(schemeFile);
                return;
            } else if (n == 2) {
                imPars = new B_MatrixScheme(schemeFile);
                return;
            } else {
                if (n != 3) throw new LoggedException("unsupported scheme file format " + n);
                imPars = new SchemeV3(schemeFile);
            }
            return;
        } else {
            if (sequenceIndex < 0) return;
            if (!sequenceIndexSet) {
                logger.warning("Scheme file not specified, defaulting to sequence index 0");
            }
            imPars = SchemeV0.getSchemeV0(sequenceIndex, qScale, tauScale);
        }
    }

    public static int getSchemeVersion(String string) {
        FileInput fileInput = new FileInput(string);
        String string2 = fileInput.readString().trim();
        fileInput.close();
        if (string2.equals("VERSION: 1")) {
            return 1;
        }
        if (string2.equals("VERSION: 2")) {
            return 2;
        }
        if (string2.equals("VERSION: 3")) {
            SimulationParams.scanType = 1;
            return 3;
        }
        return 0;
    }

    public static void initMaxEnt() {
        if (mePointSet > 0) {
            MaxEntProfile.setReconDirs(SphericalPoints.getElecPointSet(mePointSet));
        } else {
            MaxEntProfile.setReconDirs(imPars.getNormNonZeroQs());
        }
    }

    public static void setDataSource(DataSource dataSource) {
        data = dataSource;
    }

    public static void setMaskSource(DataSource dataSource) {
        bgMask = dataSource;
    }

    public static void initSphFuncDataSource() {
        if (inputModel == null) {
            data = new VoxelOrderDW_DataSource(inputFile, inputDataType, imPars);
        } else if (inputModel.equals("dt")) {
            data = new VoxelOrderDataSource(inputFile, 8, inputDataType);
        } else if (inputModel.equals("ballstick")) {
            data = new VoxelOrderDataSource(inputFile, 7, inputDataType);
        } else if (inputModel.equals("sh")) {
            data = new VoxelOrderDataSource(inputFile, SphericalHarmonics.evenFuncsUpTo(maxOrder) + 2, inputDataType);
        } else if (inputModel.equals("rbf")) {
            data = new VoxelOrderDataSource(inputFile, RBF_Sum.numPoints() + 2, inputDataType);
        } else if (inputModel.equals("maxent")) {
            data = new VoxelOrderDataSource(inputFile, MaxEntProfile.numLambdas() + 2, inputDataType);
        } else {
            RuntimeException runtimeException = new RuntimeException("Unknown input model type: " + inputModel);
            StackTraceElement[] stackTraceElementArray = runtimeException.getStackTrace();
            String string = new String();
            logger.severe(runtimeException.toString());
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                string = string + stackTraceElementArray[i] + "\n";
            }
            logger.severe(string);
            throw runtimeException;
        }
        CL_Initializer.initMaskSource();
    }

    public static void initTensorDataSource() {
        if (inputModel.equals("dt")) {
            data = new VoxelOrderDataSource(inputFile, 8, inputDataType);
        } else if (inputModel.equals("twotensor")) {
            data = new VoxelOrderDataSource(inputFile, 17, inputDataType);
        } else if (inputModel.equals("threetensor")) {
            data = new VoxelOrderDataSource(inputFile, 24, inputDataType);
        } else if (inputModel.equals("multitensor")) {
            data = new VoxelOrderDataSource(inputFile, 3 + 7 * maxTensorComponents, inputDataType);
        } else {
            throw new LoggedException("Cannot process non-tensor data from model: " + inputModel);
        }
        CL_Initializer.initMaskSource();
    }

    public static void initMaskSource() {
        if (bgMaskFile != null) {
            if (ImageHeader.imageExists(bgMaskFile)) {
                ImageHeader imageHeader = null;
                try {
                    imageHeader = ImageHeader.readHeader(bgMaskFile);
                }
                catch (IOException iOException) {
                    throw new LoggedException("Cannot read mask header " + bgMaskFile);
                }
                bgMask = imageHeader.getImageDataSource();
            } else {
                bgMask = new VoxelOrderDataSource(bgMaskFile, 1, bgMaskType);
            }
        }
    }

    public static Object[] getGeometryParams(int n) {
        if (SimulationParams.sim_geomType == 0) {
            return new Object[]{new Double(SimulationParams.sim_l), new Integer((int)SimulationParams.sim_L)};
        }
        if (SimulationParams.sim_geomType == 1) {
            return new Object[]{new Double(SimulationParams.sim_l), new Integer((int)SimulationParams.sim_L), new Integer(SimulationParams.sim_stripethickness)};
        }
        if (SimulationParams.sim_geomType == 4) {
            return new Object[]{new Double(SimulationParams.sim_l), new Integer((int)SimulationParams.sim_L), new Double(SimulationParams.sim_p_perc)};
        }
        if (SimulationParams.sim_geomType == 2) {
            return new Object[]{new Double(SimulationParams.sim_l), new Integer((int)SimulationParams.sim_L), new Integer(SimulationParams.sim_modFill), new Integer(SimulationParams.sim_modFree)};
        }
        if (SimulationParams.sim_geomType == 3) {
            return new Object[]{new Double(SimulationParams.sim_l), new Integer((int)SimulationParams.sim_L), new Double(SimulationParams.sim_fixedFrac)};
        }
        if (SimulationParams.sim_geomType == 5) {
            return new Object[]{new Double(SimulationParams.sim_cyl_R), new Double(SimulationParams.sim_cyl_r), new Integer(SimulationParams.sim_cyl_pack)};
        }
        if (SimulationParams.sim_geomType == 6) {
            return new Object[]{new Double(SimulationParams.sim_L), new Integer(SimulationParams.sim_cyl_dist_size), new Double(gamma_k), new Double(gamma_beta)};
        }
        if (SimulationParams.sim_geomType == 7) {
            return new Object[]{new Double(gamma_k), new Double(gamma_beta), new Integer(SimulationParams.sim_cyl_dist_size), new Integer(numVoxels), new Integer(SimulationParams.sim_inflamm_increments), new Double(SimulationParams.sim_L)};
        }
        if (SimulationParams.sim_geomType == 8) {
            return new Object[]{new Double(SimulationParams.sim_cyl_R), new Double(SimulationParams.sim_cyl_r), new Integer(SimulationParams.sim_num_facets)};
        }
        if (SimulationParams.sim_geomType == 9) {
            return new Object[]{new String(SimulationParams.sim_plyfile), new Double(SimulationParams.sim_cyl_r), new Double(SimulationParams.sim_cyl_R)};
        }
        if (SimulationParams.sim_geomType == 10) {
            return new Object[]{new Double(SimulationParams.sim_cyl_min_r), new Double(SimulationParams.sim_cyl_max_r), new Integer(SimulationParams.sim_cyl_dist_size), new Integer(numVoxels), new Integer(SimulationParams.sim_inflamm_increments), new Double(SimulationParams.sim_L), new Integer(SimulationParams.sim_spatial_grid_size)};
        }
        if (SimulationParams.sim_geomType == 12) {
            return new Object[]{new Double(SimulationParams.sim_cyl_R), new Double(SimulationParams.sim_cyl_r)};
        }
        if (SimulationParams.sim_geomType == 11) {
            return new Object[]{new Double(SimulationParams.sim_cyl_R), new Double(SimulationParams.sim_cyl_r1), new Double(SimulationParams.sim_cyl_r), new Double(SimulationParams.sim_cyl_D1), new Double(SimulationParams.sim_cyl_D2), new Double(SimulationParams.sim_p), new Integer(SimulationParams.sim_cyl_pack)};
        }
        if (SimulationParams.sim_geomType == 13) {
            return new Object[0];
        }
        logger.warning("unrecognised geometry type " + SimulationParams.sim_geomType + "returning null parameters array");
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initDataSynthesizer() {
        if (testFunction >= 0) {
            if (rotationIndex > 0) {
                StandardTestFunctions.setTransformation(Rotations.randomRotMat(new Random(rotationIndex)));
            }
            if (scale > 0.0) {
                StandardTestFunctions.setScale(scale);
            }
            if (dt2rotangle != 0.0) {
                StandardTestFunctions.setDT2RotationAngle(dt2rotangle);
            }
            if (dt2mix > 0.0) {
                StandardTestFunctions.setMix3(1.0 - dt2mix);
            }
            if (lambda1 > 0.0) {
                StandardTestFunctions.setLambda1(lambda1);
            }
            p = StandardTestFunctions.getFunction(testFunction);
        }
        if (nonStandardTestFunction) {
            p = CL_Initializer.constructTestFunction(testFunctionData);
        }
        if (p != null) {
            if (bootstrap > 0 && wildBootstrapModel != null) {
                DataSource dataSource = CL_Initializer.getDataSynthesizer(p, imPars, SNR, 1, seed, -1);
                if (!wildBootstrapModel.equals("dt")) throw new LoggedException("Wild bootstrap is not supported for model: " + wildBootstrapModel);
                data = new WildBS_DT_DataSynth(dataSource, imPars, numVoxels, seed);
                return;
            } else {
                data = CL_Initializer.getDataSynthesizer(p, imPars, SNR, numVoxels, seed, bootstrap);
            }
            return;
        } else if (inputModel == null) {
            if (brownianSimulation) {
                Object var0_1 = null;
                Object[] objectArray = CL_Initializer.getGeometryParams(SimulationParams.sim_geomType);
                simParams = SimulationParams.trajectories ? new SimulationParams(SimulationParams.sim_N_walkers, SimulationParams.sim_tmax, SimulationParams.sim_p, SimulationParams.sim_initial, SimulationParams.sim_geomType, objectArray, SimulationParams.sim_stepType, SimulationParams.sim_voxelSize, SimulationParams.duration) : new SimulationParams(SimulationParams.sim_N_walkers, SimulationParams.sim_tmax, SimulationParams.sim_p, SimulationParams.sim_initial, SimulationParams.sim_geomType, objectArray, SimulationParams.sim_stepType, SimulationParams.sim_voxelSize, imPars);
                double[] dArray = StepGeneratorFactory.getStepParamsArray(SimulationParams.sim_stepType, simParams, imPars);
                simParams.setStepParams(dArray);
                if (bootstrap > 0) {
                    int n = numVoxels;
                    numVoxels = bootstrap;
                    DiffusionSimulation diffusionSimulation = new DiffusionSimulation(simParams, imPars);
                    numVoxels = n;
                    if (wildBootstrapModel != null) {
                        if (!wildBootstrapModel.equals("dt")) throw new LoggedException("Wild bootstrap is not supported for model: " + wildBootstrapModel);
                        data = new WildBS_DT_DataSynth(data, imPars, numVoxels, seed);
                    }
                    data = new BootstrapDataSynthFromSimulationInput(diffusionSimulation, bootstrap, imPars.numMeasurements(), numVoxels, seed);
                    return;
                } else {
                    data = SimulationParams.trajectories ? new DiffusionSimulation(simParams) : new DiffusionSimulation(simParams, imPars);
                }
                return;
            } else if (bootstrap > 0) {
                if (SNR > -1.0) {
                    logger.warning("Cannot set SNR when bootstrapping raw data.Program will continue but will not add noise");
                }
                if (wildBootstrapModel != null) {
                    data = new VoxelOrderDW_DataSource(inputFile, inputDataType, imPars);
                    if (!wildBootstrapModel.equals("dt")) throw new LoggedException("Wild bootstrap is not supported for model: " + wildBootstrapModel);
                    data = new WildBS_DT_DataSynth(data, imPars, numVoxels, seed);
                    return;
                } else {
                    data = new BootstrapDataSynthesizer(bsDataFiles, imPars.numMeasurements(), numVoxels, inputDataType, seed);
                }
                return;
            } else {
                data = new VoxelOrderDW_DataSource(inputFile, inputDataType, imPars);
                CL_Initializer.initMaskSource();
            }
            return;
        } else if (bootstrap > 0) {
            void var0_9;
            Object var0_3 = null;
            double d = -1.0;
            if (wildBootstrapModel != null) {
                d = SNR;
            }
            if (inputModel.equals("dt")) {
                DataSynthFromDT_Input dataSynthFromDT_Input = new DataSynthFromDT_Input(inputFile, inputDataType, imPars, d, seed);
            } else if (inputModel.equals("twotensor")) {
                DataSynthFromTwoTensorInput dataSynthFromTwoTensorInput = new DataSynthFromTwoTensorInput(inputFile, inputDataType, imPars, d, seed);
            } else if (inputModel.equals("threetensor")) {
                DataSynthFromThreeTensorInput dataSynthFromThreeTensorInput = new DataSynthFromThreeTensorInput(inputFile, inputDataType, imPars, d, seed);
            } else if (inputModel.equals("multitensor")) {
                DataSynthFromMultiTensorInput dataSynthFromMultiTensorInput = new DataSynthFromMultiTensorInput(inputFile, inputDataType, imPars, maxTensorComponents, d, seed);
            } else {
                if (!inputModel.equals("ballstick")) throw new LoggedException("Unrecognized input model: " + inputModel);
                DataSynthFromBallStickInput dataSynthFromBallStickInput = new DataSynthFromBallStickInput(inputFile, inputDataType, imPars, d, seed);
            }
            if (wildBootstrapModel != null) {
                if (!wildBootstrapModel.equals("dt")) throw new LoggedException("Wild bootstrap is not supported for model: " + wildBootstrapModel);
                data = new WildBS_DT_DataSynth((DataSource)var0_9, imPars, numVoxels, seed);
                return;
            } else {
                data = new BootstrapDataSynthFromInput((DataSynthFromInput)var0_9, bootstrap, imPars, numVoxels, SNR, seed);
            }
            return;
        } else if (inputModel.equals("dt")) {
            data = new DataSynthFromDT_Input(inputFile, inputDataType, imPars, SNR, seed);
            return;
        } else if (inputModel.equals("twotensor")) {
            data = new DataSynthFromTwoTensorInput(inputFile, inputDataType, imPars, SNR, seed);
            return;
        } else if (inputModel.equals("threetensor")) {
            data = new DataSynthFromThreeTensorInput(inputFile, inputDataType, imPars, SNR, seed);
            return;
        } else if (inputModel.equals("multitensor")) {
            data = new DataSynthFromMultiTensorInput(inputFile, inputDataType, imPars, maxTensorComponents, SNR, seed);
            return;
        } else if (inputModel.equals("ballstick")) {
            data = new DataSynthFromBallStickInput(inputFile, inputDataType, imPars, SNR, seed);
            return;
        } else {
            if (inputModel.equals("sh") || inputModel.equals("rbf")) return;
            throw new LoggedException("Unrecognized input model: " + inputModel);
        }
    }

    public static ModelPDF constructTestFunction(double[] dArray) {
        int n = (int)dArray[0];
        DT[] dTArray = new DT[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dTArray[i] = new DT(dArray[i * 7 + 1], dArray[i * 7 + 2], dArray[i * 7 + 3], dArray[i * 7 + 4], dArray[i * 7 + 5], dArray[i * 7 + 6]);
            dArray2[i] = dArray[i * 7 + 7];
            if (rotationIndex <= 0) continue;
            dTArray[i] = dTArray[i].transform(Rotations.randomRotMat(new Random(rotationIndex)));
        }
        GaussianMixture gaussianMixture = new GaussianMixture(dTArray, dArray2);
        return gaussianMixture;
    }

    public static DataSource getDataSynthesizer(ModelPDF modelPDF, Scheme scheme, double d, int n, int n2, int n3) {
        DataSource dataSource = null;
        if (n3 <= 0) {
            MTRandom mTRandom = new MTRandom(n2);
            dataSource = new DataSynthesizer(modelPDF, scheme, d, n, mTRandom);
        } else {
            dataSource = new SyntheticBootstrapper(modelPDF, scheme, d, n3, n, n2);
        }
        return dataSource;
    }

    public static final void markAsParsed(int n) {
        CL_Initializer.markAsParsed(n, 1);
    }

    public static final void markAsParsed(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            CL_Initializer.parsed[n + i] = true;
        }
    }

    public static void exceptionTest() throws Exception {
        throw new Exception("test exception thrown");
    }

    static {
        lrNormalize = false;
        lrLog = false;
        inputDataType = "float";
        bgMaskType = "short";
        inputModel = null;
        basisType = 1;
        pointSetInd = 3;
        pointSetIndSet = false;
        numPDsIO = 3;
        maxOrder = 4;
        f1 = -1.0;
        f2 = -1.0;
        f3 = -1.0;
        kernelParams = new double[]{0.0, 1.0};
        mePointSet = -1;
        skipEvery = -1;
        BACKGROUNDTHRESHOLD = 0.0;
        CSFTHRESHOLD = -1.0;
        imPars = null;
        p = null;
        data = null;
        bgMask = null;
        parsed = null;
        transformFile = null;
        transformFileX = null;
        transformFileY = null;
        transformFileZ = null;
        reorientation = "ppd";
    }
}

