/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.util.Arrays;
import misc.LoggedException;

public class ArrayOps {
    public static double max(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d = dArray[i] > d ? dArray[i] : d;
        }
        return d;
    }

    public static double min(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d = dArray[i] < d ? dArray[i] : d;
        }
        return d;
    }

    public static double mean(double[] dArray) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d / (double)dArray.length;
    }

    public static double sum(double[] dArray) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double weightedMean(double[] dArray, double[] dArray2) {
        if (dArray.length == 0) {
            return 0.0;
        }
        if (dArray.length != dArray2.length) {
            throw new LoggedException("Number of elements must match number of weights");
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
            d2 += dArray2[i];
            if (!(dArray2[i] < 0.0)) continue;
            throw new LoggedException("Weights must be non-negative");
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public static double geoMean(double[] dArray) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d = 1.0;
        for (int i = 0; i < dArray.length; ++i) {
            d *= dArray[i];
        }
        d = Math.pow(d, 1.0 / (double)dArray.length);
        return d;
    }

    public static double median(double[] dArray) {
        if (dArray.length == 0) {
            return 0.0;
        }
        int n = dArray.length;
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        Arrays.sort(dArray2);
        if (n % 2 == 0) {
            return (dArray2[n / 2 - 1] + dArray2[n / 2]) / 2.0;
        }
        return dArray2[n / 2];
    }

    public static double var(double[] dArray, double d) {
        if (dArray.length < 2) {
            return 0.0;
        }
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += (dArray[i] - d) * (dArray[i] - d);
        }
        return d2 /= (double)dArray.length - 1.0;
    }

    public static double weightedVar(double[] dArray, double[] dArray2, double d) {
        if (dArray.length < 2) {
            return 0.0;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray2[i] * (dArray[i] - d) * (dArray[i] - d);
            d3 += dArray2[i];
            if (!(dArray2[i] < 0.0)) continue;
            throw new LoggedException("Weights must be non-negative");
        }
        if ((d3 /= (double)dArray.length) == 0.0) {
            return 0.0;
        }
        return d2 /= d3 * ((double)dArray.length - 1.0);
    }
}

