/*
 * Decompiled with CFR 0.152.
 */
package sphfunc;

import sphfunc.LinearBasisFunction;

public class TuchRBF
extends LinearBasisFunction {
    private double[] p = new double[3];
    private double sigma;

    public TuchRBF(double[] dArray, double d) {
        for (int i = 0; i < 3; ++i) {
            this.p[i] = dArray[i];
        }
        this.sigma = d;
    }

    @Override
    public double getRadius(double d, double d2, double d3) {
        return TuchRBF.rbf(d, d2, d3, this.p, this.sigma);
    }

    public static double rbf(double d, double d2, double d3, double[] dArray, double d4) {
        double d5 = d * dArray[0] + d2 * dArray[1] + d3 * dArray[2];
        d5 = d5 < 1.0 ? d5 : 1.0;
        d5 = d5 > -1.0 ? d5 : -1.0;
        double d6 = Math.acos(Math.abs(d5));
        return Math.exp(-d6 * d6 / (d4 * d4));
    }
}

