/*
 * Decompiled with CFR 0.152.
 */
package sphfunc;

import java.util.logging.Logger;
import numerics.Complex;
import numerics.SphericalHarmonicException;
import numerics.SphericalHarmonics;
import sphfunc.RealSH;

public class ImagSH
extends RealSH {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public ImagSH(int n, int n2) {
        super(n, n2);
    }

    public ImagSH(int n, int n2, double d) {
        super(n, n2, d);
    }

    @Override
    public double getRadius(double d, double d2) {
        Complex complex;
        try {
            complex = SphericalHarmonics.Y(this.l, this.m, d, d2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return this.scalar * complex.imag();
    }

    @Override
    public double greatCircleIntegral(double[] dArray) {
        double[] dArray2 = this.toAngles(dArray[0], dArray[1], dArray[2]);
        double d = 0.0;
        Complex complex = new Complex();
        try {
            d = SphericalHarmonics.plgndr(this.l, 0, 0.0);
            complex = SphericalHarmonics.Y(this.l, this.m, dArray2[0], dArray2[1]);
        }
        catch (SphericalHarmonicException sphericalHarmonicException) {
            String string = sphericalHarmonicException.getMessage();
            this.logger.warning(string);
        }
        double d2 = complex.imag();
        return Math.PI * 2 * d * d2 * this.scalar;
    }

    public static void main(String[] stringArray) {
        RealSH realSH = new RealSH(0, 0);
        RealSH realSH2 = new RealSH(2, 0);
        RealSH realSH3 = new RealSH(2, 2);
        ImagSH imagSH = new ImagSH(2, 2);
        RealSH realSH4 = new RealSH(2, 1);
        ImagSH imagSH2 = new ImagSH(2, 1);
        RealSH realSH5 = new RealSH(4, 0);
        ImagSH imagSH3 = new ImagSH(4, 0);
        RealSH realSH6 = new RealSH(4, 2);
        ImagSH imagSH4 = new ImagSH(4, 2);
        RealSH realSH7 = new RealSH(4, 3);
        ImagSH imagSH5 = new ImagSH(4, 3);
        double[] dArray = new double[]{0.707106781373095, 0.707106781373095, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 1.0};
        double d = realSH.greatCircleIntegral(dArray);
        System.err.println("Y_00: analytic = " + d + " 2pi.r = " + Math.PI * 2 * realSH.getRadius(0.0, 0.0, 1.0));
        double d2 = realSH2.greatCircleIntegral(dArray);
        System.err.println("Y_20: analytic = " + d2);
        d2 = realSH2.numGreatCircleIntegral(dArray);
        System.err.println("Y_20: numerical = " + d2);
        double d3 = realSH4.greatCircleIntegral(dArray);
        System.err.println("Y_21r: analytic = " + d3);
        double d4 = imagSH2.greatCircleIntegral(dArray);
        System.err.println("Y_21i: analytic = " + d4);
        d3 = realSH4.greatCircleIntegral(dArray2);
        System.err.println("Y_21r: analytic = " + d3);
        d4 = imagSH2.greatCircleIntegral(dArray2);
        System.err.println("Y_21i: analytic = " + d4);
        d3 = realSH4.numGreatCircleIntegral(dArray2);
        System.err.println("Y_21r: numerical = " + d3);
        d4 = imagSH2.numGreatCircleIntegral(dArray2);
        System.err.println("Y_21i: numerical = " + d4);
        double d5 = realSH3.greatCircleIntegral(dArray);
        System.err.println("Y_22r: analytic = " + d5);
        double d6 = imagSH.greatCircleIntegral(dArray);
        System.err.println("Y_22i: analytic = " + d6);
        d5 = realSH3.greatCircleIntegral(dArray2);
        System.err.println("Y_22r: analytic = " + d5);
        d6 = imagSH.greatCircleIntegral(dArray2);
        System.err.println("Y_22i: analytic = " + d6);
        d5 = realSH3.numGreatCircleIntegral(dArray2);
        System.err.println("Y_22r: numerical = " + d5);
        d6 = imagSH.numGreatCircleIntegral(dArray2);
        System.err.println("Y_22i: numerical = " + d6);
        double d7 = realSH5.greatCircleIntegral(dArray);
        System.err.println("Y_40r: analytic = " + d7);
        double d8 = imagSH3.greatCircleIntegral(dArray);
        System.err.println("Y_40i: analytic = " + d8);
        d7 = realSH5.greatCircleIntegral(dArray2);
        System.err.println("Y_40r: analytic = " + d7);
        d8 = imagSH3.greatCircleIntegral(dArray2);
        System.err.println("Y_40i: analytic = " + d8);
        d7 = realSH5.numGreatCircleIntegral(dArray2);
        System.err.println("Y_40r: numerical = " + d7);
        d8 = imagSH3.numGreatCircleIntegral(dArray2);
        System.err.println("Y_40i: numerical = " + d8);
        double d9 = realSH6.greatCircleIntegral(dArray);
        System.err.println("Y_42r: analytic = " + d9);
        double d10 = imagSH4.greatCircleIntegral(dArray);
        System.err.println("Y_42i: analytic = " + d10);
        double d11 = realSH7.greatCircleIntegral(dArray);
        System.err.println("Y_43r: analytic = " + d11);
        double d12 = imagSH5.greatCircleIntegral(dArray);
        System.err.println("Y_43i: analytic = " + d12);
        d11 = realSH7.greatCircleIntegral(dArray2);
        System.err.println("Y_43r: analytic = " + d11);
        d12 = imagSH5.greatCircleIntegral(dArray2);
        System.err.println("Y_43i: analytic = " + d12);
        d11 = realSH7.numGreatCircleIntegral(dArray2);
        System.err.println("Y_43r: numerical = " + d11);
        d12 = imagSH5.numGreatCircleIntegral(dArray2);
        System.err.println("Y_43i: numerical = " + d12);
    }
}

