/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Logger;
import numerics.MTRandom;
import simulation.SimulationParams;
import simulation.geometry.BasicCylinder;
import simulation.geometry.CylinderSubstrate;

public class StiffInflammationSubstrate
extends CylinderSubstrate {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final MTRandom rng;
    private final int steps;
    private final double[] L;
    private final int N;
    private final double rinc;
    private final double[] axis = new double[]{0.0, 0.0, 1.0};
    private final boolean[] expanding;
    private final int[] nearest;
    private final double[] nearestDist;
    private boolean firstTime = true;
    private final double p;
    private static final double TOL = 1.0E-14;

    public StiffInflammationSubstrate(double[] dArray, int n, double d, double d2, int n2, SimulationParams simulationParams) {
        super(dArray, simulationParams);
        int n3;
        int n4;
        int n5;
        double d3;
        int n6;
        int n7;
        this.rng = new MTRandom(7121L);
        this.p = simulationParams.getP();
        this.L = dArray;
        this.N = n;
        this.rinc = (d2 - d) / (double)n2;
        this.steps = n2;
        this.cylinder = new BasicCylinder[n];
        double[] dArray2 = new double[3];
        dArray2[2] = 0.0;
        for (n7 = 0; n7 < n; ++n7) {
            boolean bl = false;
            n6 = 0;
            while (!bl) {
                bl = true;
                d3 = this.rng.nextDouble() * dArray[0];
                double d4 = this.rng.nextDouble() * dArray[1];
                dArray2[0] = d3;
                dArray2[1] = d4;
                for (n5 = 0; n5 < n7; ++n5) {
                    if (!(this.cylinder[n5].getDistanceFrom(dArray2) <= 2.0 * d)) continue;
                    bl = false;
                    break;
                }
                ++n6;
            }
            this.cylinder[n7] = new BasicCylinder(dArray2, d, this.p);
        }
        this.expanding = new boolean[n];
        for (n7 = 0; n7 < this.expanding.length; ++n7) {
            this.expanding[n7] = true;
        }
        int[] nArray = new int[n];
        double[] dArray3 = new double[n];
        for (n6 = 0; n6 < n; ++n6) {
            int n8 = -1;
            double[] dArray4 = this.cylinder[n6].getPosition();
            d3 = Double.MAX_VALUE;
            for (n5 = 0; n5 < n; ++n5) {
                double d5;
                if (n5 == n6 || !((d5 = this.cylinder[n5].getDistanceFrom(dArray4)) < d3)) continue;
                d3 = d5;
                n8 = n5;
            }
            nArray[n6] = n8;
            dArray3[n6] = d3;
        }
        BasicCylinder[] basicCylinderArray = new BasicCylinder[n];
        int[] nArray2 = new int[n];
        double[] dArray5 = new double[n];
        boolean[] blArray = new boolean[n];
        for (n4 = 0; n4 < n; ++n4) {
            blArray[n4] = false;
        }
        for (n4 = 0; n4 < n; ++n4) {
            double d6 = Double.MAX_VALUE;
            n3 = -1;
            for (int i = 0; i < n; ++i) {
                if (blArray[i] || !(dArray3[i] < d6)) continue;
                d6 = dArray3[i];
                n3 = i;
            }
            basicCylinderArray[n4] = this.cylinder[n3];
            dArray5[n4] = dArray3[n3];
            blArray[n3] = true;
        }
        for (n4 = 0; n4 < n; ++n4) {
            n3 = -1;
            double[] dArray6 = basicCylinderArray[n4].getPosition();
            double d7 = Double.MAX_VALUE;
            for (int i = 0; i < n; ++i) {
                double d8;
                if (i == n4 || !((d8 = basicCylinderArray[i].getDistanceFrom(dArray6)) < d7)) continue;
                d7 = d8;
                n3 = i;
            }
            nArray2[n4] = n3;
        }
        this.cylinder = basicCylinderArray;
        this.nearestDist = dArray5;
        this.nearest = nArray2;
    }

    @Override
    public final void init() {
        if (this.firstTime) {
            this.firstTime = false;
        } else {
            this.swell();
        }
    }

    private final void swell() {
        int n;
        int n2;
        int n3 = 1;
        double[] dArray = new double[this.N];
        double[] dArray2 = new double[this.N];
        for (n2 = 0; n2 < this.N; ++n2) {
            dArray[n2] = this.expanding[n2] ? this.cylinder[n2].getRadius() + this.rinc : this.cylinder[n2].getRadius();
            dArray2[n2] = dArray[n2];
        }
        while (n3 != 0) {
            n3 = 0;
            n2 = 37;
            n = 33;
            for (int i = 0; i < this.N; ++i) {
                double d;
                int n4 = this.nearest[i];
                double d2 = dArray2[i] + dArray2[n4];
                if (!(d2 > this.nearestDist[i]) || !this.expanding[i]) continue;
                ++n3;
                if (this.expanding[n4]) {
                    d = i > n4 ? this.cylinder[i].getRadius() + dArray2[n4] : this.cylinder[i].getRadius() + this.cylinder[n4].getRadius();
                    double d3 = (this.nearestDist[i] - d) / 2.0;
                    dArray2[i] = this.cylinder[i].getRadius() + d3;
                    dArray2[n4] = this.cylinder[n4].getRadius() + d3;
                    this.expanding[i] = false;
                    this.expanding[n4] = false;
                    continue;
                }
                d = this.nearestDist[i] - d2;
                dArray2[i] = this.cylinder[i].getRadius() + d;
                this.expanding[i] = false;
            }
        }
        for (n2 = 0; n2 < this.cylinder.length; ++n2) {
            n = this.nearest[n2];
            if (!(this.cylinder[n2].getRadius() + this.cylinder[n].getRadius() >= this.nearestDist[n2] + 1.0E-14)) continue;
            String string = new String("cylinders " + n2 + " and " + n + " are overlapping (" + this.cylinder[n2].getRadius() + " + " + this.cylinder[n].getRadius() + "(" + (this.cylinder[n2].getRadius() + this.cylinder[n].getRadius()) + ") > sep " + this.nearestDist[n2]);
            this.logger.warning(string);
        }
        for (n2 = 0; n2 < this.cylinder.length; ++n2) {
            this.cylinder[n2] = new BasicCylinder(this.cylinder[n2].getPosition(), dArray2[n2], this.p);
        }
    }

    public final double getVolumeFraction() {
        double d = this.L[0] * this.L[1];
        double d2 = 0.0;
        for (int i = 0; i < this.cylinder.length; ++i) {
            double d3 = this.cylinder[i].getRadius();
            d2 += Math.PI * d3 * d3;
        }
        return d2 / d;
    }

    @Override
    public double[] getSubstrateSize() {
        return this.L;
    }

    @Override
    public double getPeakCoord() {
        return this.L[0] / 2.0;
    }

    public final void extractVolFracBehaviour() {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter("volFrac.dat"));
            boolean bl = true;
            int n = 0;
            block2: while (bl) {
                this.init();
                bufferedWriter.write(n + " " + this.getVolumeFraction() + "\n");
                System.err.print(n + " " + this.getVolumeFraction() + "\n");
                ++n;
                bl = false;
                for (int i = 0; i < this.expanding.length; ++i) {
                    if (!this.expanding[i]) continue;
                    bl = true;
                    continue block2;
                }
            }
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            this.logger.severe(iOException.getMessage());
            this.logger.severe(iOException.getStackTrace().toString());
            throw new RuntimeException(iOException);
        }
    }

    public static void main(String[] stringArray) {
        StiffInflammationSubstrate stiffInflammationSubstrate = new StiffInflammationSubstrate(new double[]{10.0, 10.0, 10.0}, 1000, 0.005, 5.005, 1000, null);
        stiffInflammationSubstrate.extractVolFracBehaviour();
    }
}

