/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.GammaRandom;
import numerics.MTRandom;
import simulation.DiffusionSimulation;
import simulation.SimulationParams;
import simulation.dynamics.Walker;
import simulation.geometry.CylinderSubstrate;
import simulation.geometry.SquashyCylinder;
import tools.CL_Initializer;

public class SquashyInflammationSubstrate
extends CylinderSubstrate {
    public boolean chuck = false;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final MTRandom rng = new MTRandom(CL_Initializer.seed);
    private final int D = 3;
    private final double[] L;
    public SquashyCylinder[] cylinder;
    private double[] radius;
    private double[] rinc;
    private final int numIncrements;
    private final int inflammationIncrementModulus;
    private int n = 0;
    public double[][] P;
    private int counter = 0;
    private int[] cylCrossed;
    private double[] shortestDist;
    private double[] cyl_p;
    private double[] intOriginDist;
    private double[][] intNormal;
    private boolean[] intInside;
    private int lastCrossed = -1;
    private final double p;
    private final double K = 10000.0;
    private final GammaRandom grng;
    private final ArrayList<double[]> clones = new ArrayList();
    private final int Nbefore;

    public SquashyInflammationSubstrate(double d, double d2, int n, int n2, int n3, double d3, SimulationParams simulationParams) {
        super(new double[]{d3, d3, d3}, simulationParams);
        int n4;
        double d4;
        int n5;
        int n6;
        this.grng = new GammaRandom((long)CL_Initializer.seed + 8273L, d, d2);
        this.numIncrements = n3;
        this.L = new double[]{d3, d3, d3};
        if (n2 < n3) {
            this.logger.warning("number of voxels less than number if inflammation increments.\ninflammation increment modulus =1 will be used.");
            this.inflammationIncrementModulus = 1;
        } else {
            this.inflammationIncrementModulus = n2 / n3;
        }
        this.P = new double[n][3];
        this.cylCrossed = new int[n];
        this.cyl_p = new double[n];
        this.shortestDist = new double[n];
        this.intOriginDist = new double[n];
        this.intNormal = new double[n][3];
        this.intInside = new boolean[n];
        this.radius = new double[n];
        for (int i = 0; i < n; ++i) {
            this.radius[i] = this.grng.nextGamma();
        }
        double d5 = 0.0;
        for (int i = 0; i < this.radius.length; ++i) {
            d5 += Math.PI * this.radius[i] * this.radius[i];
        }
        double d6 = this.L[0] * this.L[1];
        if (d5 >= d6) {
            this.logger.warning("total area of specified gamma-distributed cylinders (" + d5 + ") is greater than cross section of substrate (" + d6 + ")");
        }
        Arrays.sort(this.radius);
        double[] dArray = new double[this.radius.length];
        for (n6 = 0; n6 < this.radius.length; ++n6) {
            dArray[this.radius.length - n6 - 1] = this.radius[n6];
        }
        this.radius = dArray;
        this.rinc = new double[this.radius.length];
        for (n6 = 0; n6 < this.radius.length; ++n6) {
            double d7;
            double d8 = this.radius[n6];
            double d9 = Math.PI * d8 * d8;
            this.rinc[n6] = d7 = 10000.0 * d9;
        }
        this.P = new double[n][3];
        n6 = n;
        for (n5 = 0; n5 < this.radius.length; ++n5) {
            int n7;
            boolean bl = true;
            ArrayList<double[]> arrayList = null;
            for (n7 = 0; bl && n7 < 10000; ++n7) {
                double d10;
                double d11;
                int n8;
                this.P[n5][0] = this.L[0] * this.rng.nextDouble();
                this.P[n5][1] = this.L[1] * this.rng.nextDouble();
                bl = false;
                for (n8 = 0; n8 < n5; ++n8) {
                    double d12 = (this.P[n5][0] - this.P[n8][0]) * (this.P[n5][0] - this.P[n8][0]) + (this.P[n5][1] - this.P[n8][1]) * (this.P[n5][1] - this.P[n8][1]);
                    double d13 = this.radius[n5] + this.radius[n8];
                    if (!(d12 < d13 * d13)) continue;
                    bl = true;
                    break;
                }
                for (n8 = 0; n8 < this.clones.size(); ++n8) {
                    double[] dArray2 = this.clones.get(n8);
                    d11 = (this.P[n5][0] - dArray2[0]) * (this.P[n5][0] - dArray2[0]) + (this.P[n5][1] - dArray2[1]) * (this.P[n5][1] - dArray2[1]);
                    d4 = Math.PI * dArray2[3] * dArray2[3] * 10000.0;
                    d10 = this.radius[n5] + dArray2[3];
                    if (!(d11 < d10 * d10)) continue;
                    bl = true;
                    break;
                }
                arrayList = this.checkForCloning(this.P[n5], this.radius[n5], n5);
                block8: for (n8 = 0; n8 < arrayList.size(); ++n8) {
                    int n9;
                    double[] dArray3 = arrayList.get(n8);
                    d11 = dArray3[3];
                    d4 = Math.PI * d11 * d11 * 10000.0;
                    d10 = d11 + (double)n3 * d4;
                    for (n9 = 0; n9 < n5; ++n9) {
                        double d14 = (dArray3[0] - this.P[n9][0]) * (dArray3[0] - this.P[n9][0]) + (dArray3[1] - this.P[n9][1]) * (dArray3[1] - this.P[n9][1]);
                        if (!(d14 < (d11 + this.radius[n9]) * (d11 + this.radius[n9]))) continue;
                        bl = true;
                        break;
                    }
                    for (n9 = 0; n9 < this.clones.size(); ++n9) {
                        double d15;
                        double[] dArray4 = this.clones.get(n9);
                        double d16 = (dArray3[0] - dArray4[0]) * (dArray3[0] - dArray4[0]) + (dArray3[1] - dArray4[1]) * (dArray3[1] - dArray4[1]);
                        if (!(d16 < (d11 + (d15 = dArray4[3])) * (d11 + d15))) continue;
                        bl = true;
                        continue block8;
                    }
                }
            }
            if (n7 == 10000) {
                this.logger.warning("could only place " + (n5 + 1) + " of " + n + " cylinders on substrate");
                n6 = n5;
                double[][] dArrayArray = new double[n6][];
                for (int i = 0; i < n6; ++i) {
                    dArrayArray[i] = this.P[i];
                }
                this.P = dArrayArray;
                break;
            }
            if (bl) continue;
            this.clones.addAll(arrayList);
        }
        d5 = 0.0;
        for (n5 = 0; n5 < n6; ++n5) {
            d5 += Math.PI * this.radius[n5] * this.radius[n5];
        }
        double d17 = d5 / d6;
        this.logger.info("intracellular volume fraction " + d17);
        this.Nbefore = n6;
        this.initClones();
        int n10 = this.Nbefore + this.clones.size();
        this.cylinder = new SquashyCylinder[n10];
        for (n4 = 0; n4 < this.Nbefore; ++n4) {
            this.cylinder[n4] = new SquashyCylinder(this.P[n4], this.radius[n4], SimulationParams.sim_p);
        }
        for (n4 = this.Nbefore; n4 < this.cylinder.length; ++n4) {
            int n11;
            double[] dArray5 = new double[3];
            double[] dArray6 = this.clones.get(n4 - this.Nbefore);
            for (n11 = 0; n11 < 3; ++n11) {
                dArray5[n11] = dArray6[n11];
            }
            this.cylinder[n4] = new SquashyCylinder(dArray5, dArray6[3], SimulationParams.sim_p);
            n11 = (int)dArray6[4];
            this.cylinder[n11].addToMyClones(this.cylinder[n4]);
        }
        for (n4 = 0; n4 < this.Nbefore; ++n4) {
            this.cylinder[n4].propagateCloneRelationships();
        }
        this.setCylinders(this.cylinder);
        this.rinc = new double[this.cylinder.length];
        for (n4 = 0; n4 < this.cylinder.length; ++n4) {
            double d18 = this.cylinder[n4].getRadius();
            double d19 = Math.PI * d18 * d18;
            this.rinc[n4] = d4 = 10000.0 * d19;
        }
        this.p = simulationParams.getP();
        dArray = new double[this.cylinder.length];
        for (n4 = 0; n4 < this.Nbefore; ++n4) {
            dArray[n4] = this.radius[n4];
        }
        for (n4 = this.Nbefore; n4 < this.cylinder.length; ++n4) {
            double[] dArray7 = new double[3];
            double[] dArray8 = this.clones.get(n4 - this.Nbefore);
            for (int i = 0; i < 3; ++i) {
                dArray7[i] = dArray8[i];
            }
            dArray[n4] = dArray8[3];
        }
        this.radius = dArray;
    }

    protected void initClones() {
        int n;
        double[][] dArrayArray = new double[this.P.length + this.clones.size()][];
        for (n = 0; n < this.P.length; ++n) {
            dArrayArray[n] = new double[3];
            for (int i = 0; i < 3; ++i) {
                dArrayArray[n][i] = this.P[n][i];
            }
        }
        for (n = 0; n < this.clones.size(); ++n) {
            double[] dArray = this.clones.get(n);
            dArrayArray[n + this.P.length] = dArray;
        }
        this.P = dArrayArray;
    }

    protected final double twoDdist(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < 2; ++i) {
            d += (dArray[i] - dArray2[i]) * (dArray[i] - dArray2[i]);
        }
        return Math.sqrt(d);
    }

    @Override
    public double[] getSubstrateSize() {
        return this.L;
    }

    @Override
    public double getPeakCoord() {
        return this.L[0] / 2.0;
    }

    @Override
    public void init() {
        Object object;
        int n;
        if (DiffusionSimulation.calls % this.inflammationIncrementModulus == 0) {
            int n2;
            for (n2 = 0; n2 < this.cylinder.length; ++n2) {
                if (this.cylinder[n2] == null || this.cylinder[n2].isExpanding()) {
                    this.cylinder[n2] = new SquashyCylinder(this.P[n2], this.radius[n2] + (double)this.n * this.rinc[n2], this.p);
                    continue;
                }
                this.cylinder[n2] = new SquashyCylinder(this.P[n2], this.cylinder[n2].getRadius(), this.p);
                this.cylinder[n2].stopExpanding();
            }
            for (n2 = this.Nbefore; n2 < this.P.length; ++n2) {
                n = (int)this.P[n2][4];
                this.cylinder[n].addToMyClones(this.cylinder[n2]);
            }
            for (n2 = 0; n2 < this.Nbefore; ++n2) {
                this.cylinder[n2].propagateCloneRelationships();
                if (this.cylinder[n2].isExpanding()) continue;
                this.cylinder[n2].stopExpanding();
            }
            for (n2 = 0; n2 < this.cylinder.length; ++n2) {
                for (n = 0; n < n2; ++n) {
                    if (n2 == n || !this.cylinder[n2].abutts(this.cylinder[n])) continue;
                    if (!this.cylinder[n2].hasIntersectionWith(this.cylinder[n])) {
                        this.cylinder[n2].addIntersectionWith(this.cylinder[n]);
                    }
                    if (this.cylinder[n].hasIntersectionWith(this.cylinder[n2])) continue;
                    this.cylinder[n].addIntersectionWith(this.cylinder[n2]);
                }
                for (n = 0; n < n2; ++n) {
                    object = this.cylinder[n].chords.iterator();
                    while (object.hasNext()) {
                        SquashyCylinder.Chord chord = (SquashyCylinder.Chord)object.next();
                        if (chord.tmin >= chord.tmax) {
                            System.err.println("added cylinder " + n2 + ", cyl " + n + " has zero-length chord");
                            System.err.println("tmin= " + chord.tmin + ", tmax= " + chord.tmax);
                        }
                        if (Double.isNaN(chord.tmin)) {
                            System.err.println("added cylinder " + n2 + ", cylinder " + n + " tmin is NaN");
                        }
                        if (!Double.isNaN(chord.tmax)) continue;
                        System.err.println("added cylinder " + n2 + ", cylinder " + n + " tmax is NaN");
                    }
                }
            }
            ++this.n;
            this.logger.info("iteration " + DiffusionSimulation.calls + "  vol frac= " + this.intraCellularVolFrac());
        }
        if (this.substrateInfo) {
            this.logger.info("cylinder positions and radii:");
            String string = new String();
            for (n = 0; n < this.cylinder.length; ++n) {
                object = this.cylinder[n].getPosition();
                double d = this.cylinder[n].getRadius();
                string = string + "cylinder " + n + " pos = (" + object[0] + ", " + (double)object[1] + ", " + (double)object[2] + ")\tradius = " + d + "\n";
            }
            this.logger.info("cylinder positions and radii:\n" + string);
            this.substrateInfo = false;
        }
        this.lastCrossed = -1;
        ++DiffusionSimulation.calls;
    }

    @Override
    public boolean intracellular(Walker walker) {
        double[] dArray = new double[3];
        this.getSubstrateCoords(walker.r, new double[3], dArray);
        for (int i = 0; i < this.cylinder.length; ++i) {
            if (!this.cylinder[i].inside(dArray)) continue;
            return true;
        }
        return false;
    }

    private double intraCellularVolFrac() {
        int n = 100;
        double d = this.L[0] / (double)n;
        int n2 = 0;
        double[] dArray = new double[3];
        dArray[2] = 0.0;
        for (int i = 0; i < n; ++i) {
            dArray[0] = (double)i * d;
            block1: for (int j = 0; j < n; ++j) {
                dArray[1] = (double)j * d;
                for (int k = 0; k < this.cylinder.length; ++k) {
                    if (!this.cylinder[k].inside(dArray)) continue;
                    ++n2;
                    continue block1;
                }
            }
        }
        return (double)n2 / (double)(n * n);
    }

    private ArrayList<double[]> checkForCloning(double[] dArray, double d, int n) {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        for (int i = 0; i < 2; ++i) {
            int n2;
            double[] dArray2;
            if (dArray[i] - d <= this.border[i]) {
                dArray2 = new double[5];
                for (n2 = 0; n2 < 3; ++n2) {
                    dArray2[n2] = n2 == i ? dArray[n2] + this.L[n2] : dArray[n2];
                }
                dArray2[3] = d;
                dArray2[4] = n;
                arrayList.add(dArray2);
            }
            if (!(this.L[0] - (dArray[i] + d) <= this.border[i])) continue;
            dArray2 = new double[5];
            for (n2 = 0; n2 < 3; ++n2) {
                dArray2[n2] = n2 == i ? dArray[n2] - this.L[n2] : dArray[n2];
            }
            dArray2[3] = d;
            dArray2[4] = n;
            arrayList.add(dArray2);
        }
        if (this.L[0] - (dArray[0] + d) <= this.border[0] && this.L[1] - (dArray[1] + d) <= this.border[1]) {
            double[] dArray3 = new double[]{dArray[0] - this.L[0], dArray[1] - this.L[1], dArray[2], d, n};
            arrayList.add(dArray3);
        }
        if (dArray[0] - d <= this.border[0] && dArray[1] - d <= this.border[1]) {
            double[] dArray4 = new double[]{dArray[0] + this.L[0], dArray[1] + this.L[1], dArray[2], d, n};
            arrayList.add(dArray4);
        }
        if (this.L[0] - (dArray[0] + d) <= this.border[0] && dArray[1] - d <= this.border[1]) {
            double[] dArray5 = new double[]{dArray[0] - this.L[0], dArray[1] + this.L[1], dArray[2], d, n};
            arrayList.add(dArray5);
        }
        if (dArray[0] - d <= this.border[0] && this.L[1] - (dArray[1] + d) <= this.border[1]) {
            double[] dArray6 = new double[]{dArray[0] + this.L[0], dArray[1] - this.L[1], dArray[2], d, n};
            arrayList.add(dArray6);
        }
        return arrayList;
    }

    public final void drawCrossSection() throws IOException {
        Object object;
        this.logger.info("generating cylinder cross section image.");
        int n = 500;
        double d = this.getSubstrateSize()[0] / (double)n;
        double[][] dArrayArray = new double[][]{{d, 0.0, 0.0}, {-d, 0.0, 0.0}, {0.0, d, 0.0}, {0.0, -d, 0.0}};
        FileOutputStream fileOutputStream = null;
        try {
            object = new String("crossSec_" + DiffusionSimulation.calls + ".gray");
            fileOutputStream = new FileOutputStream((String)object);
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        object = new DataOutputStream(new BufferedOutputStream(fileOutputStream, 1024));
        double[] dArray = new double[3];
        Walker walker = new Walker(dArray);
        walker.testReplacePositionVector(dArray);
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[1];
        boolean[] blArray = new boolean[1];
        double[] dArray5 = new double[]{1.0};
        for (int i = 0; i < n; ++i) {
            dArray[0] = d * ((double)i + 0.5);
            System.err.print("\ri= " + i + "     ");
            for (int j = 0; j < n; ++j) {
                dArray[1] = d * ((double)j + 0.5);
                boolean bl = false;
                for (int k = 0; k < dArrayArray.length && !(bl = this.crossesMembrane(walker, dArray2, dArrayArray[k], dArray3, dArray4, false, d, blArray, dArray5)); ++k) {
                }
                if (bl) {
                    ((DataOutputStream)object).writeByte(0);
                    continue;
                }
                if (this.intracellular(walker)) {
                    ((DataOutputStream)object).writeByte(-1);
                    continue;
                }
                ((DataOutputStream)object).write(-128);
            }
        }
        ((DataOutputStream)object).flush();
        ((FilterOutputStream)object).close();
        System.err.println();
        this.logger.info("cylinder cross section image generated.");
    }
}

