/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import imaging.SchemeV0;
import java.util.logging.Logger;
import numerics.MTRandom;
import simulation.SimulationParams;
import simulation.geometry.SquashyInflammationSubstrate;
import tools.CL_Initializer;

public class PercolationSubstrate
extends SquashyInflammationSubstrate {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final int MAX_TRIES = 10000;
    private final int D = 3;
    private final int gridSize;
    private double[] gridLen;

    public PercolationSubstrate(double d, double d2, int n, int n2, int n3, double d3, int n4, SimulationParams simulationParams) {
        super(d, d2, n, n2, n3, d3, simulationParams);
        int n5;
        this.gridSize = n4;
        this.gridLen = new double[3];
        for (int i = 0; i < 3; ++i) {
            this.gridLen[i] = d3 / (double)n4;
        }
        Object object = new double[n][3];
        int n6 = 0;
        MTRandom mTRandom = new MTRandom(CL_Initializer.seed + 98736);
        double d4 = super.getPeakCoord();
        for (int i = 0; i < n; ++i) {
            n5 = 0;
            boolean bl = true;
            double[] dArray = new double[3];
            dArray[2] = d4;
            while (bl) {
                int n7;
                for (n7 = 0; n7 < 2; ++n7) {
                    dArray[n7] = mTRandom.nextDouble() * d3;
                }
                ++n5;
                bl = false;
                for (n7 = 0; n7 < n6; ++n7) {
                    if (!(super.twoDdist(object[n7], dArray) <= 2.0 * d)) continue;
                    bl = true;
                    break;
                }
                if (n5 < 10000) continue;
            }
            if (n5 >= 10000) break;
            object[i] = dArray;
            ++n6;
        }
        if (n6 != n) {
            this.logger.warning("could only place " + n6 + " of " + n + " cylinders of radius " + d + " in substrate of size " + d3);
            double[][] dArrayArray = new double[n6][];
            for (n5 = 0; n5 < n6; ++n5) {
                dArrayArray[n5] = object[n5];
            }
            object = dArrayArray;
        }
        this.P = object;
        super.initClones();
        this.initSpatialSorting();
    }

    private final int getSpatialGridElement(double[] dArray) {
        int[] nArray = new int[2];
        for (int i = 0; i < 2; ++i) {
            nArray[i] = (int)Math.floor(dArray[i] / this.gridLen[i]);
        }
        return nArray[0] + nArray[1] * nArray[1];
    }

    private void initSpatialSorting() {
    }

    public static void main(String[] stringArray) {
        double d = 1.0E-6;
        double d2 = 5.0E-6;
        int n = 100;
        int n2 = 10;
        int n3 = 10;
        double d3 = 2.3E-5;
        int n4 = 10;
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        SimulationParams simulationParams = new SimulationParams(1, 1000, 1.0, 1, 5, null, 1, 1.0, schemeV0);
        PercolationSubstrate percolationSubstrate = new PercolationSubstrate(d, d2, n, n2, n3, d3, n4, simulationParams);
    }
}

