/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Logger;
import simulation.geometry.BasicCylinder;
import simulation.geometry.BoundingBox;
import simulation.geometry.Cylinder;
import tools.CL_Initializer;

public class MyelinatedCylinder
implements Cylinder {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final int D = 3;
    private final BasicCylinder[] cylinder = new BasicCylinder[2];
    private final double[] d;
    private final double[] P;
    private final double[] V;
    private final BoundingBox bbox;
    private int lastCrossed = -1;
    private int[] cylCrossed = new int[this.cylinder.length];
    private double[] shortestDist = new double[this.cylinder.length];
    private double[] intOriginDist = new double[this.cylinder.length];
    private double[][] intNormal = new double[this.cylinder.length][3];
    private boolean[] intInside = new boolean[this.cylinder.length];
    private double[] cyl_p = new double[this.cylinder.length];

    public MyelinatedCylinder(double[] dArray, double d, double d2, double d3, double d4, double d5) {
        this.P = dArray;
        this.V = new double[]{0.0, 0.0, 1.0};
        this.d = new double[]{d3, d4};
        this.cylinder[0] = new BasicCylinder(dArray, d, d5);
        this.cylinder[1] = new BasicCylinder(dArray, d2, d5);
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
        double[] dArray2 = new double[]{dArray[0] - d2, dArray[1] - d2};
        double[] dArray3 = new double[]{dArray[0] + d2, dArray[1] + d2};
        this.bbox = new BoundingBox(dArrayArray, dArray2, dArray3);
    }

    @Override
    public boolean crosses(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean bl, double d, double[] dArray5, boolean[] blArray, double[] dArray6) {
        int n;
        int n2;
        double d2 = 0.0;
        boolean[] blArray2 = new boolean[1];
        double[] dArray7 = new double[1];
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            d2 += dArray2[n2] * dArray2[n2];
        }
        if ((d2 = Math.sqrt(d2)) / d <= 1.0E-14) {
            return false;
        }
        n2 = 0;
        boolean bl2 = bl;
        for (n = 0; n < this.cylinder.length; ++n) {
            if (bl) {
                if (n == this.lastCrossed) {
                    blArray2[0] = blArray[0];
                    bl2 = true;
                } else {
                    blArray2[0] = this.cylinder[n].inside(dArray);
                    bl2 = false;
                }
            }
            if (!this.cylinder[n].crosses(dArray, dArray2, dArray3, dArray4, bl2, d, dArray5, blArray2, dArray7)) continue;
            this.shortestDist[n2] = dArray5[0];
            this.intOriginDist[n2] = dArray4[0];
            for (int i = 0; i < 3; ++i) {
                this.intNormal[n2][i] = dArray3[i];
            }
            this.intInside[n2] = blArray2[0];
            this.cylCrossed[n2] = n;
            this.cyl_p[n2] = dArray7[0];
            ++n2;
        }
        if (n2 == 1) {
            dArray4[0] = this.intOriginDist[0];
            for (n = 0; n < 3; ++n) {
                dArray3[n] = this.intNormal[0][n];
            }
            blArray[0] = this.intInside[0];
            this.lastCrossed = this.cylCrossed[0];
            dArray6[0] = this.cyl_p[0];
            return true;
        }
        if (n2 > 1) {
            int n3;
            double d3 = Double.MAX_VALUE;
            int n4 = -1;
            for (n3 = 0; n3 < n2; ++n3) {
                if (!(this.shortestDist[n3] < d3)) continue;
                d3 = this.shortestDist[n3];
                n4 = n3;
                this.lastCrossed = this.cylCrossed[n3];
            }
            if (n4 == -1) {
                return false;
            }
            dArray4[0] = this.intOriginDist[n4];
            for (n3 = 0; n3 < 3; ++n3) {
                dArray3[n3] = this.intNormal[n4][n3];
            }
            blArray[0] = this.intInside[n4];
            dArray6[0] = this.cyl_p[n4];
            return true;
        }
        return false;
    }

    @Override
    public final double getRadius() {
        return this.cylinder[1].getRadius();
    }

    @Override
    public final double[] getPosition() {
        return this.cylinder[0].getPosition();
    }

    @Override
    public final double getDistanceFrom(double[] dArray) {
        return this.cylinder[0].getDistanceFrom(dArray);
    }

    @Override
    public final boolean inside(double[] dArray) {
        return this.cylinder[1].inside(dArray);
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    @Override
    public double getDiffusivityAt(double[] dArray) {
        if (this.cylinder[1].inside(dArray)) {
            if (this.cylinder[0].inside(dArray)) {
                return this.d[0];
            }
            return this.d[1];
        }
        return CL_Initializer.DIFF_CONST;
    }

    @Override
    public final boolean boundingBoxIntersects(double[] dArray, double[] dArray2) {
        return this.bbox.intersectedBy(dArray, dArray2);
    }

    @Override
    public final boolean intersectsCubicRegion(double[] dArray, double[] dArray2) {
        return this.cylinder[0].intersectsCubicRegion(dArray, dArray2) || this.cylinder[1].intersectsCubicRegion(dArray, dArray2);
    }

    @Override
    public void toFile(Writer writer) throws IOException {
        this.cylinder[0].toFile(writer);
        this.cylinder[1].toFile(writer);
    }
}

