/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import java.io.IOException;
import java.io.Writer;
import numerics.Point3D;
import numerics.Vector3D;
import simulation.geometry.BoundingBox;
import simulation.geometry.Cylinder;
import simulation.geometry.Line;
import tools.CL_Initializer;

public class FacetCylinder
implements Cylinder {
    private final int D = 3;
    private final double d = CL_Initializer.DIFF_CONST;
    private final BoundingBox bbox = null;
    private final int N;
    private final Line[] facet;
    private final Vector3D V;
    protected final Vector3D P;
    private final Point3D Ppt;
    private final double[] Parr;
    private final double[][] Q;
    private final double p;
    private final double r;
    private int lastCrossed = -1;

    public FacetCylinder(Vector3D vector3D, Vector3D vector3D2, double d, int n, double d2) {
        int n2;
        this.V = vector3D;
        this.P = vector3D2;
        this.Parr = new double[]{vector3D2.x, vector3D2.y, vector3D2.z};
        this.Ppt = new Point3D(this.Parr);
        this.r = d;
        this.N = n;
        this.p = d2;
        this.facet = new Line[n];
        for (n2 = 0; n2 < n; ++n2) {
            double d3 = Math.PI * 2 * (double)n2 / (double)n;
            double d4 = Math.PI * 2 * (double)(n2 + 1) / (double)n;
            double d5 = vector3D2.x + d * Math.cos(d3);
            double d6 = vector3D2.y + d * Math.sin(d3);
            double d7 = vector3D2.x + d * Math.cos(d4);
            double d8 = vector3D2.y + d * Math.sin(d4);
            this.facet[n2] = new Line(d5, d6, d7, d8);
            double[] dArray = this.facet[n2].normal();
            double d9 = (d5 + d7) / 2.0;
            double d10 = (d6 + d8) / 2.0;
        }
        this.Q = new double[n][2];
        for (n2 = 0; n2 < n; ++n2) {
            double[] dArray = this.facet[n2].midpoint();
            double[] dArray2 = new double[]{dArray[0] - vector3D2.x, dArray[1] - vector3D2.y};
            this.Q[n2][0] = vector3D2.x + 2.0 * dArray2[0];
            this.Q[n2][1] = vector3D2.y + 2.0 * dArray2[1];
        }
    }

    @Override
    public boolean crosses(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean bl, double d, double[] dArray5, boolean[] blArray, double[] dArray6) {
        int n;
        double[] dArray7 = new double[this.N];
        double[] dArray8 = new double[this.N];
        double[][] dArray9 = new double[this.N][3];
        int[] nArray = new int[this.N];
        int n2 = 0;
        for (int i = 0; i < this.N; ++i) {
            boolean bl2;
            if (bl && i == this.lastCrossed || !(bl2 = this.facet[i].crossedBy(dArray, dArray2, dArray3, dArray4, bl, d, dArray5))) continue;
            dArray7[n2] = dArray5[0];
            nArray[n2] = i;
            dArray8[n2] = dArray4[0];
            for (n = 0; n < 3; ++n) {
                dArray9[n2][n] = dArray3[n];
            }
            ++n2;
        }
        if (n2 == 1) {
            this.lastCrossed = nArray[0];
            return true;
        }
        if (n2 > 1) {
            int n3;
            double d2 = dArray7[0];
            n = 0;
            for (n3 = 1; n3 < n2; ++n3) {
                if (!(dArray7[n3] < d2)) continue;
                d2 = dArray7[n3];
                n = n3;
            }
            this.lastCrossed = n;
            dArray4[0] = dArray8[n];
            for (n3 = 0; n3 < 3; ++n3) {
                dArray3[n3] = dArray9[n][n3];
            }
            dArray6[0] = this.p;
            return true;
        }
        return false;
    }

    @Override
    public double getDistanceFrom(double[] dArray) {
        Vector3D vector3D = new Vector3D(new Point3D(dArray), this.Ppt);
        double d = vector3D.modSquared();
        double d2 = vector3D.dot(this.V);
        return Math.sqrt(d - d2 * d2);
    }

    @Override
    public final boolean inside(double[] dArray) {
        double d = (dArray[0] - this.P.x) * (dArray[0] - this.P.x) + (dArray[1] - this.P.y) * (dArray[1] - this.P.y);
        for (int i = 0; i < this.Q.length; ++i) {
            double d2 = (dArray[0] - this.Q[i][0]) * (dArray[0] - this.Q[i][0]) + (dArray[1] - this.Q[i][1]) * (dArray[1] - this.Q[i][1]);
            if (!(d2 < d)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getDiffusivityAt(double[] dArray) {
        return this.d;
    }

    @Override
    public double[] getPosition() {
        return this.Parr;
    }

    @Override
    public double getRadius() {
        return this.r;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    @Override
    public boolean boundingBoxIntersects(double[] dArray, double[] dArray2) {
        return true;
    }

    @Override
    public final boolean intersectsCubicRegion(double[] dArray, double[] dArray2) {
        return true;
    }

    @Override
    public final void toFile(Writer writer) throws IOException {
        for (int i = 0; i <= this.N; ++i) {
            double d = Math.PI * 2 * (double)i / (double)this.N;
            double d2 = this.P.x + this.r * Math.cos(d);
            double d3 = this.P.y + this.r * Math.sin(d);
            writer.write(d2 + " " + d3 + "\n");
        }
    }

    public static void main(String[] stringArray) {
        Vector3D vector3D = new Vector3D(new double[]{0.0, 0.0, 1.0});
        Vector3D vector3D2 = new Vector3D(new double[]{0.5, 0.3, 0.0});
        double d = 1.0;
        int n = 10;
        FacetCylinder facetCylinder = new FacetCylinder(vector3D, vector3D2, d, n, 0.0);
        double[] dArray = new double[]{0.0, 1.0, 0.0};
        boolean bl = facetCylinder.inside(dArray);
        System.err.println("pos inside is " + bl);
    }
}

