/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import imaging.SchemeV0;
import java.util.logging.Logger;
import simulation.DiffusionSimulation;
import simulation.SimulationParams;
import simulation.dynamics.Walker;
import simulation.geometry.IsoCellularLattice;
import simulation.geometry.Substrate;
import simulation.geometry.SubstrateFactory;
import tools.CL_Initializer;

public abstract class CellularLattice
extends Substrate {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    protected final double l;
    protected final int L;
    protected final int D = 3;
    protected boolean[] occupied = null;
    protected int occupiedLength;
    public static final double TINYNUM = 5.0E-14;
    private final double p;

    public CellularLattice(double d, int n, SimulationParams simulationParams) {
        super(simulationParams, new double[]{d * (double)n, d * (double)n, d * (double)n});
        this.l = d;
        this.L = n;
        this.p = simulationParams.getP();
        this.occupiedLength = 1;
        for (int i = 0; i < 3; ++i) {
            this.occupiedLength *= n;
        }
        this.occupied = new boolean[this.occupiedLength];
    }

    public abstract void initLattice();

    private int getOccupiedArrayIndex(int[] nArray) {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            int n2 = nArray[i] % this.L;
            if (n2 < 0) {
                n2 += this.L;
            } else if (n2 >= this.L) {
                n2 -= this.L;
            }
            n += n2 * (int)Math.pow(this.L, i);
        }
        return n;
    }

    public int[] getCell(double[] dArray) {
        int[] nArray = new int[3];
        for (int i = 0; i < 3; ++i) {
            nArray[i] = (int)Math.floor(dArray[i] / this.l);
        }
        return nArray;
    }

    public boolean getCellOccupation(int[] nArray) {
        int n = this.getOccupiedArrayIndex(nArray);
        return this.occupied[n];
    }

    @Override
    public boolean crossesMembrane(Walker walker, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean bl, double d, boolean[] blArray, double[] dArray5) {
        int n;
        boolean bl2 = false;
        double[] dArray6 = new double[3];
        double d2 = 0.0;
        double[] dArray7 = null;
        double d3 = 0.0;
        double[] dArray8 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray8[i] = walker.r[i] + dArray[i];
            dArray6[i] = dArray8[i] + dArray2[i];
            d2 += dArray2[i] * dArray2[i];
        }
        if ((d2 = Math.sqrt(d2)) / d <= 5.0E-14) {
            return false;
        }
        int[] nArray = this.getCell(walker.r);
        int[] nArray2 = this.getCell(dArray6);
        int n2 = 0;
        for (n = 0; n < 3; ++n) {
            if (nArray[n] == nArray2[n]) continue;
            bl2 = true;
            ++n2;
        }
        if (bl2) {
            n = this.getCellOccupation(nArray) ? 1 : 0;
            boolean bl3 = this.getCellOccupation(nArray2);
            if (n != 0 || bl3) {
                int n3;
                double d4;
                int n4 = 0;
                if (bl) {
                    d3 = dArray4[0];
                    dArray7 = new double[3];
                    for (int i = 0; i < 3; ++i) {
                        dArray7[i] = dArray3[i];
                    }
                }
                if (n2 == 1) {
                    n4 = this.calcBarrierNormal(nArray, nArray2, dArray3);
                } else {
                    int n5;
                    int[] nArray3 = new int[3];
                    double[] dArray9 = new double[3];
                    d4 = 0.0;
                    int n6 = -1;
                    double d5 = Double.MAX_VALUE;
                    for (n5 = 0; n5 < 3; ++n5) {
                        double d6;
                        if (nArray[n5] == nArray2[n5]) continue;
                        double d7 = 0.0;
                        double d8 = 0.0;
                        for (int i = 0; i < 3; ++i) {
                            if (i == n5) {
                                nArray3[i] = nArray2[i];
                                dArray9[i] = 1.0;
                                d7 = walker.r[i];
                                d8 = dArray2[i];
                                continue;
                            }
                            nArray3[i] = nArray[i];
                            dArray9[i] = 0.0;
                        }
                        n3 = this.getCellOccupation(nArray3);
                        if (n == 0 && n3 == 0) continue;
                        double d9 = nArray3[n5] > nArray[n5] ? (double)nArray3[n5] * this.l : (double)nArray[n5] * this.l;
                        double d10 = d7 - d9;
                        double d11 = d8 / d2;
                        double d12 = d10 / d11;
                        if (bl && Math.abs(d6 = d12 / d) <= 5.0E-14 && Math.abs(dArray4[0] - d3) <= 5.0E-14) {
                            boolean bl4 = true;
                            for (int i = 0; i < 3; ++i) {
                                if (!(Math.abs(dArray3[i] - dArray7[i]) > 5.0E-14)) continue;
                                bl4 = false;
                                break;
                            }
                            if (bl4) continue;
                        }
                        if (!(d10 < d5)) continue;
                        d5 = d12;
                        n6 = n5;
                    }
                    if (n6 == -1) {
                        return false;
                    }
                    for (n5 = 0; n5 < 3; ++n5) {
                        if (n5 == n6) {
                            dArray3[n5] = 1.0;
                            n4 = n5;
                            continue;
                        }
                        dArray3[n5] = 0.0;
                        nArray2[n5] = nArray[n5];
                    }
                }
                dArray4[0] = nArray[n4] > nArray2[n4] ? (double)nArray[n4] * this.l : (double)nArray2[n4] * this.l;
                double d13 = Math.abs(dArray3[n4] * walker.r[n4] - dArray4[0]);
                d4 = 0.0;
                for (n3 = 0; n3 < 3; ++n3) {
                    d4 += dArray2[n3] * dArray2[n3];
                }
                d4 = Math.sqrt(d4);
                if (bl) {
                    double d14 = 0.0;
                    for (int i = 0; i < 3; ++i) {
                        d14 += dArray3[i] * dArray2[i];
                    }
                    double d15 = d14 / d4;
                    double d16 = d13 / (d15 * d);
                    if (Math.abs(d16) <= 5.0E-14 && Math.abs(dArray4[0] - d3) <= 5.0E-14) {
                        boolean bl5 = true;
                        for (int i = 0; i < 3; ++i) {
                            if (!(Math.abs(dArray3[i] - dArray7[i]) > 5.0E-14)) continue;
                            bl5 = false;
                            break;
                        }
                        if (bl5) {
                            return false;
                        }
                    }
                }
                if (d13 > d4) {
                    this.logger.severe("step=(" + dArray2[0] / this.l + ", " + dArray2[1] / this.l + ", " + dArray2[2] / this.l + ")    cell " + nArray[0] + ", " + nArray[1] + ", " + nArray[2]);
                    this.logger.severe("new pos = (" + dArray6[0] / this.l + ", " + dArray6[1] / this.l + ", " + dArray6[2] / this.l + ")    cell " + nArray2[0] + ", " + nArray2[1] + ", " + nArray2[2]);
                    throw new RuntimeException("distance of walker at (" + walker.r[0] / this.l + ", " + walker.r[1] / this.l + ", " + walker.r[2] / this.l + ") from plane at " + dArray4[0] / this.l + " index " + n4 + " is " + d13 / this.l + " > " + d4 / this.l);
                }
                dArray5[0] = this.p;
                return true;
            }
        }
        return false;
    }

    @Override
    public final double[] getSubstrateSize() {
        return new double[]{(double)this.L * this.l, (double)this.L * this.l, (double)this.L * this.l};
    }

    public void applyBoundaries(Walker[] walkerArray) {
    }

    @Override
    public void init() {
    }

    public int[] getWindingNumbers(double[] dArray) {
        int[] nArray = new int[3];
        double[] dArray2 = this.getSubstrateSize();
        for (int i = 0; i < 3; ++i) {
            nArray[i] = (int)Math.floor(dArray[i] / dArray2[i]);
        }
        return nArray;
    }

    public int[] getWindingNumbers(Walker walker) {
        return this.getWindingNumbers(walker.r);
    }

    @Override
    public double getPeakCoord() {
        if (this.L % 2 == 1) {
            return this.l * (double)this.L / 2.0;
        }
        return this.l * (double)(this.L + 1) / 2.0;
    }

    private int calcBarrierNormal(int[] nArray, int[] nArray2, double[] dArray) {
        int n;
        int n2 = -1;
        int n3 = 0;
        for (n = 0; n < 3; ++n) {
            if (nArray[n] != nArray2[n]) {
                dArray[n] = 1.0;
                n2 = n;
                ++n3;
                continue;
            }
            dArray[n] = 0.0;
        }
        if (n3 == 1) {
            return n2;
        }
        n = 0;
        while (n < 3) {
            int n4 = n++;
            dArray[n4] = dArray[n4] / Math.sqrt(n3);
        }
        return -n3;
    }

    public static void testGetCell() {
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        Object[] objectArray = CL_Initializer.getGeometryParams(0);
        SimulationParams simulationParams = new SimulationParams(1, 1000, 0.0, 1, 0, objectArray, 1, 1.0, schemeV0);
        IsoCellularLattice isoCellularLattice = new IsoCellularLattice(1.0, 20, simulationParams);
        double[] dArray = new double[]{10.0, 10.0, 10.0};
        int[] nArray = isoCellularLattice.getCell(dArray);
        System.err.println("(" + dArray[0] + ", " + dArray[1] + ", " + dArray[2] + ") -- > (" + nArray[0] + "," + nArray[1] + "," + nArray[2] + ")");
        dArray = new double[]{-10.0, 10.0, -10.0};
        nArray = isoCellularLattice.getCell(dArray);
        System.err.println("(" + dArray[0] + ", " + dArray[1] + ", " + dArray[2] + ") -- > (" + nArray[0] + "," + nArray[1] + "," + nArray[2] + ")");
        dArray = new double[]{10.0, 30.0, 10.0};
        nArray = isoCellularLattice.getCell(dArray);
        System.err.println("(" + dArray[0] + ", " + dArray[1] + ", " + dArray[2] + ") -- > (" + nArray[0] + "," + nArray[1] + "," + nArray[2] + ")");
        dArray = new double[]{11.0, -22.5, 33.1};
        nArray = isoCellularLattice.getCell(dArray);
        System.err.println("(" + dArray[0] + ", " + dArray[1] + ", " + dArray[2] + ") -- > (" + nArray[0] + "," + nArray[1] + "," + nArray[2] + ")");
        dArray = new double[]{-1.1, 0.7, -103.12};
        nArray = isoCellularLattice.getCell(dArray);
        System.err.println("(" + dArray[0] + ", " + dArray[1] + ", " + dArray[2] + ") -- > (" + nArray[0] + "," + nArray[1] + "," + nArray[2] + ")");
    }

    public static void testWindingNumbers() {
        int n = 10;
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        Object[] objectArray = CL_Initializer.getGeometryParams(0);
        SimulationParams simulationParams = new SimulationParams(1, n, 0.0, 1, 0, objectArray, 1, 1.0, schemeV0);
        IsoCellularLattice isoCellularLattice = new IsoCellularLattice(1.0, 20, simulationParams);
        Walker walker = new Walker(new double[]{0.0, 10.0, 0.0});
        System.err.println("lattice size 20, cell size 1.0");
        int[] nArray = isoCellularLattice.getWindingNumbers(walker);
        System.err.println("(0.0, 10.0, 0.0) --> (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
        walker = new Walker(new double[]{0.0, 30.0, 0.0});
        nArray = isoCellularLattice.getWindingNumbers(walker);
        System.err.println("(0.0, 30.0, 0.0) --> (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
        walker = new Walker(new double[]{0.0, -10.0, 0.0});
        nArray = isoCellularLattice.getWindingNumbers(walker);
        System.err.println("(0.0, -10.0, 0.0) --> (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
        walker = new Walker(new double[]{0.0, -30.0, 0.0});
        nArray = isoCellularLattice.getWindingNumbers(walker);
        System.err.println("(0.0, -30.0, 0.0) --> (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
        walker = new Walker(new double[]{10.0, 10.0, 0.0});
        nArray = isoCellularLattice.getWindingNumbers(walker);
        System.err.println("(10.0, 10.0, 0.0) --> (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
        walker = new Walker(new double[]{10.0, -10.0, 0.0});
        nArray = isoCellularLattice.getWindingNumbers(walker);
        System.err.println("(10.0, -10.0, 0.0) --> (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
        walker = new Walker(new double[]{30.0, -30.0, 0.0});
        nArray = isoCellularLattice.getWindingNumbers(walker);
        System.err.println("(30.0, -30.0, 0.0) --> (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
        walker = new Walker(new double[]{-30.0, -30.0, 0.0});
        nArray = isoCellularLattice.getWindingNumbers(walker);
        System.err.println("(-30.0, -30.0, 0.0) --> (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
        walker = new Walker(new double[]{10.0, 10.0, 10.0});
        nArray = isoCellularLattice.getWindingNumbers(walker);
        System.err.println("(10.0, 10.0, 10.0) --> (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
        walker = new Walker(new double[]{10.0, 10.0, -10.0});
        nArray = isoCellularLattice.getWindingNumbers(walker);
        System.err.println("(10.0, 10.0, -10.0) --> (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
        walker = new Walker(new double[]{-10.0, 10.0, -10.0});
        nArray = isoCellularLattice.getWindingNumbers(walker);
        System.err.println("(-10.0, 10.0, -10.0) --> (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
        walker = new Walker(new double[]{10.0, 30.0, 10.0});
        nArray = isoCellularLattice.getWindingNumbers(walker);
        System.err.println("(10.0, 30.0, 10.0) --> (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
        walker = new Walker(new double[]{100.0, -30.0, -10.0});
        nArray = isoCellularLattice.getWindingNumbers(walker);
        System.err.println("(100.0, -30.0, -10.0) --> (" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")");
    }

    public static void testBarrierReflection() {
        System.err.println("testing barrier reflection code");
        int n = 100000;
        int n2 = 3;
        Object[] objectArray = new Object[]{new Double(2.0), new Integer(2)};
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        SimulationParams simulationParams = new SimulationParams(1000, n, 0.0, 1, 0, objectArray, 1, 10.0, schemeV0);
        Substrate substrate = SubstrateFactory.getSubstrate(0, objectArray, simulationParams);
        System.err.println("testing single crossing");
        Walker walker = new Walker(new double[]{1.5, 1.2, 1.5});
        double[] dArray = new double[]{1.0, -1.0, 0.0};
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        boolean[] blArray = new boolean[1];
        double[] dArray7 = new double[]{0.0, 0.0, 0.0};
        double[] dArray8 = new double[1];
        System.err.println("\t... membrane crossing detection");
        boolean bl = substrate.crossesMembrane(walker, dArray7, dArray, dArray2, dArray3, false, Math.sqrt(2.0), blArray, dArray8);
        System.err.println("* single crossing flag is " + bl);
        System.err.println("* normal between (" + walker.r[0] + "," + walker.r[1] + "," + walker.r[2] + ")" + "and (" + (walker.r[0] + dArray[0]) + "," + (walker.r[1] + dArray[1]) + "," + (walker.r[2] + dArray[2]) + "is (" + dArray2[0] + "," + dArray2[1] + "," + dArray2[2] + ") distance " + dArray3[0]);
        System.err.println("\t... step amendment");
        substrate.testAmendment(walker, dArray, dArray2, dArray3, Math.sqrt(2.0), dArray4, dArray5, dArray6);
        System.err.println("* step to barrier is (" + dArray4[0] + "," + dArray4[1] + "," + dArray4[2] + ")");
        System.err.println("* amended step is (" + dArray5[0] + "," + dArray5[1] + "," + dArray5[2] + ")");
        System.err.println("* unamended step is " + dArray6[0] + "," + dArray6[1] + "," + dArray6[2] + ")");
        System.err.println("\t... barrier skipping");
        walker.makeStep(dArray4);
        boolean bl2 = substrate.crossesMembrane(walker, dArray7, dArray6, dArray2, dArray3, true, Math.sqrt(2.0), blArray, dArray8);
        boolean bl3 = substrate.crossesMembrane(walker, dArray7, dArray5, dArray2, dArray3, true, Math.sqrt(2.0), blArray, dArray8);
        System.err.println("* unflected crossing flag is " + bl2 + " (" + walker.r[0] + "," + walker.r[1] + "," + walker.r[2] + ") -> (" + (walker.r[0] + dArray6[0]) + "," + (walker.r[1] + dArray6[1]) + "," + (walker.r[2] + dArray6[2]) + ")");
        System.err.println("* reflected crossing flag is " + bl3 + "(" + walker.r[0] + "," + walker.r[1] + "," + walker.r[2] + ") -> (" + (walker.r[0] + dArray5[0]) + "," + (walker.r[1] + dArray5[1]) + "," + (walker.r[2] + dArray5[2]) + ")");
        System.err.println("\t... testing multiple barrier reflection");
        walker = new Walker(new double[]{1.5, 2.6, 1.5});
        boolean bl4 = substrate.crossesMembrane(walker, dArray7, dArray, dArray2, dArray3, false, Math.sqrt(2.0), blArray, dArray8);
        System.err.println("* multiple crossing flag is " + bl4);
        System.err.println("* first normal encountered is (" + dArray2[0] + "," + dArray2[1] + "," + dArray2[2] + ") distance " + dArray3[0] + " units from origin");
        substrate.testAmendment(walker, dArray, dArray2, dArray3, Math.sqrt(2.0), dArray4, dArray5, dArray6);
        System.err.println("* unflected crossing flag is " + bl2 + " (" + walker.r[0] + "," + walker.r[1] + "," + walker.r[2] + ") -> (" + (walker.r[0] + dArray6[0]) + "," + (walker.r[1] + dArray6[1]) + "," + (walker.r[2] + dArray6[2]) + ")");
        System.err.println("* reflected crossing flag is " + bl3 + "(" + walker.r[0] + "," + walker.r[1] + "," + walker.r[2] + ") -> (" + (walker.r[0] + dArray5[0]) + "," + (walker.r[1] + dArray5[1]) + "," + (walker.r[2] + dArray5[2]) + ")");
        walker.makeStep(dArray4);
        bl2 = substrate.crossesMembrane(walker, dArray7, dArray6, dArray2, dArray3, true, Math.sqrt(2.0), blArray, dArray8);
        bl3 = substrate.crossesMembrane(walker, dArray7, dArray5, dArray2, dArray3, true, Math.sqrt(2.0), blArray, dArray8);
        System.err.println("* at barrier...");
        System.err.println("* unreflected crossing is " + bl2);
        System.err.println("* reflected crossing is " + bl3);
    }

    public static void testBoundaryCrossing() {
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        Object[] objectArray = new Object[]{new Double(1.0), new Integer(20), new Double(2.0)};
        SimulationParams simulationParams = new SimulationParams(1000, 100000, 0.0, 1, 1, objectArray, 1, 10.0, schemeV0);
        double[] dArray = new double[]{0.1};
        simulationParams.setStepParams(dArray);
        DiffusionSimulation diffusionSimulation = new DiffusionSimulation(simulationParams, schemeV0);
        diffusionSimulation.nextVoxel();
        double d = diffusionSimulation.getMeanSquareDisplacement();
    }

    public static void testPeriodicBoundaries() {
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{-0.1, 0.0, 0.0};
        Walker[] walkerArray = new Walker[]{new Walker(dArray)};
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        Object[] objectArray = CL_Initializer.getGeometryParams(0);
        SimulationParams simulationParams = new SimulationParams(1, 1000, 0.0, 1, 0, objectArray, 1, 1.0, schemeV0);
        IsoCellularLattice isoCellularLattice = new IsoCellularLattice(1.0, 1, simulationParams);
        isoCellularLattice.applyBoundaries(walkerArray);
    }

    @Override
    public boolean intracellular(Walker walker) {
        return this.getCellOccupation(this.getCell(walker.r));
    }

    public static void main(String[] stringArray) {
        System.err.println("Camino diffusion simulation engine test code\n");
        CellularLattice.testBarrierReflection();
    }
}

