/*
 * Decompiled with CFR 0.152.
 */
package simulation.geometry;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.RealMatrix;
import numerics.Rotations;
import simulation.geometry.Quad;
import simulation.geometry.Triangle;

public class BoundingBox {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final int D = 3;
    private final Quad[] face;
    private final double[][] v;
    private final double[] min;
    private final double[] max;

    protected BoundingBox(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n;
        int n2;
        if (dArray.length != 3) {
            throw new LoggedException("cuboidal bounding box requires 3 vectors but was handed " + dArray.length);
        }
        this.v = new double[3][3];
        this.min = new double[3];
        this.max = new double[3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.v[i][j] = dArray[i][j];
            }
            this.min[i] = dArray2[i];
            this.max[i] = dArray3[i];
        }
        this.face = new Quad[6];
        double[][] dArray4 = new double[2][3];
        double[] dArray5 = new double[2];
        double[] dArray6 = new double[2];
        double[] dArray7 = new double[3];
        dArray4[0] = dArray[0];
        dArray4[1] = dArray[1];
        dArray5[0] = dArray2[0];
        dArray5[1] = dArray2[1];
        dArray6[0] = dArray3[0];
        dArray6[1] = dArray3[1];
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                dArray7[n2] = dArray2[n] * dArray[n][n2];
            }
        }
        this.face[0] = new Quad(dArray4, dArray5, dArray6, dArray7);
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                dArray7[n2] = dArray3[n] * dArray[n][n2];
            }
        }
        this.face[1] = new Quad(dArray4, dArray5, dArray6, dArray7);
        dArray4[0] = dArray[0];
        dArray4[1] = dArray[2];
        dArray5[0] = dArray2[0];
        dArray5[1] = dArray2[2];
        dArray6[0] = dArray3[0];
        dArray6[1] = dArray3[2];
        this.face[2] = new Quad(dArray4, dArray5, dArray6, dArray7);
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                dArray7[n2] = dArray2[n] * dArray[n][n2];
            }
        }
        this.face[3] = new Quad(dArray4, dArray5, dArray6, dArray7);
        dArray4[0] = dArray[1];
        dArray4[1] = dArray[2];
        dArray5[0] = dArray2[1];
        dArray5[1] = dArray2[2];
        dArray6[0] = dArray3[1];
        dArray6[1] = dArray3[2];
        this.face[4] = new Quad(dArray4, dArray5, dArray6, dArray7);
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                dArray7[n2] = dArray3[n] * dArray[n][n2];
            }
        }
        this.face[5] = new Quad(dArray4, dArray5, dArray6, dArray7);
    }

    protected final boolean intersectedBy(double[] dArray, double[] dArray2) {
        for (int i = 0; i < this.face.length; ++i) {
            if (!this.face[i].crossedBy(dArray, dArray2)) continue;
            return true;
        }
        if (this.face.length > 1) {
            int n;
            double[] dArray3 = new double[3];
            for (n = 0; n < 3; ++n) {
                dArray3[n] = dArray[n] + dArray2[n];
            }
            n = this.contains(dArray) ? 1 : 0;
            boolean bl = this.contains(dArray3);
            return n != 0 || bl;
        }
        return false;
    }

    private final boolean contains(double[] dArray) {
        int n;
        double[] dArray2 = new double[3];
        for (n = 0; n < 3; ++n) {
            double d = 0.0;
            for (int i = 0; i < 3; ++i) {
                d += dArray[i] * this.v[n][i];
            }
            dArray2[n] = d;
        }
        n = 1;
        for (int i = 0; i < 3; ++i) {
            if (!(dArray2[i] < this.min[i]) && !(dArray2[i] > this.max[i])) continue;
            n = 0;
            break;
        }
        return n != 0;
    }

    public static BoundingBox getBoundingBoxFromTriangles(Triangle[] triangleArray) {
        int n;
        double[] dArray;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 3;
        double[] dArray2 = new double[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            dArray2[0] = 0.0;
        }
        n5 = 0;
        for (n4 = 0; n4 < triangleArray.length; ++n4) {
            for (n3 = 0; n3 < 3; ++n3) {
                double[] dArray3 = triangleArray[n4].getVertex(n3);
                for (n2 = 0; n2 < n6; ++n2) {
                    int n7 = n2;
                    dArray2[n7] = dArray2[n7] + dArray3[n2];
                }
                ++n5;
            }
        }
        n4 = 0;
        while (n4 < n6) {
            int n8 = n4++;
            dArray2[n8] = dArray2[n8] / (double)n5;
        }
        double[][] dArray4 = new double[n6][n6];
        for (n3 = 0; n3 < n6; ++n3) {
            for (int i = 0; i < n6; ++i) {
                for (n2 = 0; n2 < triangleArray.length; ++n2) {
                    for (int j = 0; j < 3; ++j) {
                        dArray = triangleArray[n2].getVertex(j);
                        double[] dArray5 = dArray4[n3];
                        int n9 = i;
                        dArray5[n9] = dArray5[n9] + (dArray[n3] - dArray2[n3]) * (dArray[i] - dArray2[i]);
                    }
                }
            }
        }
        Matrix matrix = new Matrix(dArray4);
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
        double[][] dArray6 = eigenvalueDecomposition.getV().getArrayCopy();
        double[] dArray7 = new double[n6];
        dArray = new double[n6];
        for (n = 0; n < n6; ++n) {
            dArray7[n] = Double.MAX_VALUE;
            dArray[n] = -1.7976931348623157E308;
        }
        for (n = 0; n < triangleArray.length; ++n) {
            for (int i = 0; i < 3; ++i) {
                double[] dArray8 = triangleArray[n].getVertex(i);
                for (int j = 0; j < 3; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < n6; ++k) {
                        d += dArray8[k] * dArray6[j][k];
                    }
                    if (dArray7[j] > d) {
                        dArray7[j] = d;
                    }
                    if (!(dArray[j] < d)) continue;
                    dArray[j] = d;
                }
            }
        }
        return new BoundingBox(dArray6, dArray7, dArray);
    }

    protected double[][] getVertices() {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n = i;
                dArray[n] = dArray[n] + this.min[i] * this.v[j][i];
                int n2 = i;
                dArray2[n2] = dArray2[n2] + this.max[i] * this.v[j][i];
            }
        }
        return new double[][]{{dArray[0], dArray[1], dArray[2]}, {dArray2[0], dArray[1], dArray[2]}, {dArray[0], dArray2[1], dArray[2]}, {dArray2[0], dArray2[1], dArray[2]}, {dArray[0], dArray[1], dArray2[2]}, {dArray2[0], dArray[1], dArray2[2]}, {dArray[0], dArray2[1], dArray2[2]}, {dArray2[0], dArray2[1], dArray2[2]}};
    }

    private static void testCubicBox() {
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{1.0, 1.0, 1.0};
        BoundingBox boundingBox = new BoundingBox(dArrayArray, dArray, dArray2);
        double[] dArray3 = new double[]{0.5, 0.5, 0.5};
        double[] dArray4 = new double[]{0.1, 0.2, 0.3};
        boolean bl = boundingBox.intersectedBy(dArray3, dArray4);
        System.err.println("wholey contained step intersection is " + bl + " (true)");
        dArray4[0] = 0.6;
        bl = boundingBox.intersectedBy(dArray3, dArray4);
        System.err.println("step starting inside intersection is " + bl + " (true)");
        dArray4[0] = -0.4;
        dArray3[0] = 1.2;
        bl = boundingBox.intersectedBy(dArray3, dArray4);
        System.err.println("step starting outside intersection is " + bl + " (true)");
        dArray4[0] = 0.0;
        dArray3[0] = 1.2;
        bl = boundingBox.intersectedBy(dArray3, dArray4);
        System.err.println("non-intersecting step intersection is " + bl + " (false)");
        dArray3 = new double[]{0.5, 1.25, 0.5};
        dArray4 = new double[]{0.0, -1.0, 1.0};
        bl = boundingBox.intersectedBy(dArray3, dArray4);
        System.err.println("intersecting step that starts an finishes outside box gives " + bl + " (true)");
    }

    private static void testRotatedBox() {
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{1.0, 1.0, 1.0};
        double d = 1.0471975511965976;
        double[] dArray3 = new double[]{0.0, 1.0 / Math.sqrt(2.0), 1.0 / Math.sqrt(2.0)};
        RealMatrix realMatrix = Rotations.getRotMat(dArray3, d);
        double[][] dArrayArray2 = new double[3][];
        for (int i = 0; i < 3; ++i) {
            dArrayArray2[i] = Rotations.transformPoint(realMatrix, dArrayArray[i]);
        }
        BoundingBox boundingBox = new BoundingBox(dArrayArray2, dArray, dArray2);
        double[] dArray4 = new double[]{0.5, 0.5, 0.5};
        dArray4 = Rotations.transformPoint(realMatrix, dArray4);
        double[] dArray5 = new double[]{0.1, 0.2, 0.3};
        dArray5 = Rotations.transformPoint(realMatrix, dArray5);
        boolean bl = boundingBox.intersectedBy(dArray4, dArray5);
        System.err.println("wholey contained step intersection is " + bl + " (true)");
        dArray5 = new double[]{0.6, 0.2, 0.3};
        dArray5 = Rotations.transformPoint(realMatrix, dArray5);
        bl = boundingBox.intersectedBy(dArray4, dArray5);
        System.err.println("step starting inside intersection is " + bl + " (true)");
        dArray5 = new double[]{-0.4, 0.2, 0.3};
        dArray5 = Rotations.transformPoint(realMatrix, dArray5);
        dArray4 = new double[]{1.2, 0.5, 0.5};
        dArray4 = Rotations.transformPoint(realMatrix, dArray4);
        bl = boundingBox.intersectedBy(dArray4, dArray5);
        System.err.println("step starting outside intersection is " + bl + " (true)");
        dArray5 = new double[]{0.0, 0.2, 0.3};
        dArray5 = Rotations.transformPoint(realMatrix, dArray5);
        dArray4 = new double[]{1.2, 0.5, 0.5};
        dArray4 = Rotations.transformPoint(realMatrix, dArray4);
        bl = boundingBox.intersectedBy(dArray4, dArray5);
        System.err.println("non-intersecting step intersection is " + bl + " (false)");
        dArray4 = new double[]{0.5, 1.25, 0.5};
        dArray4 = Rotations.transformPoint(realMatrix, dArray4);
        dArray5 = new double[]{0.0, -1.0, 1.0};
        dArray5 = Rotations.transformPoint(realMatrix, dArray5);
        bl = boundingBox.intersectedBy(dArray4, dArray5);
        System.err.println("intersecting step that starts an finishes outside box gives " + bl + " (true)");
    }

    public static void main(String[] stringArray) {
        BoundingBox.testCubicBox();
        BoundingBox.testRotatedBox();
    }
}

