/*
 * Decompiled with CFR 0.152.
 */
package simulation.dynamics;

import imaging.Scheme;
import java.util.logging.Logger;
import misc.LoggedException;
import simulation.DiffusionSimulation;
import simulation.SimulationParams;
import simulation.dynamics.FixedLengthStepGenerator;
import simulation.dynamics.StepGenerator;

public class StepGeneratorFactory {
    public static final int FIXEDLENGTH = 1;
    public static final int SPATIALLYVARYING = 2;
    private static Logger logger = Logger.getLogger("simulation.StepGeneratorFactory");
    private static StepGenerator stepGen = null;

    public static final StepGenerator getStepGenerator(SimulationParams simulationParams) {
        int n = simulationParams.getStepType();
        if (n == 1) {
            if (stepGen == null) {
                logger.info("instantiating fixed length step generator");
                FixedLengthStepGenerator fixedLengthStepGenerator = new FixedLengthStepGenerator(simulationParams);
                stepGen = fixedLengthStepGenerator;
                return fixedLengthStepGenerator;
            }
            if (stepGen.getType() == 1) {
                return stepGen;
            }
            throw new LoggedException("step generator singleton is of type " + stepGen.getType() + " but fixed length generator was requested from factory.");
        }
        String string = new String("unknown diffusion simulation step generator type code " + n);
        logger.severe(string);
        throw new RuntimeException(string);
    }

    public static final double[] getStepParamsArray(int n, SimulationParams simulationParams, Scheme scheme) {
        if (n == 1) {
            double d = Math.sqrt(6.0 * DiffusionSimulation.DIFF_CONST * simulationParams.getDt());
            return new double[]{d};
        }
        logger.warning("unknown step generator type " + n + " paramters array " + "for fixed length step generator will be returned instead.");
        return StepGeneratorFactory.getStepParamsArray(1, simulationParams, scheme);
    }
}

