/*
 * Decompiled with CFR 0.152.
 */
package simulation.dynamics;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import numerics.MTRandom;
import simulation.SimulationParams;
import simulation.dynamics.StepGenerator;
import simulation.dynamics.Walker;
import tools.CL_Initializer;

public class FixedLengthStepGenerator
implements StepGenerator {
    private final double length;
    MTRandom stepTwister = new MTRandom(CL_Initializer.seed + 17);
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private int D = 3;
    private double[] step = new double[this.D];
    private final int[][] stepDist = new int[this.D][1001];
    private final boolean stepStats;

    public FixedLengthStepGenerator(SimulationParams simulationParams) {
        this.length = simulationParams.getStepParams()[0];
        this.stepStats = false;
    }

    private FixedLengthStepGenerator(double d) {
        this.length = d;
        this.stepStats = true;
    }

    @Override
    public double[] getStep(Walker walker) {
        if (this.D == 1) {
            this.step[0] = this.stepTwister.nextDouble() < 0.5 ? -this.length : this.length;
        } else if (this.D == 2) {
            double d = Math.PI * 2 * this.stepTwister.nextDouble();
            this.step[0] = this.length * Math.cos(d);
            this.step[1] = this.length * Math.sin(d);
        } else if (this.D == 3) {
            double d = Math.PI * 2 * this.stepTwister.nextDouble();
            double d2 = 2.0 * this.stepTwister.nextDouble() - 1.0;
            double d3 = Math.cos(d);
            double d4 = Math.sin(d);
            double d5 = Math.sqrt(1.0 - d2 * d2);
            this.step[0] = this.length * d3 * d5;
            this.step[1] = this.length * d4 * d5;
            this.step[2] = this.length * d2;
            for (int i = 0; i < this.D; ++i) {
                int n = (int)((this.step[i] / this.length + 1.0) * 500.0);
                int[] nArray = this.stepDist[i];
                int n2 = n;
                nArray[n2] = nArray[n2] + 1;
            }
        } else {
            String string = new String("steps of dimension " + this.D + " are not yet implemented. sorry.");
            this.logger.severe(string);
            throw new RuntimeException(string);
        }
        return this.step;
    }

    @Override
    public final double getBorder() {
        return this.length;
    }

    @Override
    public final int getType() {
        return 1;
    }

    public static void main(String[] stringArray) {
        int n = 100000;
        BufferedWriter bufferedWriter = null;
        FixedLengthStepGenerator fixedLengthStepGenerator = new FixedLengthStepGenerator(1.0);
        for (int i = 0; i < n; ++i) {
            double[] dArray = fixedLengthStepGenerator.getStep(null);
        }
        int[][] nArray = fixedLengthStepGenerator.stepDist;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter("stepCompDistrns.dat"));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        try {
            for (int i = 0; i < nArray[0].length; ++i) {
                double d = ((double)i - 500.0) / 1000.0;
                bufferedWriter.write(d + " ");
                for (int j = 0; j < fixedLengthStepGenerator.D; ++j) {
                    bufferedWriter.write(nArray[j][i] + " ");
                }
                bufferedWriter.write("\n");
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

