/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import data.DataSource;
import data.DataSourceException;
import data.OutputManager;
import imaging.Scheme;
import imaging.SchemeV0;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.MTRandom;
import simulation.SimulationParams;
import simulation.dynamics.StepGenerator;
import simulation.dynamics.StepGeneratorFactory;
import simulation.dynamics.Walker;
import simulation.geometry.SquashyCylinder;
import simulation.geometry.SquashyInflammationSubstrate;
import simulation.geometry.Substrate;
import simulation.geometry.SubstrateFactory;
import simulation.measurement.ScanFactory;
import simulation.measurement.SyntheticScan;
import tools.CL_Initializer;

public class DiffusionSimulation
implements DataSource {
    private final DataOutputStream trajWriter;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public static final int D = 3;
    public static final double DIFF_CONST = CL_Initializer.DIFF_CONST;
    private final double p;
    private MTRandom twister = new MTRandom(CL_Initializer.seed + 189);
    private final SimulationParams simParams;
    private SyntheticScan synthScan;
    private final Walker[] walker;
    private Substrate substrate;
    public static double border;
    private StepGenerator stepGenerator;
    private final int numVoxels;
    private int voxel = 0;
    private final boolean separateRuns = SimulationParams.sim_separate_runs;
    private final int tmax;
    private final double dt;
    private final double duration;
    public static int calls;
    private final int onlyRun = SimulationParams.sim_onlyRun;

    public DiffusionSimulation(SimulationParams simulationParams, Scheme scheme) {
        this.simParams = simulationParams;
        this.stepGenerator = StepGeneratorFactory.getStepGenerator(simulationParams);
        border = this.stepGenerator.getBorder();
        this.substrate = SubstrateFactory.getSubstrate(simulationParams.getGeometryType(), simulationParams.getGeometryParams(), simulationParams);
        this.numVoxels = CL_Initializer.numVoxels;
        this.p = simulationParams.getP();
        this.walker = new Walker[simulationParams.getN_walkers()];
        this.synthScan = ScanFactory.getMeasurementModule(simulationParams, scheme, this.substrate, this.walker);
        this.tmax = simulationParams.getTmax();
        this.dt = simulationParams.getDt();
        this.duration = SimulationParams.duration;
        this.trajWriter = null;
        this.logger.info("running simulation: " + this.walker.length + " walkers, " + simulationParams.getTmax() + " timesteps, p= " + this.p);
        this.logger.info("delta= " + scheme.getDelta(0) + " DELTA= " + scheme.getDiffusionTime(0) + "G= " + scheme.getModG(0));
    }

    public DiffusionSimulation(SimulationParams simulationParams) {
        this.simParams = simulationParams;
        this.stepGenerator = StepGeneratorFactory.getStepGenerator(simulationParams);
        border = this.stepGenerator.getBorder();
        this.substrate = SubstrateFactory.getSubstrate(simulationParams.getGeometryType(), simulationParams.getGeometryParams(), simulationParams);
        this.numVoxels = CL_Initializer.numVoxels;
        this.p = simulationParams.getP();
        this.walker = new Walker[simulationParams.getN_walkers()];
        this.synthScan = null;
        this.tmax = simulationParams.getTmax();
        this.dt = simulationParams.getDt();
        this.duration = SimulationParams.duration;
        try {
            FileOutputStream fileOutputStream = null;
            try {
                String string = SimulationParams.trajFile;
                fileOutputStream = new FileOutputStream(string);
            }
            catch (Exception exception) {
                throw new LoggedException(exception);
            }
            this.trajWriter = new DataOutputStream(new BufferedOutputStream(fileOutputStream, simulationParams.buffsize));
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
        this.logger.info("running simulation: " + this.walker.length + " walkers, " + simulationParams.getTmax() + " timesteps, p= " + this.p);
        this.logger.info("no scheme used, trajectories created instead. duration= " + this.duration);
    }

    private void initialiseWalkers() {
        if (this.simParams.getInitialConditions() == 0) {
            int n;
            double d = this.substrate.getPeakCoord();
            double[] dArray = new double[3];
            for (n = 0; n < 3; ++n) {
                dArray[n] = d;
            }
            for (n = 0; n < this.walker.length; ++n) {
                this.walker[n] = new Walker(dArray, this.stepGenerator, this.substrate, this.synthScan, this.trajWriter);
            }
        } else if (this.simParams.getInitialConditions() == 1) {
            double[] dArray = this.substrate.getSubstrateSize();
            double[] dArray2 = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
            double[] dArray3 = new double[]{0.0, 0.0, 0.0};
            for (int i = 0; i < this.walker.length; ++i) {
                double[] dArray4 = new double[3];
                for (int j = 0; j < 3; ++j) {
                    dArray4[j] = this.twister.nextDouble() * dArray[j];
                    if (dArray4[j] < dArray2[j]) {
                        dArray2[j] = dArray4[j];
                    }
                    if (!(dArray4[j] > dArray3[j])) continue;
                    dArray3[j] = dArray4[j];
                }
                this.walker[i] = new Walker(dArray4, this.stepGenerator, this.substrate, this.synthScan, this.trajWriter);
            }
        } else if (this.simParams.getInitialConditions() == 3) {
            double[] dArray = this.substrate.getSubstrateSize();
            boolean bl = true;
            double[] dArray5 = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
            double[] dArray6 = new double[]{0.0, 0.0, 0.0};
            for (int i = 0; i < this.walker.length; ++i) {
                bl = true;
                while (bl) {
                    double[] dArray7 = new double[3];
                    for (int j = 0; j < 3; ++j) {
                        dArray7[j] = this.twister.nextDouble() * dArray[j];
                        if (dArray7[j] < dArray5[j]) {
                            dArray5[j] = dArray7[j];
                        }
                        if (!(dArray7[j] > dArray6[j])) continue;
                        dArray6[j] = dArray7[j];
                    }
                    this.walker[i] = new Walker(dArray7, this.stepGenerator, this.substrate, this.synthScan, this.trajWriter);
                    bl = !this.substrate.intracellular(this.walker[i]);
                }
            }
        } else if (this.simParams.getInitialConditions() == 4) {
            double[] dArray = this.substrate.getSubstrateSize();
            boolean bl = true;
            double[] dArray8 = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
            double[] dArray9 = new double[]{0.0, 0.0, 0.0};
            for (int i = 0; i < this.walker.length; ++i) {
                bl = true;
                while (bl) {
                    double[] dArray10 = new double[3];
                    for (int j = 0; j < 3; ++j) {
                        dArray10[j] = this.twister.nextDouble() * dArray[j];
                        if (dArray10[j] < dArray8[j]) {
                            dArray8[j] = dArray10[j];
                        }
                        if (!(dArray10[j] > dArray9[j])) continue;
                        dArray9[j] = dArray10[j];
                    }
                    this.walker[i] = new Walker(dArray10, this.stepGenerator, this.substrate, this.synthScan, this.trajWriter);
                    bl = this.substrate.intracellular(this.walker[i]);
                }
            }
        } else if (this.simParams.getInitialConditions() == 2) {
            double[] dArray = this.substrate.getSubstrateSize();
            for (int i = 2; i < this.walker.length; ++i) {
                double[] dArray11 = new double[3];
                for (int j = 0; j < 3; ++j) {
                    dArray11[j] = this.twister.nextDouble() * dArray[j];
                    this.walker[i] = new Walker(dArray11, this.stepGenerator, this.substrate, this.synthScan, this.trajWriter);
                }
            }
        } else {
            String string = new String("unrecognised initial conditions code " + this.simParams.getInitialConditions());
            this.logger.severe(string);
            throw new LoggedException(string);
        }
    }

    public void runMainLoop() {
        boolean[] blArray = new boolean[this.walker.length];
        this.substrate.init();
        if (this.onlyRun == -1 || calls == this.onlyRun) {
            int n;
            int n2;
            int n3;
            for (n3 = 0; n3 < this.walker.length; ++n3) {
                blArray[n3] = this.substrate.intracellular(this.walker[n3]);
            }
            if (this.trajWriter != null) {
                try {
                    this.trajWriter.writeDouble(this.dt * (double)this.tmax);
                    this.trajWriter.writeDouble(this.simParams.getN_walkers());
                    this.trajWriter.writeDouble(this.tmax);
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
            n3 = 88759;
            boolean bl = false;
            for (n2 = 0; n2 < this.tmax; ++n2) {
                if (n2 % 100 == 0) {
                    System.err.print("\r" + 100.0 * (double)n2 / (double)this.simParams.getTmax() + "%     ");
                }
                for (n = 0; n < this.simParams.getN_walkers(); ++n) {
                    if (this.p == 0.0 && this.substrate.intracellular(this.walker[n]) != blArray[n]) {
                        this.logger.severe("walker pos: " + this.walker[n].r[0] + "  " + this.walker[n].r[1] + "  " + this.walker[n].r[2]);
                        throw new LoggedException("t= " + n2 + " i= " + n + " has crossed. isIntra=" + blArray[n]);
                    }
                    this.walker[n].update((double)n2 * this.dt, n);
                }
                if (this.synthScan == null) continue;
                this.synthScan.update(n2);
            }
            if (this.trajWriter != null) {
                for (n2 = 0; n2 < this.simParams.getN_walkers(); ++n2) {
                    try {
                        this.trajWriter.writeDouble((double)this.tmax * this.dt);
                        this.trajWriter.writeInt(n2);
                        for (n = 0; n < 3; ++n) {
                            this.trajWriter.writeDouble(this.walker[n2].r[n]);
                        }
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new LoggedException(iOException);
                    }
                }
                try {
                    this.trajWriter.flush();
                    this.trajWriter.close();
                }
                catch (IOException iOException) {
                    throw new LoggedException(iOException);
                }
            }
        }
    }

    @Override
    public double[] nextVoxel() throws DataSourceException {
        double[] dArray = null;
        if (!this.separateRuns) {
            if (this.voxel == 0) {
                this.initialiseWalkers();
                this.runMainLoop();
            }
        } else {
            this.stepGenerator = StepGeneratorFactory.getStepGenerator(this.simParams);
            this.initialiseWalkers();
            System.err.println("onlyrun= " + this.onlyRun + " calls= " + calls);
            this.runMainLoop();
            CL_Initializer.seed = this.twister.nextInt();
            this.twister = new MTRandom(CL_Initializer.seed + 189);
        }
        if (this.synthScan != null) {
            if (SimulationParams.sim_compartmentSignal == 2) {
                dArray = this.synthScan.getCompartmentalSignals(true);
            } else if (SimulationParams.sim_compartmentSignal == 1) {
                dArray = this.synthScan.getCompartmentalSignals(false);
            } else if (SimulationParams.sim_compartmentSignal == 3) {
                int n;
                double[] dArray2 = this.synthScan.getCompartmentalSignals(true);
                double[] dArray3 = this.synthScan.getCompartmentalSignals(false);
                double[] dArray4 = this.synthScan.getSignals();
                dArray = new double[dArray2.length + dArray3.length + dArray4.length];
                for (n = 0; n < dArray2.length; ++n) {
                    dArray[n] = dArray2[n];
                }
                for (n = 0; n < dArray3.length; ++n) {
                    dArray[dArray2.length + n] = dArray3[n];
                }
                for (n = 0; n < dArray4.length; ++n) {
                    dArray[dArray2.length + dArray3.length + n] = dArray4[n];
                }
            } else {
                dArray = this.synthScan.getSignals();
            }
        } else {
            dArray = new double[]{-1.0, -1.0, -1.0};
        }
        ++this.voxel;
        return dArray;
    }

    @Override
    public boolean more() {
        return this.voxel < this.numVoxels;
    }

    public double getMeanSquareDisplacement() {
        double d = 0.0;
        for (int i = 0; i < this.walker.length; ++i) {
            double[] dArray = this.walker[i].getDisplacement();
            double d2 = 0.0;
            for (int j = 0; j < 3; ++j) {
                d2 += dArray[j] * dArray[j];
            }
            d += d2;
        }
        return d /= (double)this.walker.length;
    }

    public static final void testDiffusionSimulation() {
        Object[] objectArray = new Object[]{new Double(1.0), new Double(3.0)};
        double[] dArray = new double[]{0.01};
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        SimulationParams simulationParams = new SimulationParams(1, 70000, 0.002, 0, 0, objectArray, 1, 1.5, schemeV0);
        DiffusionSimulation diffusionSimulation = new DiffusionSimulation(simulationParams, schemeV0);
        diffusionSimulation.nextVoxel();
        simulationParams = new SimulationParams(1000, 100000, 1.0E-4, 0, 0, objectArray, 1, 1.5, schemeV0);
        diffusionSimulation = new DiffusionSimulation(simulationParams, schemeV0);
        diffusionSimulation.nextVoxel();
        objectArray = new Object[]{new Double(1.0), new Double(20.0), new Double(2.0)};
        simulationParams = new SimulationParams(100, 100000, 1.0E-4, 1, 1, objectArray, 1, 10.0, schemeV0);
        diffusionSimulation = new DiffusionSimulation(simulationParams, schemeV0);
        diffusionSimulation.nextVoxel();
    }

    private static void testFullScale() {
        int n = 100000;
        double d = 0.0;
        Object[] objectArray = new Object[]{new Double(1.0E-6), new Integer(20), new Double(1.0)};
        double[] dArray = new double[]{1.0E-8};
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        SimulationParams simulationParams = new SimulationParams(100, n, d, 0, 1, objectArray, 1, 0.5, schemeV0);
        dArray = StepGeneratorFactory.getStepParamsArray(1, simulationParams, schemeV0);
        simulationParams.setStepParams(dArray);
        DiffusionSimulation diffusionSimulation = new DiffusionSimulation(simulationParams, schemeV0);
        double[] dArray2 = diffusionSimulation.nextVoxel();
    }

    private static void testReflectionFromCylinders() {
        SquashyCylinder squashyCylinder;
        int n = 1000;
        double d = 0.0;
        double[] dArray = new double[1];
        Object[] objectArray = new Object[]{new Double(1.0E-6), new Double(2.0E-5), new Integer(1), new Integer(1), new Integer(1), new Double(2.0)};
        double[] dArray2 = new double[]{DIFF_CONST};
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        SimulationParams simulationParams = new SimulationParams(1, n, d, 1, 7, objectArray, 1, 1.0, schemeV0);
        dArray2 = StepGeneratorFactory.getStepParamsArray(1, simulationParams, schemeV0);
        simulationParams.setStepParams(dArray2);
        StepGenerator stepGenerator = StepGeneratorFactory.getStepGenerator(simulationParams);
        DiffusionSimulation diffusionSimulation = new DiffusionSimulation(simulationParams, schemeV0);
        diffusionSimulation.substrate.init();
        ((SquashyInflammationSubstrate)diffusionSimulation.substrate).cylinder[0] = squashyCylinder = new SquashyCylinder(new double[]{1.0, 1.0, 0.0}, 0.5, 0.0);
        double[] dArray3 = squashyCylinder.getPosition();
        double[] dArray4 = squashyCylinder.getAxis();
        double d2 = squashyCylinder.getRadius();
        System.err.println("cylinder position =(" + dArray3[0] + "," + dArray3[1] + "," + dArray3[2] + ")");
        System.err.println("cylinder axis =(" + dArray4[0] + "," + dArray4[1] + "," + dArray4[2] + ")");
        System.err.println("radius = " + d2);
        double[] dArray5 = new double[]{dArray3[0] + 0.9 * d2, dArray3[1], 0.0};
        Walker walker = new Walker(dArray5);
        double[] dArray6 = new double[]{0.2 * d2, 0.0, 0.2 * d2};
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[1];
        double d3 = 0.0;
        for (int i = 0; i < 3; ++i) {
            d3 += dArray6[i] * dArray6[i];
        }
        d3 = Math.sqrt(d3);
        System.err.println("walker pos = " + walker.r[0] + "," + walker.r[1] + "," + walker.r[2] + ")");
        System.err.println("step = (" + dArray6[0] + "," + dArray6[1] + "," + dArray6[2] + ")");
        boolean[] blArray = new boolean[1];
        double[] dArray9 = new double[]{0.0, 0.0, 0.0};
        boolean bl = diffusionSimulation.substrate.crossesMembrane(walker, dArray9, dArray6, dArray7, dArray8, false, d3, blArray, dArray);
        System.err.println("crosses membrane is " + bl);
        double[] dArray10 = new double[3];
        double[] dArray11 = new double[3];
        double[] dArray12 = new double[3];
        diffusionSimulation.substrate.testAmendment(walker, dArray6, dArray7, dArray8, d3, dArray10, dArray11, dArray12);
        System.err.println("toBarrier =(" + dArray10[0] + "," + dArray10[1] + "," + dArray10[2] + ")");
        System.err.println("amended =(" + dArray11[0] + "," + dArray11[1] + "," + dArray11[2] + ",");
        System.err.println("unamended =(" + dArray12[0] + "," + dArray12[1] + "," + dArray12[2] + ",");
    }

    private static void testNonIntersection() {
        SquashyCylinder squashyCylinder;
        int n = 1000;
        double d = 0.0;
        Object[] objectArray = new Object[]{new Double(1.0E-6), new Double(2.0E-5), new Integer(1), new Integer(1), new Integer(1), new Double(2.0)};
        double[] dArray = new double[]{DIFF_CONST};
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        SimulationParams simulationParams = new SimulationParams(1, n, d, 1, 7, objectArray, 1, 1.0, schemeV0);
        dArray = StepGeneratorFactory.getStepParamsArray(1, simulationParams, schemeV0);
        simulationParams.setStepParams(dArray);
        StepGenerator stepGenerator = StepGeneratorFactory.getStepGenerator(simulationParams);
        DiffusionSimulation diffusionSimulation = new DiffusionSimulation(simulationParams, schemeV0);
        diffusionSimulation.substrate.init();
        ((SquashyInflammationSubstrate)diffusionSimulation.substrate).cylinder[0] = squashyCylinder = new SquashyCylinder(new double[]{1.0, 1.0, 0.0}, 2.0, 0.0);
        double[] dArray2 = squashyCylinder.getPosition();
        double[] dArray3 = squashyCylinder.getAxis();
        double d2 = squashyCylinder.getRadius();
        System.err.println("cylinder position =(" + dArray2[0] + "," + dArray2[1] + "," + dArray2[2] + ")");
        System.err.println("cylinder axis =(" + dArray3[0] + "," + dArray3[1] + "," + dArray3[2] + ")");
        System.err.println("radius = " + d2);
        double[] dArray4 = new double[]{dArray2[0], dArray2[1], 0.0};
        Walker walker = new Walker(dArray4);
        double[] dArray5 = new double[]{0.5 * d2, 0.0, 0.0};
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[1];
        double d3 = 0.0;
        for (int i = 0; i < 3; ++i) {
            d3 += dArray5[i] * dArray5[i];
        }
        d3 = Math.sqrt(d3);
        System.err.println("walker pos = " + walker.r[0] + "," + walker.r[1] + "," + walker.r[2] + ")");
        System.err.println("step = (" + dArray5[0] + "," + dArray5[1] + "," + dArray5[2] + ")");
        boolean[] blArray = new boolean[1];
        double[] dArray8 = new double[]{0.0, 0.0, 0.0};
        double[] dArray9 = new double[1];
        boolean bl = diffusionSimulation.substrate.crossesMembrane(walker, dArray8, dArray5, dArray6, dArray7, false, d3, blArray, dArray9);
        System.err.println("crosses membrane is " + bl);
        double[] dArray10 = new double[3];
        double[] dArray11 = new double[3];
        double[] dArray12 = new double[3];
        diffusionSimulation.substrate.testAmendment(walker, dArray5, dArray6, dArray7, d3, dArray10, dArray11, dArray12);
        System.err.println("toBarrier =(" + dArray10[0] + "," + dArray10[1] + "," + dArray10[2] + ")");
        System.err.println("amended =(" + dArray11[0] + "," + dArray11[1] + "," + dArray11[2] + ",");
        System.err.println("unamended =(" + dArray12[0] + "," + dArray12[1] + "," + dArray12[2] + ",");
    }

    private static void testSingleCylinder() {
        int n;
        int n2 = 1000;
        double d = 0.0;
        double d2 = 2.0E-6;
        Object[] objectArray = new Object[]{new Double(1.0E-6), new Double(2.0E-5), new Integer(1), new Integer(1), new Integer(1), new Double(d2)};
        double[] dArray = new double[]{1.0E-7};
        SchemeV0 schemeV0 = SchemeV0.getSchemeV0(7);
        SimulationParams simulationParams = new SimulationParams(100, 100000, d, 0, 7, objectArray, 1, 1.0, schemeV0);
        simulationParams.setStepParams(dArray);
        DiffusionSimulation diffusionSimulation = new DiffusionSimulation(simulationParams, schemeV0);
        SquashyInflammationSubstrate squashyInflammationSubstrate = (SquashyInflammationSubstrate)diffusionSimulation.substrate;
        squashyInflammationSubstrate.P[0][0] = d2 / 2.0;
        squashyInflammationSubstrate.P[0][1] = d2 / 2.0;
        squashyInflammationSubstrate.P[0][2] = d2 / 2.0;
        diffusionSimulation.nextVoxel();
        double[] dArray2 = diffusionSimulation.synthScan.getSignals();
        for (int i = 0; i < dArray2.length; ++i) {
            System.err.println("signal[" + i + "] = " + dArray2[i]);
        }
        double[] dArray3 = new double[]{0.0, 0.0, 0.0};
        for (n = 0; n < diffusionSimulation.walker.length; ++n) {
            for (int i = 0; i < 3; ++i) {
                int n3 = i;
                dArray3[n3] = dArray3[n3] + (diffusionSimulation.walker[n].r[i] - diffusionSimulation.walker[n].r0[i]) * (diffusionSimulation.walker[n].r[i] - diffusionSimulation.walker[n].r0[i]);
            }
        }
        for (n = 0; n < 3; ++n) {
            int n4 = n;
            dArray3[n4] = dArray3[n4] / (double)diffusionSimulation.walker.length;
            System.err.println("meanSq[" + n + "]= " + dArray3[n]);
        }
    }

    private static void testPerfectIsotropy() {
        CL_Initializer.brownianSimulation = true;
        SimulationParams.sim_N_walkers = 10000;
        SimulationParams.sim_tmax = 100;
        SimulationParams.sim_geomType = 13;
        SimulationParams.sim_initial = 0;
        CL_Initializer.numVoxels = 1;
        SimulationParams.sim_l = 0.001;
        CL_Initializer.schemeFile = "facet_scheme_1000.scheme";
        SimulationParams.sim_G = 0.022;
        SimulationParams.sim_G_set = true;
        SimulationParams.sim_delta = 0.032;
        SimulationParams.sim_delta_set = true;
        SimulationParams.sim_DELTA = 0.04;
        SimulationParams.sim_DELTA_set = true;
        OutputManager.outputFile = "perfect.bfloat";
        CL_Initializer.initImagingScheme();
        CL_Initializer.initDataSynthesizer();
        DiffusionSimulation diffusionSimulation = (DiffusionSimulation)CL_Initializer.data;
        SyntheticScan syntheticScan = diffusionSimulation.synthScan;
        double[] dArray = diffusionSimulation.stepGenerator.getStep(null);
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray[i];
        }
        d = Math.sqrt(d);
        double[][] dArray2 = new double[SimulationParams.sim_N_walkers][3];
        int n = SimulationParams.sim_N_walkers;
        Random random = new Random(183745634L);
        for (int i = 0; i < n; ++i) {
            double d2 = Math.PI * 2 * ((double)i / (double)n);
            double d3 = Math.cos(d2) * d;
            double d4 = Math.sin(d2) * d;
            dArray2[i][0] = d3;
            dArray2[i][1] = d4;
            dArray2[i][2] = 0.0;
        }
        diffusionSimulation.initialiseWalkers();
        Walker[] walkerArray = diffusionSimulation.walker;
        for (int i = 0; i < walkerArray.length; ++i) {
            int n2;
            double[] dArray3 = new double[3];
            for (n2 = 0; n2 < 3; ++n2) {
                dArray3[n2] = dArray2[i][n2];
            }
            diffusionSimulation.substrate.amend(walkerArray[i], dArray2[i], 0.0, i);
            for (n2 = 0; n2 < 3; ++n2) {
                if (dArray3[n2] == dArray2[i][n2]) continue;
                diffusionSimulation.logger.warning("step " + i + " amended (dir " + n2);
            }
            walkerArray[i].makeStep(dArray2[i]);
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("walkerPhases.csv"));
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        for (int i = 0; i < walkerArray.length; ++i) {
            int n3;
            for (int j = 0; j < walkerArray[i].dPhi.length; ++j) {
                int n4 = j;
                walkerArray[i].dPhi[n4] = walkerArray[i].dPhi[n4] + syntheticScan.getPhaseShift(walkerArray[i], diffusionSimulation.dt, j, 0.0);
            }
            double[] dArray4 = new double[3];
            for (n3 = 0; n3 < 3; ++n3) {
                dArray4[n3] = dArray2[i][n3];
            }
            diffusionSimulation.substrate.amend(walkerArray[i], dArray2[i], 0.0, i);
            for (n3 = 0; n3 < 3; ++n3) {
                if (dArray4[n3] == dArray2[i][n3]) continue;
                diffusionSimulation.logger.warning("step " + i + " amended (dir " + n3);
            }
            walkerArray[i].makeStep(dArray2[i]);
        }
        double[] dArray5 = diffusionSimulation.synthScan.getSignals();
        for (int i = 0; i < dArray5.length; ++i) {
            double d5 = (double)i / (double)n * 2.0 * Math.PI;
            System.err.println(d5 + " " + dArray5[i]);
        }
    }

    public static void main(String[] stringArray) {
        DiffusionSimulation.testPerfectIsotropy();
    }

    static {
        calls = -1;
    }
}

