/*
 * Decompiled with CFR 0.152.
 */
package optimizers;

import java.text.DecimalFormat;
import java.util.Random;
import java.util.logging.Logger;
import misc.LoggedException;
import tools.FileOutput;

public abstract class SimulatedAnnealingOptimizer {
    protected double temperature = 0.0;
    private final double coolingRate;
    private final int iterationsBetweenCooling;
    private final long iterationsBeforeQuit;
    private static Logger logger = Logger.getLogger("camino.optimizers.SimulatedAnnealingOptimizer");
    protected final Random ran;
    protected String saveStateRoot = "SimulatedAnnealingOptimizer";

    public SimulatedAnnealingOptimizer(double d, int n, long l, String string, Random random) {
        this.coolingRate = d;
        this.iterationsBetweenCooling = n;
        this.iterationsBeforeQuit = l;
        this.ran = random;
        this.saveStateRoot = string;
    }

    public void setTemperature(double d) {
        this.temperature = d;
    }

    public final void minimize() {
        long l = System.currentTimeMillis();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        double d = this.stateEnergy();
        boolean bl3 = false;
        long l2 = 0L;
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        logger.info("Initial temperature\t" + this.temperature + "\nCooling rate\tT(i+1) = (1.0 - " + this.coolingRate + ")T" + "\nIterations\t" + this.iterationsBetweenCooling + "\nInitial state energy \t" + d);
        while (!bl2) {
            if (this.temperature <= 1.0E-8) {
                bl2 = true;
                this.temperature = 0.0;
            }
            boolean bl4 = false;
            for (int i = 0; i < this.iterationsBetweenCooling; ++i) {
                double d4 = this.generateCandidateState();
                boolean bl5 = false;
                double d5 = d4 - d;
                if (d5 < 0.0) {
                    bl5 = true;
                } else if (this.temperature > 0.0) {
                    boolean bl6 = bl5 = this.ran.nextDouble() <= Math.exp(-1.0 * d5 / this.temperature);
                }
                if (!bl5) continue;
                this.acceptCandidateState();
                d = d4;
                if (!(d < d2)) continue;
                bl4 = true;
                bl3 = false;
                d2 = d;
                this.saveStateAsLowestEnergy();
            }
            double d6 = d;
            d = this.stateEnergy();
            if (Math.abs(d - d6) > 1.0E-8) {
                throw new LoggedException("Expected energy : " + d6 + "\n\t actual energy : " + d);
            }
            if (!bl4) {
                if ((l2 += (long)this.iterationsBetweenCooling) > this.iterationsBeforeQuit) {
                    logger.info("Giving up (" + this.iterationsBeforeQuit + " iterations since energy last lowered)");
                    logger.info("Current temperature : " + this.temperature);
                    logger.info("Temperature of last improvement: " + d3);
                    bl2 = true;
                }
            } else {
                l2 = 0L;
                d3 = this.temperature;
            }
            if (!bl2) {
                this.temperature = this.cool(this.temperature);
            }
            if ((int)(System.currentTimeMillis() - l) / 3600000 <= n) continue;
            n = (int)(System.currentTimeMillis() - l) / 3600000;
            FileOutput fileOutput = new FileOutput(this.saveStateRoot + ".state");
            fileOutput.writeString(this.state());
            fileOutput.close();
            if (!bl3) {
                fileOutput = new FileOutput(this.saveStateRoot + ".lowestEnergy");
                fileOutput.writeString(this.lowestEnergyState());
                fileOutput.close();
                bl3 = true;
            }
            logger.info(n + " hours elapsed. Current state saved to " + this.saveStateRoot + ".state. Current temperature is: " + this.temperature);
        }
    }

    protected double cool(double d) {
        return (1.0 - this.coolingRate) * d;
    }

    protected abstract double stateEnergy();

    protected abstract double generateCandidateState();

    protected abstract void acceptCandidateState();

    protected abstract void saveStateAsLowestEnergy();

    protected abstract void setStateToLowestEnergy();

    public abstract String state();

    public abstract String lowestEnergyState();

    public double calibratedTemp(double d) {
        int n;
        double d2 = 0.0;
        double d3 = this.stateEnergy();
        double d4 = 0.0;
        int n2 = 1000000;
        double[] dArray = new double[n2];
        double d5 = d3;
        double d6 = d5 / (double)n2;
        logger.info("Calibrating...");
        logger.info("Input state energy (before calibration) = " + d3);
        long l = System.currentTimeMillis();
        for (int i = 0; i < n2; ++i) {
            double d7 = this.generateCandidateState();
            boolean bl = false;
            dArray[i] = d7 - d5;
            if (dArray[i] <= 0.0) {
                bl = true;
            } else if (d2 > 0.0) {
                double d8 = this.ran.nextDouble();
                boolean bl2 = bl = d8 <= Math.exp(-1.0 * dArray[i] / d2);
            }
            if (bl) {
                this.acceptCandidateState();
                d5 = d7;
            }
            d6 += d5 / (double)n2;
            d4 += dArray[i] / (double)n2;
        }
        long l2 = System.currentTimeMillis();
        double d9 = SimulatedAnnealingOptimizer.std(dArray, d4);
        logger.info("mean state energy = " + d6 + "\nmean (deltaE) = " + d4 + "\nsigma (deltaE) = " + d9);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Acceptance rate for mean deltaE // Temperature\n");
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        for (n = 1; n < 10; ++n) {
            stringBuffer.append((double)n / 10.0 + "\t" + decimalFormat.format(-1.0 * d4 / Math.log((double)n / 10.0)) + "\n");
        }
        stringBuffer.append("\n");
        logger.info(stringBuffer.toString());
        n = (int)(l2 - l);
        logger.info("Calibration run time == " + n + " msecs to complete " + n2 + " runs");
        return -1.0 * d4 / Math.log(d);
    }

    protected static double std(double[] dArray, double d) {
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += (dArray[i] - d) * (dArray[i] - d);
        }
        return Math.sqrt(d2 /= (double)dArray.length - 1.0);
    }
}

