/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import java.util.Random;
import numerics.AxialDistribution;
import numerics.GammaFunctions;
import numerics.Vector3D;

public final class WatsonDistribution
implements AxialDistribution {
    private final Vector3D mu;
    private final double kappa;
    private final double muPhi;
    private final double muTheta;
    private static final double asympThresh = 28.0;
    private final Random ran;

    private WatsonDistribution() {
        this.mu = null;
        this.muPhi = 0.0;
        this.muTheta = 0.0;
        this.kappa = 0.0;
        this.ran = null;
    }

    public WatsonDistribution(Vector3D vector3D, Random random) {
        this.mu = vector3D;
        this.ran = random;
        if (Math.abs(1.0 - vector3D.mod()) > 1.0E-6) {
            throw new IllegalArgumentException("Mean axis of Watson distribution must be a unit vector. Magnitude of mean was " + vector3D.mod());
        }
        double[] dArray = Vector3D.thetaPhi(this.mu);
        this.muTheta = dArray[0];
        this.muPhi = dArray[1];
        this.kappa = 0.0;
    }

    public WatsonDistribution(Vector3D vector3D, double d, Random random) {
        this.mu = vector3D;
        this.ran = random;
        if (Math.abs(1.0 - vector3D.mod()) > 1.0E-6) {
            throw new IllegalArgumentException("Mean axis of Watson distribution must be a unit vector. Magnitude of mean was " + vector3D.mod());
        }
        double[] dArray = Vector3D.thetaPhi(this.mu);
        this.muTheta = dArray[0];
        this.muPhi = dArray[1];
        this.kappa = d;
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("kappa is infinite or NaN");
        }
    }

    @Override
    public double pdf(Vector3D vector3D) {
        return WatsonDistribution.pdf(this.mu, vector3D, this.kappa);
    }

    public double logPDF(Vector3D vector3D) {
        return WatsonDistribution.logPDF(this.mu, vector3D, this.kappa);
    }

    public double pdf(Vector3D vector3D, double d) {
        return WatsonDistribution.pdf(this.mu, vector3D, d);
    }

    public double logPDF(Vector3D vector3D, double d) {
        return WatsonDistribution.logPDF(this.mu, vector3D, d);
    }

    public static double pdf(Vector3D vector3D, Vector3D vector3D2, double d) {
        if (d < 700.0) {
            double d2 = vector3D.dot(vector3D2);
            return Math.exp(d * d2 * d2) / WatsonDistribution.hyper1F1(0.5, 1.5, d, 1.0E-9);
        }
        return Math.exp(WatsonDistribution.logPDF(vector3D, vector3D2, d));
    }

    public static double logPDF(Vector3D vector3D, Vector3D vector3D2, double d) {
        double d2 = vector3D.dot(vector3D2);
        return d * d2 * d2 - WatsonDistribution.logHyper1F1(0.5, 1.5, d, 1.0E-9);
    }

    public static double sumLogPDF(Vector3D vector3D, Vector3D[] vector3DArray, double d) {
        double d2 = 0.0;
        double d3 = WatsonDistribution.logHyper1F1(0.5, 1.5, d, 1.0E-9);
        for (int i = 0; i < vector3DArray.length; ++i) {
            double d4 = vector3D.dot(vector3DArray[i]);
            d2 += d * d4 * d4 - d3;
        }
        return d2;
    }

    public Vector3D meanAxis() {
        return this.mu;
    }

    public double concentration() {
        return this.kappa;
    }

    @Override
    public Vector3D nextVector() {
        return this.nextVector(this.kappa);
    }

    public Vector3D nextVector(double d) {
        Vector3D vector3D;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("kappa is infinite or NaN");
        }
        double d7 = 0.0;
        double d8 = 0.0;
        if (d < 0.0) {
            d6 = Math.sqrt(-1.0 * d);
            d5 = Math.atan(d6);
            d4 = 0.0;
            do {
                d2 = this.ran.nextDouble();
            } while (!((d3 = this.ran.nextDouble()) <= (1.0 - d * (d4 = 1.0 / d6 * Math.tan(d5 * d2)) * d4) * Math.exp(d * d4 * d4)));
            d7 = this.muTheta + Math.acos(d4);
            d8 = this.muPhi;
            if (d7 > Math.PI) {
                d7 -= Math.PI;
            }
            vector3D = Vector3D.vectorFromSPC(1.0, d7, d8);
            if (this.ran.nextDouble() > 0.5) {
                vector3D = vector3D.negated();
            }
        } else {
            if (d == 0.0) {
                d8 = Math.PI * 2 * this.ran.nextDouble();
                d7 = Math.acos(2.0 * this.ran.nextDouble() - 1.0);
                return Vector3D.vectorFromSPC(1.0, d7, d8);
            }
            if (d > 700.0) {
                d6 = -1.0 * d;
                d5 = 0.0;
                do {
                    d4 = this.ran.nextDouble();
                } while (!((d2 = this.ran.nextDouble()) <= Math.exp(d * (d5 = 1.0 / d * (Math.log(d4) - d6)) * (d5 - 1.0))));
                d7 = this.muTheta + Math.acos(d5);
                d8 = this.muPhi;
                if (d7 > Math.PI) {
                    d7 -= Math.PI;
                }
                vector3D = Vector3D.vectorFromSPC(1.0, d7, d8);
                if (this.ran.nextDouble() > 0.5) {
                    vector3D = vector3D.negated();
                }
            } else {
                d6 = 1.0 / (Math.exp(d) - 1.0);
                d5 = 0.0;
                do {
                    d4 = this.ran.nextDouble();
                } while (!((d2 = this.ran.nextDouble()) <= Math.exp(d * (d5 = 1.0 / d * Math.log(1.0 + d4 / d6)) * (d5 - 1.0))));
                d7 = this.muTheta + Math.acos(d5);
                d8 = this.muPhi;
                if (d7 > Math.PI) {
                    d7 -= Math.PI;
                }
                vector3D = Vector3D.vectorFromSPC(1.0, d7, d8);
                if (this.ran.nextDouble() > 0.5) {
                    vector3D = vector3D.negated();
                }
            }
        }
        d6 = Math.PI * 2 * this.ran.nextDouble();
        d5 = Math.cos(d6);
        d4 = Math.sin(d6);
        d2 = (this.mu.x * this.mu.x * (1.0 - d5) + d5) * vector3D.x + (this.mu.x * this.mu.y * (1.0 - d5) - this.mu.z * d4) * vector3D.y + (this.mu.x * this.mu.z * (1.0 - d5) + this.mu.y * d4) * vector3D.z;
        d3 = (this.mu.y * this.mu.x * (1.0 - d5) + this.mu.z * d4) * vector3D.x + (this.mu.y * this.mu.y * (1.0 - d5) + d5) * vector3D.y + (this.mu.y * this.mu.z * (1.0 - d5) - this.mu.x * d4) * vector3D.z;
        double d9 = (this.mu.z * this.mu.x * (1.0 - d5) - this.mu.y * d4) * vector3D.x + (this.mu.z * this.mu.y * (1.0 - d5) + this.mu.x * d4) * vector3D.y + (this.mu.z * this.mu.z * (1.0 - d5) + d5) * vector3D.z;
        return new Vector3D(d2, d3, d9);
    }

    public static Vector3D nextVector(double d, double d2, double d3, Random random) {
        Vector3D vector3D;
        double d4;
        double d5;
        double d6;
        double d7;
        if (Double.isInfinite(d3) || Double.isNaN(d3)) {
            throw new IllegalArgumentException("kappa is infinite or NaN");
        }
        if (d3 < 0.0) {
            double d8;
            d7 = Math.sqrt(-1.0 * d3);
            d6 = Math.atan(d7);
            d5 = 0.0;
            do {
                d4 = random.nextDouble();
            } while (!((d8 = random.nextDouble()) <= (1.0 - d3 * (d5 = 1.0 / d7 * Math.tan(d6 * d4)) * d5) * Math.exp(d3 * d5 * d5)));
            d4 = d + Math.acos(d5);
            d8 = d2;
            if (d4 > Math.PI) {
                d4 -= Math.PI;
            }
            vector3D = Vector3D.vectorFromSPC(1.0, d4, d8);
            if (random.nextDouble() > 0.5) {
                vector3D = vector3D.negated();
            }
        } else {
            if (d3 == 0.0) {
                double d9 = Math.PI * 2 * random.nextDouble();
                double d10 = Math.acos(2.0 * random.nextDouble() - 1.0);
                return Vector3D.vectorFromSPC(1.0, d10, d9);
            }
            if (d3 > 700.0) {
                return WatsonDistribution.nextVectorLargeK(d, d2, d3, random);
            }
            d7 = 1.0 / (Math.exp(d3) - 1.0);
            d6 = 0.0;
            do {
                d5 = random.nextDouble();
            } while (!((d4 = random.nextDouble()) <= Math.exp(d3 * (d6 = 1.0 / d3 * Math.log(1.0 + d5 / d7)) * (d6 - 1.0))));
            d5 = d + Math.acos(d6);
            d4 = d2;
            if (d5 < 0.0 || d5 > Math.PI) {
                d4 = Math.PI + d4;
            }
            vector3D = Vector3D.vectorFromSPC(1.0, d5, d4);
            if (random.nextDouble() > 0.5) {
                vector3D = vector3D.negated();
            }
        }
        d7 = Math.PI * 2 * random.nextDouble();
        d6 = Math.cos(d7);
        d5 = Math.sin(d7);
        Vector3D vector3D2 = Vector3D.vectorFromSPC(1.0, d, d2);
        double d11 = (vector3D2.x * vector3D2.x * (1.0 - d6) + d6) * vector3D.x + (vector3D2.x * vector3D2.y * (1.0 - d6) - vector3D2.z * d5) * vector3D.y + (vector3D2.x * vector3D2.z * (1.0 - d6) + vector3D2.y * d5) * vector3D.z;
        double d12 = (vector3D2.y * vector3D2.x * (1.0 - d6) + vector3D2.z * d5) * vector3D.x + (vector3D2.y * vector3D2.y * (1.0 - d6) + d6) * vector3D.y + (vector3D2.y * vector3D2.z * (1.0 - d6) - vector3D2.x * d5) * vector3D.z;
        double d13 = (vector3D2.z * vector3D2.x * (1.0 - d6) - vector3D2.y * d5) * vector3D.x + (vector3D2.z * vector3D2.y * (1.0 - d6) + vector3D2.x * d5) * vector3D.y + (vector3D2.z * vector3D2.z * (1.0 - d6) + d6) * vector3D.z;
        return new Vector3D(d11, d12, d13);
    }

    public Vector3D nextVector(Vector3D vector3D, double d) {
        double[] dArray = Vector3D.thetaPhi(vector3D);
        return WatsonDistribution.nextVector(dArray[0], dArray[1], d, this.ran);
    }

    public static Vector3D nextVector(Vector3D vector3D, double d, Random random) {
        double[] dArray = Vector3D.thetaPhi(vector3D);
        return WatsonDistribution.nextVector(dArray[0], dArray[1], d, random);
    }

    private static Vector3D nextVectorLargeK(double d, double d2, double d3, Random random) {
        double d4;
        double d5;
        double d6 = -1.0 * d3;
        double d7 = 0.0;
        do {
            d4 = random.nextDouble();
        } while (!((d5 = random.nextDouble()) <= Math.exp(d3 * (d7 = 1.0 / d3 * (Math.log(d4) - d6)) * (d7 - 1.0))));
        d4 = d + Math.acos(d7);
        d5 = d2;
        if (d4 < 0.0 || d4 > Math.PI) {
            d5 += Math.PI;
        }
        Vector3D vector3D = Vector3D.vectorFromSPC(1.0, d4, d5);
        if (random.nextDouble() > 0.5) {
            vector3D = vector3D.negated();
        }
        double d8 = Math.PI * 2 * random.nextDouble();
        double d9 = Math.cos(d8);
        double d10 = Math.sin(d8);
        Vector3D vector3D2 = Vector3D.vectorFromSPC(1.0, d, d2);
        double d11 = (vector3D2.x * vector3D2.x * (1.0 - d9) + d9) * vector3D.x + (vector3D2.x * vector3D2.y * (1.0 - d9) - vector3D2.z * d10) * vector3D.y + (vector3D2.x * vector3D2.z * (1.0 - d9) + vector3D2.y * d10) * vector3D.z;
        double d12 = (vector3D2.y * vector3D2.x * (1.0 - d9) + vector3D2.z * d10) * vector3D.x + (vector3D2.y * vector3D2.y * (1.0 - d9) + d9) * vector3D.y + (vector3D2.y * vector3D2.z * (1.0 - d9) - vector3D2.x * d10) * vector3D.z;
        double d13 = (vector3D2.z * vector3D2.x * (1.0 - d9) - vector3D2.y * d10) * vector3D.x + (vector3D2.z * vector3D2.y * (1.0 - d9) + vector3D2.x * d10) * vector3D.y + (vector3D2.z * vector3D2.z * (1.0 - d9) + d9) * vector3D.z;
        return new Vector3D(d11, d12, d13);
    }

    public static double hyper1F1(double d, double d2, double d3, double d4) {
        if (d == d2) {
            return Math.exp(d3);
        }
        if (d2 <= 0.0) {
            System.err.println("hyper1F1: b <= 0.0, 0 returned");
            return 0.0;
        }
        double d5 = 0.1 * d4;
        if (Math.abs(d3) < 28.0) {
            double d6 = 1.0;
            double d7 = 10.0;
            double d8 = d;
            double d9 = d2;
            double d10 = 1.0;
            double d11 = 1.0;
            double d12 = 1.0;
            while (d7 > d5) {
                double d13 = (d11 *= d8 / (d9 * d10)) * (d12 *= d3);
                d8 += 1.0;
                d9 += 1.0;
                d10 += 1.0;
                d7 = Math.abs(d13 / (d6 += d13));
            }
            return d6;
        }
        if (d3 >= 28.0) {
            if (d <= 0.0) {
                System.err.println("a <= 0.0 and x >= 28.0. 0 returned");
                return 0.0;
            }
            int n = 0;
            double d14 = 1.0;
            double d15 = d2 - d;
            double d16 = 1.0 - d;
            double d17 = 1.0;
            double d18 = 100.0;
            double d19 = 1.0;
            double d20 = 10.0;
            while (d20 > d5) {
                ++n;
                d20 = Math.abs(d17 / (d19 += (d17 *= (d15 += 1.0) * (d16 += 1.0) / ((d14 += 1.0) * d3))));
                double d21 = Math.abs(d17);
                if (d21 > d18) {
                    System.err.println("Series diverging after " + n + " terms");
                    d20 = 0.0;
                    continue;
                }
                d18 = d21;
            }
            return Math.exp(GammaFunctions.gammln(d2) + d3 - GammaFunctions.gammln(d)) * Math.pow(d3, d - d2) * d19;
        }
        if (d2 <= d) {
            System.err.println("b <= a, x <= -28.0. 0 returned");
            return 0.0;
        }
        double d22 = -1.0 * d3;
        int n = 0;
        double d23 = 1.0;
        double d24 = d - d2 + 1.0;
        double d25 = d;
        double d26 = 1.0;
        double d27 = 100.0;
        double d28 = 1.0;
        double d29 = 10.0;
        while (d29 < d5) {
            ++n;
            d29 = Math.abs(d26 / (d28 += (d26 *= (d25 += 1.0) * (d24 += 1.0) / ((d23 += 1.0) * d22))));
            double d30 = Math.abs(d26);
            if (d30 > d27) {
                System.err.println("Series diverging after " + n + " terms");
                d29 = 0.0;
                continue;
            }
            d27 = d30;
        }
        return Math.exp(GammaFunctions.gammln(d2) - GammaFunctions.gammln(d2 - d)) * d28 / Math.pow(d22, d);
    }

    public static double logHyper1F1(double d, double d2, double d3, double d4) {
        double d5 = 0.1 * d4;
        if (d3 <= 28.0) {
            return Math.log(WatsonDistribution.hyper1F1(d, d2, d3, d4));
        }
        if (d <= 0.0) {
            System.err.println("a <= 0.0 and x >= 28.0. 0 returned");
            return 0.0;
        }
        int n = 0;
        double d6 = 1.0;
        double d7 = d2 - d;
        double d8 = 1.0 - d;
        double d9 = 1.0;
        double d10 = 100.0;
        double d11 = 1.0;
        double d12 = 10.0;
        while (d12 > d5) {
            ++n;
            d12 = Math.abs(d9 / (d11 += (d9 *= (d7 += 1.0) * (d8 += 1.0) / ((d6 += 1.0) * d3))));
            double d13 = Math.abs(d9);
            if (d13 > d10) {
                System.err.println("Series diverging after " + n + " terms");
                d12 = 0.0;
                continue;
            }
            d10 = d13;
        }
        return GammaFunctions.gammln(d2) + d3 - GammaFunctions.gammln(d) + Math.log(Math.pow(d3, d - d2)) + Math.log(d11);
    }
}

