/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.EigenSystem3D;
import numerics.NumDeriv;
import numerics.Rotations;
import numerics.Vector3D;
import numerics.WatsonDistribution;
import numerics.WatsonFitter;
import optimizers.MarquardtMinimiser;
import optimizers.MarquardtMinimiserException;
import tools.FileInput;

public class TwoFibreWatsonFitter
extends MarquardtMinimiser {
    private static final Logger logger = Logger.getLogger("numerics.TwoFibreWtsonFitter");
    Vector3D[] samples;

    @Override
    protected double fObj(double[] dArray, double[] dArray2, double[][] dArray3) {
        double d = 0.0;
        Vector3D vector3D = Vector3D.vectorFromSPC(1.0, dArray[1], dArray[2]);
        Vector3D vector3D2 = Vector3D.vectorFromSPC(1.0, dArray[4], dArray[5]);
        double d2 = Math.sin(dArray[7]);
        d2 *= d2;
        double[] dArray4 = new double[this.samples.length];
        double[][] dArray5 = new double[this.ma + 1][this.samples.length];
        double d3 = WatsonDistribution.hyper1F1(0.5, 1.5, dArray[3], 1.0E-9);
        double d4 = WatsonDistribution.hyper1F1(0.5, 1.5, dArray[6], 1.0E-9);
        for (int i = 0; i < this.samples.length; ++i) {
            dArray4[i] = d2 * (1.0 / d3) * Math.exp(dArray[3] * Math.pow(Math.sin(dArray[1]) * Math.cos(dArray[2]) * this.samples[i].x + Math.sin(dArray[1]) * Math.sin(dArray[2]) * this.samples[i].y + Math.cos(dArray[1]) * this.samples[i].z, 2.0)) + (1.0 - d2) * (1.0 / d4) * Math.exp(dArray[6] * Math.pow(Math.sin(dArray[4]) * Math.cos(dArray[5]) * this.samples[i].x + Math.sin(dArray[4]) * Math.sin(dArray[5]) * this.samples[i].y + Math.cos(dArray[4]) * this.samples[i].z, 2.0));
            d -= Math.log(dArray4[i]);
        }
        double d5 = WatsonDistribution.hyper1F1(1.5, 2.5, dArray[3], 1.0E-9);
        double d6 = WatsonDistribution.hyper1F1(1.5, 2.5, dArray[6], 1.0E-9);
        this.firstDeriv(dArray, dArray4, dArray5, dArray2, d3, d4, d5, d6);
        this.secondDeriv(dArray, dArray4, dArray5, dArray3, d3, d4, d5, d6);
        return d;
    }

    public void firstDeriv(double[] dArray, double[] dArray2, double[][] dArray3, double[] dArray4, double d, double d2, double d3, double d4) {
        double d5 = Math.cos(dArray[1]);
        double d6 = Math.sin(dArray[1]);
        double d7 = Math.cos(dArray[2]);
        double d8 = Math.sin(dArray[2]);
        double d9 = Math.cos(dArray[4]);
        double d10 = Math.sin(dArray[4]);
        double d11 = Math.cos(dArray[5]);
        double d12 = Math.sin(dArray[5]);
        double d13 = Math.sin(dArray[7]);
        d13 *= d13;
        for (int i = 0; i < this.samples.length; ++i) {
            double d14 = this.samples[i].x;
            double d15 = this.samples[i].y;
            double d16 = this.samples[i].z;
            double d17 = Math.pow(d16 * d5 + d14 * d7 * d6 + d15 * d6 * d8, 2.0);
            double d18 = Math.pow(d16 * d9 + d14 * d11 * d10 + d15 * d10 * d12, 2.0);
            double d19 = Math.exp(dArray[3] * d17);
            double d20 = Math.exp(dArray[6] * d18);
            dArray3[1][i] = 2.0 * d19 * dArray[3] * (d14 * d5 * d7 - d16 * d6 + d15 * d5 * d8) * (d16 * d5 + d14 * d7 * d6 + d15 * d6 * d8) * d13 / d;
            dArray4[1] = dArray4[1] - 1.0 / dArray2[i] * dArray3[1][i];
            dArray3[2][i] = 2.0 * d19 * dArray[3] * (d15 * d7 * d6 - d14 * d6 * d8) * (d16 * d5 + d14 * d7 * d6 + d15 * d6 * d8) * d13 / d;
            dArray4[2] = dArray4[2] - 1.0 / dArray2[i] * dArray3[2][i];
            dArray3[3][i] = -0.3333333333333333 * d19 * d3 * d13 / Math.pow(d, 2.0) + d19 * d17 * d13 / d;
            dArray4[3] = dArray4[3] - 1.0 / dArray2[i] * dArray3[3][i];
            dArray3[4][i] = 2.0 * d20 * dArray[6] * (d14 * d9 * d11 - d16 * d10 + d15 * d9 * d12) * (d16 * d9 + d14 * d11 * d10 + d15 * d10 * d12) * (1.0 - d13) / d2;
            dArray4[4] = dArray4[4] - 1.0 / dArray2[i] * dArray3[4][i];
            dArray3[5][i] = 2.0 * d20 * dArray[6] * (d15 * d11 * d10 - d14 * d10 * d12) * (d16 * d9 + d14 * d11 * d10 + d15 * d10 * d12) * (1.0 - d13) / d2;
            dArray4[5] = dArray4[5] - 1.0 / dArray2[i] * dArray3[5][i];
            dArray3[6][i] = -0.3333333333333333 * d20 * d4 * (1.0 - d13) / Math.pow(d2, 2.0) + d20 * d18 * (1.0 - d13) / d2;
            dArray4[6] = dArray4[6] - 1.0 / dArray2[i] * dArray3[6][i];
            dArray3[7][i] = 2.0 * d19 * Math.cos(dArray[7]) * Math.sin(dArray[7]) / d - 2.0 * d20 * Math.cos(dArray[7]) * Math.sin(dArray[7]) / d2;
            dArray4[7] = dArray4[7] - 1.0 / dArray2[i] * dArray3[7][i];
        }
    }

    protected double[] firstDerivNumerical(double[] dArray) {
        int n;
        double[] dArray2 = new double[this.ma + 1];
        final double[] dArray3 = new double[dArray.length];
        for (n = 1; n < dArray.length; ++n) {
            dArray3[n] = dArray[n];
        }
        for (n = 1; n <= this.ma; ++n) {
            final int n2 = n;
            NumDeriv numDeriv = new NumDeriv(){
                private double[] dfda;
                private double[][] d2fda2;
                {
                    this.dfda = new double[TwoFibreWatsonFitter.this.ma + 1];
                    this.d2fda2 = new double[TwoFibreWatsonFitter.this.ma + 1][TwoFibreWatsonFitter.this.ma + 1];
                }

                @Override
                protected float func(float f) {
                    dArray3[n2] = f;
                    float f2 = (float)TwoFibreWatsonFitter.this.fObj(dArray3, this.dfda, this.d2fda2);
                    return f2;
                }
            };
            float[] fArray = new float[1];
            dArray2[n] = numDeriv.dfridr((float)dArray[n], 0.1f * (float)dArray[n], fArray);
            dArray3[n2] = dArray[n2];
        }
        return dArray2;
    }

    protected void secondDeriv(double[] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4, double d, double d2, double d3, double d4) {
        int n;
        double d5 = Math.sin(dArray[7]);
        d5 *= d5;
        double d6 = Math.cos(dArray[1]);
        double d7 = Math.sin(dArray[1]);
        double d8 = Math.cos(dArray[2]);
        double d9 = Math.sin(dArray[2]);
        double d10 = Math.cos(dArray[4]);
        double d11 = Math.sin(dArray[4]);
        double d12 = Math.cos(dArray[5]);
        double d13 = Math.sin(dArray[5]);
        for (n = 0; n < this.samples.length; ++n) {
            double d14 = this.samples[n].x;
            double d15 = this.samples[n].y;
            double d16 = this.samples[n].z;
            double d17 = 1.0 / dArray2[n];
            double d18 = d17 * d17;
            double d19 = Math.pow(d16 * d6 + d14 * d8 * d7 + d15 * d7 * d9, 2.0);
            double d20 = Math.pow(d16 * d10 + d14 * d12 * d11 + d15 * d11 * d13, 2.0);
            double d21 = Math.exp(dArray[3] * d19);
            double d22 = Math.exp(dArray[6] * d20);
            double[] dArray5 = dArray4[1];
            dArray5[1] = dArray5[1] - (d17 * (2.0 * d21 * dArray[3] * Math.pow(d14 * d6 * d8 - d16 * d7 + d15 * d6 * d9, 2.0) * d5 / d + 2.0 * d21 * dArray[3] * (-(d16 * d6) - d14 * d8 * d7 - d15 * d7 * d9) * (d16 * d6 + d14 * d8 * d7 + d15 * d7 * d9) * d5 / d + 4.0 * d21 * Math.pow(dArray[3], 2.0) * Math.pow(d14 * d6 * d8 - d16 * d7 + d15 * d6 * d9, 2.0) * d19 * d5 / d) - d18 * dArray3[1][n] * dArray3[1][n]);
            double[] dArray6 = dArray4[1];
            dArray6[2] = dArray6[2] - (d17 * (2.0 * d21 * dArray[3] * (d14 * d6 * d8 - d16 * d7 + d15 * d6 * d9) * (d15 * d8 * d7 - d14 * d7 * d9) * d5 / d + 2.0 * d21 * dArray[3] * (d15 * d6 * d8 - d14 * d6 * d9) * (d16 * d6 + d14 * d8 * d7 + d15 * d7 * d9) * d5 / d + 4.0 * d21 * Math.pow(dArray[3], 2.0) * (d14 * d6 * d8 - d16 * d7 + d15 * d6 * d9) * (d15 * d8 * d7 - d14 * d7 * d9) * d19 * d5 / d) - d18 * dArray3[1][n] * dArray3[2][n]);
            double[] dArray7 = dArray4[1];
            dArray7[3] = dArray7[3] - (d17 * (2.0 * d21 * (d14 * d6 * d8 - d16 * d7 + d15 * d6 * d9) * (d16 * d6 + d14 * d8 * d7 + d15 * d7 * d9) * d5 / d - 0.6666666666666666 * d21 * dArray[3] * d3 * (d14 * d6 * d8 - d16 * d7 + d15 * d6 * d9) * (d16 * d6 + d14 * d8 * d7 + d15 * d7 * d9) * d5 / Math.pow(d, 2.0) + 2.0 * d21 * dArray[3] * (d14 * d6 * d8 - d16 * d7 + d15 * d6 * d9) * Math.pow(d16 * d6 + d14 * d8 * d7 + d15 * d7 * d9, 3.0) * d5 / d) - d18 * dArray3[1][n] * dArray3[3][n]);
            double[] dArray8 = dArray4[1];
            dArray8[4] = dArray8[4] - 0.0;
            double[] dArray9 = dArray4[1];
            dArray9[5] = dArray9[5] - 0.0;
            double[] dArray10 = dArray4[1];
            dArray10[6] = dArray10[6] - 0.0;
            double[] dArray11 = dArray4[1];
            dArray11[7] = dArray11[7] - (d17 * (4.0 * d21 * dArray[3] * Math.cos(dArray[7]) * (d14 * d6 * d8 - d16 * d7 + d15 * d6 * d9) * (d16 * d6 + d14 * d8 * d7 + d15 * d7 * d9) * Math.sin(dArray[7]) / d) - d18 * dArray3[1][n] * dArray3[7][n]);
            double[] dArray12 = dArray4[2];
            dArray12[2] = dArray12[2] - (d17 * (2.0 * d21 * dArray[3] * Math.pow(d15 * d8 * d7 - d14 * d7 * d9, 2.0) * d5 / d + 2.0 * d21 * dArray[3] * (-(d14 * d8 * d7) - d15 * d7 * d9) * (d16 * d6 + d14 * d8 * d7 + d15 * d7 * d9) * d5 / d + 4.0 * d21 * Math.pow(dArray[3], 2.0) * Math.pow(d15 * d8 * d7 - d14 * d7 * d9, 2.0) * d19 * d5 / d) - d18 * dArray3[2][n] * dArray3[2][n]);
            double[] dArray13 = dArray4[2];
            dArray13[3] = dArray13[3] - (d17 * (2.0 * d21 * (d15 * d8 * d7 - d14 * d7 * d9) * (d16 * d6 + d14 * d8 * d7 + d15 * d7 * d9) * d5 / d - 0.6666666666666666 * d21 * dArray[3] * d3 * (d15 * d8 * d7 - d14 * d7 * d9) * (d16 * d6 + d14 * d8 * d7 + d15 * d7 * d9) * d5 / Math.pow(d, 2.0) + 2.0 * d21 * dArray[3] * (d15 * d8 * d7 - d14 * d7 * d9) * Math.pow(d16 * d6 + d14 * d8 * d7 + d15 * d7 * d9, 3.0) * d5 / d) - d18 * dArray3[2][n] * dArray3[3][n]);
            double[] dArray14 = dArray4[2];
            dArray14[4] = dArray14[4] - 0.0;
            double[] dArray15 = dArray4[2];
            dArray15[5] = dArray15[5] - 0.0;
            double[] dArray16 = dArray4[2];
            dArray16[6] = dArray16[6] - 0.0;
            double[] dArray17 = dArray4[2];
            dArray17[7] = dArray17[7] - (d17 * (4.0 * d21 * dArray[3] * Math.cos(dArray[7]) * (d15 * d8 * d7 - d14 * d7 * d9) * (d16 * d6 + d14 * d8 * d7 + d15 * d7 * d9) * Math.sin(dArray[7]) / d) - d18 * dArray3[2][n] * dArray3[7][n]);
            double[] dArray18 = dArray4[3];
            dArray18[3] = dArray18[3] - (d17 * (0.2222222222222222 * d21 * Math.pow(d3, 2.0) * d5 / Math.pow(d, 3.0) - 0.2 * d21 * WatsonDistribution.hyper1F1(2.5, 3.5, dArray[3], 1.0E-7) * d5 / Math.pow(d, 2.0) - 0.6666666666666666 * d21 * d3 * d19 * d5 / Math.pow(d, 2.0) + d21 * Math.pow(d16 * d6 + d14 * d8 * d7 + d15 * d7 * d9, 4.0) * d5 / d) - d18 * dArray3[3][n] * dArray3[3][n]);
            double[] dArray19 = dArray4[3];
            dArray19[4] = dArray19[4] - 0.0;
            double[] dArray20 = dArray4[3];
            dArray20[5] = dArray20[5] - 0.0;
            double[] dArray21 = dArray4[3];
            dArray21[6] = dArray21[6] - 0.0;
            double[] dArray22 = dArray4[3];
            dArray22[7] = dArray22[7] - (d17 * (-0.6666666666666666 * d21 * Math.cos(dArray[7]) * d3 * Math.sin(dArray[7]) / Math.pow(d, 2.0) + 2.0 * d21 * Math.cos(dArray[7]) * d19 * Math.sin(dArray[7]) / d) - d18 * dArray3[3][n] * dArray3[7][n]);
            double[] dArray23 = dArray4[4];
            dArray23[4] = dArray23[4] - (d17 * (2.0 * d22 * dArray[6] * Math.pow(d14 * d10 * d12 - d16 * d11 + d15 * d10 * d13, 2.0) * (1.0 - d5) / d2 + 2.0 * d22 * dArray[6] * (-(d16 * d10) - d14 * d12 * d11 - d15 * d11 * d13) * (d16 * d10 + d14 * d12 * d11 + d15 * d11 * d13) * (1.0 - d5) / d2 + 4.0 * d22 * Math.pow(dArray[6], 2.0) * Math.pow(d14 * d10 * d12 - d16 * d11 + d15 * d10 * d13, 2.0) * d20 * (1.0 - d5) / d2) - d18 * dArray3[4][n] * dArray3[4][n]);
            double[] dArray24 = dArray4[4];
            dArray24[5] = dArray24[5] - (d17 * (2.0 * d22 * dArray[6] * (d14 * d10 * d12 - d16 * d11 + d15 * d10 * d13) * (d15 * d12 * d11 - d14 * d11 * d13) * (1.0 - d5) / d2 + 2.0 * d22 * dArray[6] * (d15 * d10 * d12 - d14 * d10 * d13) * (d16 * d10 + d14 * d12 * d11 + d15 * d11 * d13) * (1.0 - d5) / d2 + 4.0 * d22 * Math.pow(dArray[6], 2.0) * (d14 * d10 * d12 - d16 * d11 + d15 * d10 * d13) * (d15 * d12 * d11 - d14 * d11 * d13) * d20 * (1.0 - d5) / d2) - d18 * dArray3[4][n] * dArray3[5][n]);
            double[] dArray25 = dArray4[4];
            dArray25[6] = dArray25[6] - (d17 * (2.0 * d22 * (d14 * d10 * d12 - d16 * d11 + d15 * d10 * d13) * (d16 * d10 + d14 * d12 * d11 + d15 * d11 * d13) * (1.0 - d5) / d2 - 0.6666666666666666 * d22 * dArray[6] * d4 * (d14 * d10 * d12 - d16 * d11 + d15 * d10 * d13) * (d16 * d10 + d14 * d12 * d11 + d15 * d11 * d13) * (1.0 - d5) / Math.pow(d2, 2.0) + 2.0 * d22 * dArray[6] * (d14 * d10 * d12 - d16 * d11 + d15 * d10 * d13) * Math.pow(d16 * d10 + d14 * d12 * d11 + d15 * d11 * d13, 3.0) * (1.0 - d5) / d2) - d18 * dArray3[4][n] * dArray3[6][n]);
            double[] dArray26 = dArray4[4];
            dArray26[7] = dArray26[7] - (d17 * (-4.0 * d22 * dArray[6] * Math.cos(dArray[7]) * (d14 * d10 * d12 - d16 * d11 + d15 * d10 * d13) * (d16 * d10 + d14 * d12 * d11 + d15 * d11 * d13) * Math.sin(dArray[7]) / d2) - d18 * dArray3[4][n] * dArray3[7][n]);
            double[] dArray27 = dArray4[5];
            dArray27[5] = dArray27[5] - (d17 * (2.0 * d22 * dArray[6] * Math.pow(d15 * d12 * d11 - d14 * d11 * d13, 2.0) * (1.0 - d5) / d2 + 2.0 * d22 * dArray[6] * (-(d14 * d12 * d11) - d15 * d11 * d13) * (d16 * d10 + d14 * d12 * d11 + d15 * d11 * d13) * (1.0 - d5) / d2 + 4.0 * d22 * Math.pow(dArray[6], 2.0) * Math.pow(d15 * d12 * d11 - d14 * d11 * d13, 2.0) * d20 * (1.0 - d5) / d2) - d18 * dArray3[5][n] * dArray3[5][n]);
            double[] dArray28 = dArray4[5];
            dArray28[6] = dArray28[6] - (d17 * (2.0 * d22 * (d15 * d12 * d11 - d14 * d11 * d13) * (d16 * d10 + d14 * d12 * d11 + d15 * d11 * d13) * (1.0 - d5) / d2 - 0.6666666666666666 * d22 * dArray[6] * d4 * (d15 * d12 * d11 - d14 * d11 * d13) * (d16 * d10 + d14 * d12 * d11 + d15 * d11 * d13) * (1.0 - d5) / Math.pow(d2, 2.0) + 2.0 * d22 * dArray[6] * (d15 * d12 * d11 - d14 * d11 * d13) * Math.pow(d16 * d10 + d14 * d12 * d11 + d15 * d11 * d13, 3.0) * (1.0 - d5) / d2) - d18 * dArray3[5][n] * dArray3[6][n]);
            double[] dArray29 = dArray4[5];
            dArray29[7] = dArray29[7] - (d17 * (-4.0 * d22 * dArray[6] * Math.cos(dArray[7]) * (d15 * d12 * d11 - d14 * d11 * d13) * (d16 * d10 + d14 * d12 * d11 + d15 * d11 * d13) * Math.sin(dArray[7]) / d2) - d18 * dArray3[5][n] * dArray3[7][n]);
            double[] dArray30 = dArray4[6];
            dArray30[6] = dArray30[6] - (d17 * (0.2222222222222222 * d22 * Math.pow(d4, 2.0) * (1.0 - d5) / Math.pow(d2, 3.0) - 0.2 * d22 * WatsonDistribution.hyper1F1(2.5, 3.5, dArray[6], 1.0E-7) * (1.0 - d5) / Math.pow(d2, 2.0) - 0.6666666666666666 * d22 * d4 * d20 * (1.0 - d5) / Math.pow(d2, 2.0) + d22 * Math.pow(d16 * d10 + d14 * d12 * d11 + d15 * d11 * d13, 4.0) * (1.0 - d5) / d2) - d18 * dArray3[6][n] * dArray3[6][n]);
            double[] dArray31 = dArray4[6];
            dArray31[7] = dArray31[7] - (d17 * (0.6666666666666666 * d22 * Math.cos(dArray[7]) * d4 * Math.sin(dArray[7]) / Math.pow(d2, 2.0) - 2.0 * d22 * Math.cos(dArray[7]) * d20 * Math.sin(dArray[7]) / d2) - d18 * dArray3[6][n] * dArray3[7][n]);
            double[] dArray32 = dArray4[7];
            dArray32[7] = dArray32[7] - (d17 * (2.0 * d21 * Math.pow(Math.cos(dArray[7]), 2.0) / d - 2.0 * d22 * Math.pow(Math.cos(dArray[7]), 2.0) / d2 - 2.0 * d21 * d5 / d + 2.0 * d22 * d5 / d2) - d18 * dArray3[7][n] * dArray3[7][n]);
        }
        for (n = 1; n <= this.ma; ++n) {
            for (int i = 1; i <= n; ++i) {
                dArray4[n][i] = dArray4[i][n];
            }
        }
    }

    public WatsonDistribution[] getDistributions() {
        Random random = new Random();
        Vector3D vector3D = Vector3D.vectorFromSPC(1.0, this.a[1], this.a[2]);
        Vector3D vector3D2 = Vector3D.vectorFromSPC(1.0, this.a[4], this.a[5]);
        return new WatsonDistribution[]{new WatsonDistribution(vector3D, this.a[3], random), new WatsonDistribution(vector3D2, this.a[6], random)};
    }

    public Vector3D[] getMus() {
        Vector3D vector3D = Vector3D.vectorFromSPC(1.0, this.a[1], this.a[2]);
        Vector3D vector3D2 = Vector3D.vectorFromSPC(1.0, this.a[4], this.a[5]);
        return new Vector3D[]{vector3D, vector3D2};
    }

    public double getMixingParameter() {
        return Math.sin(this.a[7]) * Math.sin(this.a[7]);
    }

    public double[] getKappas() {
        return new double[]{this.a[3], this.a[6]};
    }

    @Override
    public void setInitParams(double[] dArray) throws MarquardtMinimiserException {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i];
        }
        dArray2[6] = Math.asin(Math.sqrt(dArray2[6]));
        super.setInitParams(dArray2);
    }

    public void fitEstimatedParams(double d, int n) throws MarquardtMinimiserException {
        EigenSystem3D eigenSystem3D = WatsonFitter.tBarEigenSystem(this.samples);
        double[] dArray = new double[7];
        dArray[2] = -1.0 * WatsonFitter.fitKappa(eigenSystem3D, this.samples);
        dArray[5] = dArray[2];
        dArray[6] = d;
        double d2 = Double.MAX_VALUE;
        double[] dArray2 = new double[7];
        boolean bl = false;
        double[] dArray3 = new double[2];
        Vector3D vector3D = eigenSystem3D.eigenvectors[0];
        Vector3D vector3D2 = eigenSystem3D.eigenvectors[1];
        Vector3D vector3D3 = eigenSystem3D.eigenvectors[2];
        for (int i = 0; i < n; ++i) {
            vector3D = Rotations.rotateVector(vector3D, vector3D3, 90.0 / (double)n * (double)i * Math.PI / 180.0);
            vector3D2 = Rotations.rotateVector(vector3D2, vector3D3, 90.0 / (double)n * (double)i * Math.PI / 180.0);
            dArray3 = TwoFibreWatsonFitter.getThetaPhi(vector3D);
            dArray[0] = dArray3[0];
            dArray[1] = dArray3[1];
            dArray3 = TwoFibreWatsonFitter.getThetaPhi(vector3D2);
            dArray[3] = dArray3[0];
            dArray[4] = dArray3[1];
            try {
                this.setInitParams(dArray);
                this.minimise();
                bl = true;
            }
            catch (MarquardtMinimiserException marquardtMinimiserException) {
                // empty catch block
            }
            if (!(this.fObjVal < d2)) continue;
            d2 = this.fObjVal;
            dArray2 = this.getParameters();
        }
        this.setInitParams(dArray2);
        if (!bl) {
            throw new MarquardtMinimiserException("None of the parameters could converge");
        }
    }

    @Override
    public double[] getParameters() {
        double[] dArray = new double[this.ma];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.a[i + 1];
        }
        dArray[6] = Math.pow(Math.sin(dArray[6]), 2.0);
        return dArray;
    }

    public void setFixedParams(boolean[] blArray) {
        this.ia = new boolean[blArray.length + 1];
        this.ia[0] = true;
        for (int i = 0; i < blArray.length; ++i) {
            this.ia[i + 1] = blArray[i];
        }
    }

    public void setMixingParameterVariable(boolean bl) {
        this.ia[7] = bl;
    }

    public void setMu1Variable(boolean bl) {
        this.ia[1] = bl;
        this.ia[2] = bl;
    }

    public void setMu2Variable(boolean bl) {
        this.ia[4] = bl;
        this.ia[5] = bl;
    }

    public void setKappa1Variable(boolean bl) {
        this.ia[3] = bl;
    }

    public void setKappa2Variable(boolean bl) {
        this.ia[6] = bl;
    }

    public TwoFibreWatsonFitter(Vector3D[] vector3DArray) {
        this.init(7);
        this.samples = vector3DArray;
    }

    private static double[] getThetaPhi(Vector3D vector3D) {
        double[] dArray = new double[2];
        dArray[0] = Math.acos(vector3D.z);
        dArray[1] = vector3D.x == 0.0 && vector3D.y == 0.0 ? 0.0 : (vector3D.y == 0.0 ? (vector3D.x > 0.0 ? 0.0 : Math.PI) : (vector3D.x == 0.0 ? (vector3D.y > 0.0 ? 1.5707963267948966 : 4.71238898038469) : (vector3D.x > 0.0 && vector3D.y > 0.0 ? Math.atan(vector3D.y / vector3D.x) : (vector3D.x < 0.0 && vector3D.y > 0.0 ? Math.PI + Math.atan(vector3D.y / vector3D.x) : (vector3D.x < 0.0 && vector3D.y < 0.0 ? Math.PI + Math.atan(vector3D.y / vector3D.x) : Math.PI * 2 + Math.atan(vector3D.y / vector3D.x))))));
        return dArray;
    }

    public static void main(String[] stringArray) {
        Object object;
        Vector3D[] vector3DArray;
        if (stringArray.length == 0) {
            System.out.println("TwoFibreWatsonFitter -sampleAxes [filename] -initMu1 [theta phi] -initMu2 [theta phi] -initK1 [value] -initK2 [value] -initAlpha [value]\n\nThe axes file should contain a list of unit vectors with x y z delimited by spaces and each vector on a separate line. Parameters default to zero if arguments are missing.");
            System.exit(0);
        }
        Vector3D[] vector3DArray2 = null;
        double[] dArray = new double[7];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].toLowerCase().equals("-sampleaxes")) {
                vector3DArray = new FileInput(stringArray[i + 1]);
                object = new ArrayList();
                while (!vector3DArray.eof()) {
                    String[] stringArray2 = vector3DArray.readString().split(" ");
                    double d = Double.parseDouble(stringArray2[0]);
                    double d2 = Double.parseDouble(stringArray2[1]);
                    double d3 = Double.parseDouble(stringArray2[2]);
                    ((ArrayList)object).add(new Vector3D(d, d2, d3));
                }
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-initmu1")) {
                dArray[0] = Double.parseDouble(stringArray[i + 1]);
                dArray[1] = Double.parseDouble(stringArray[i + 2]);
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-initk1")) {
                dArray[2] = Double.parseDouble(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-initmu2")) {
                dArray[3] = Double.parseDouble(stringArray[i + 1]);
                dArray[4] = Double.parseDouble(stringArray[i + 2]);
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-initk2")) {
                dArray[5] = Double.parseDouble(stringArray[i + 1]);
                continue;
            }
            if (!stringArray[i].toLowerCase().equals("-initalpha")) continue;
            dArray[6] = Double.parseDouble(stringArray[i + 1]);
        }
        TwoFibreWatsonFitter twoFibreWatsonFitter = new TwoFibreWatsonFitter(vector3DArray2);
        try {
            twoFibreWatsonFitter.setInitParams(dArray);
            twoFibreWatsonFitter.minimise();
        }
        catch (MarquardtMinimiserException marquardtMinimiserException) {
            logger.severe("Minimization failed with exception: ");
            LoggedException.logExceptionSevere(marquardtMinimiserException, Thread.currentThread().getName());
            System.exit(1);
        }
        System.out.println("Fitted parameters");
        vector3DArray = twoFibreWatsonFitter.getMus();
        object = twoFibreWatsonFitter.getKappas();
        double d = twoFibreWatsonFitter.getMixingParameter();
        System.out.println("mu1 " + vector3DArray[0]);
        System.out.println("kappa1 " + (double)object[0]);
        System.out.println("\nmu2 " + vector3DArray[1]);
        System.out.println("kappa2 " + (double)object[1]);
        System.out.println("alpha " + d);
    }
}

