/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import java.util.Random;
import misc.DT;
import misc.SphericalPoints;
import numerics.RealMatrix;
import numerics.Vector3D;

public class Rotations {
    public static final Vector3D X_AXIS = new Vector3D(1.0, 0.0, 0.0);
    public static final Vector3D Y_AXIS = new Vector3D(0.0, 1.0, 0.0);
    public static final Vector3D Z_AXIS = new Vector3D(0.0, 0.0, 1.0);

    public static RealMatrix getRotMat(double d, double d2, double d3) {
        double[] dArray = new double[]{Math.cos(d2) * Math.sin(d), Math.sin(d2) * Math.sin(d), Math.cos(d)};
        return Rotations.getRotMat(dArray, d3);
    }

    public static RealMatrix getRotMat(double[] dArray, double d) {
        RealMatrix realMatrix = new RealMatrix(3, 3);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        double d5 = dArray[0];
        double d6 = dArray[1];
        double d7 = dArray[2];
        realMatrix.entries[0][0] = d5 * d5 * (1.0 - d2) + d2;
        realMatrix.entries[1][0] = d6 * d5 * (1.0 - d2) + d7 * d3;
        realMatrix.entries[2][0] = d7 * d5 * (1.0 - d2) - d6 * d3;
        realMatrix.entries[0][1] = d5 * d6 * (1.0 - d2) - d7 * d3;
        realMatrix.entries[1][1] = d6 * d6 * (1.0 - d2) + d2;
        realMatrix.entries[2][1] = d7 * d6 * (1.0 - d2) + d5 * d3;
        realMatrix.entries[0][2] = d5 * d7 * (1.0 - d2) + d6 * d3;
        realMatrix.entries[1][2] = d6 * d7 * (1.0 - d2) - d5 * d3;
        realMatrix.entries[2][2] = d7 * d7 * (1.0 - d2) + d2;
        return realMatrix;
    }

    public static RealMatrix getRotMat(Vector3D vector3D, double d) {
        RealMatrix realMatrix = new RealMatrix(3, 3);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = Math.sqrt(vector3D.x * vector3D.x + vector3D.y * vector3D.y + vector3D.z * vector3D.z);
        double d5 = vector3D.x / d4;
        double d6 = vector3D.y / d4;
        double d7 = vector3D.z / d4;
        realMatrix.entries[0][0] = d5 * d5 * (1.0 - d2) + d2;
        realMatrix.entries[1][0] = d6 * d5 * (1.0 - d2) + d7 * d3;
        realMatrix.entries[2][0] = d7 * d5 * (1.0 - d2) - d6 * d3;
        realMatrix.entries[0][1] = d5 * d6 * (1.0 - d2) - d7 * d3;
        realMatrix.entries[1][1] = d6 * d6 * (1.0 - d2) + d2;
        realMatrix.entries[2][1] = d7 * d6 * (1.0 - d2) + d5 * d3;
        realMatrix.entries[0][2] = d5 * d7 * (1.0 - d2) + d6 * d3;
        realMatrix.entries[1][2] = d6 * d7 * (1.0 - d2) - d5 * d3;
        realMatrix.entries[2][2] = d7 * d7 * (1.0 - d2) + d2;
        return realMatrix;
    }

    public static RealMatrix randomRotMat() {
        Random random = new Random();
        return Rotations.randomRotMat(random);
    }

    public static RealMatrix randomRotMat(int n) {
        Random random = new Random(n);
        return Rotations.randomRotMat(random);
    }

    public static RealMatrix randomRotMat(Random random) {
        double[] dArray = SphericalPoints.getRandomPoint(random);
        double d = Math.PI * 2 * random.nextDouble();
        RealMatrix realMatrix = Rotations.getRotMat(dArray, d);
        return realMatrix;
    }

    public static double[] transformPoint(RealMatrix realMatrix, double[] dArray) {
        double[] dArray2 = new double[]{realMatrix.entries[0][0] * dArray[0] + realMatrix.entries[0][1] * dArray[1] + realMatrix.entries[0][2] * dArray[2], realMatrix.entries[1][0] * dArray[0] + realMatrix.entries[1][1] * dArray[1] + realMatrix.entries[1][2] * dArray[2], realMatrix.entries[2][0] * dArray[0] + realMatrix.entries[2][1] * dArray[1] + realMatrix.entries[2][2] * dArray[2]};
        return dArray2;
    }

    public static DT rotateTensor(DT dT, Vector3D vector3D) {
        double[][] dArray = dT.sortedEigenSystem();
        Vector3D vector3D2 = new Vector3D(dArray[1][0], dArray[2][0], dArray[3][0]);
        RealMatrix realMatrix = Rotations.getRotMat(vector3D2, vector3D);
        return dT.transform(realMatrix);
    }

    public static Vector3D rotateVector(Vector3D vector3D, Vector3D vector3D2, double d) {
        return Rotations.rotateVector(vector3D, Rotations.getRotMat(vector3D2, d));
    }

    public static Vector3D rotateVector(Vector3D vector3D, RealMatrix realMatrix) {
        double[] dArray = new double[]{realMatrix.entries[0][0] * vector3D.x + realMatrix.entries[0][1] * vector3D.y + realMatrix.entries[0][2] * vector3D.z, realMatrix.entries[1][0] * vector3D.x + realMatrix.entries[1][1] * vector3D.y + realMatrix.entries[1][2] * vector3D.z, realMatrix.entries[2][0] * vector3D.x + realMatrix.entries[2][1] * vector3D.y + realMatrix.entries[2][2] * vector3D.z};
        return new Vector3D(dArray[0], dArray[1], dArray[2]);
    }

    public static RealMatrix getRotMat(Vector3D vector3D, Vector3D vector3D2) {
        double d = vector3D2.x == 0.0 ? (vector3D2.y > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : (vector3D2.x < 0.0 ? Math.PI + Math.atan(vector3D2.y / vector3D2.x) : Math.atan(vector3D2.y / vector3D2.x));
        RealMatrix realMatrix = Rotations.getRotMat(Z_AXIS, -1.0 * d);
        vector3D2 = Rotations.rotateVector(vector3D2, realMatrix);
        double d2 = vector3D.x == 0.0 ? (vector3D.y > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : (vector3D.x < 0.0 ? Math.PI + Math.atan(vector3D.y / vector3D.x) : Math.atan(vector3D.y / vector3D.x));
        RealMatrix realMatrix2 = Rotations.getRotMat(Z_AXIS, -1.0 * d2);
        double d3 = Math.acos(Z_AXIS.dot(vector3D2));
        double d4 = Math.acos(Z_AXIS.dot(vector3D));
        RealMatrix realMatrix3 = Rotations.getRotMat(Y_AXIS, d3 - d4);
        RealMatrix realMatrix4 = realMatrix.inverse();
        return realMatrix4.product(realMatrix3).product(realMatrix2);
    }
}

