/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import data.VoxelOrderDataSource;
import java.util.ArrayList;
import misc.LoggedException;
import numerics.PolynomialFunction;

public class PolynomialFunction2D
extends PolynomialFunction {
    private final int order;
    private final double[] coeffs;

    public PolynomialFunction2D(int n, double[] dArray) {
        this.order = n;
        this.coeffs = new double[dArray.length];
        System.arraycopy(dArray, 0, this.coeffs, 0, dArray.length);
    }

    @Override
    public double evaluate(double[] dArray) {
        int n = 0;
        double d = 0.0;
        for (int i = 0; i <= this.order; ++i) {
            for (int j = 0; j <= this.order; ++j) {
                if (i + j > this.order) continue;
                d += Math.pow(dArray[0], i) * Math.pow(dArray[1], j) * this.coeffs[n];
                ++n;
            }
        }
        return d;
    }

    public static PolynomialFunction2D[] readFunctions(String string) {
        Object[] objectArray;
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string, 1, "double");
        int n = (int)voxelOrderDataSource.nextVoxel()[0];
        if (n != 2) {
            throw new LoggedException("Tried to create function with 2 variables, but number of variables in function is " + n);
        }
        int n2 = (int)voxelOrderDataSource.nextVoxel()[0];
        int n3 = (n2 + 1) * (n2 + 2) / 2;
        ArrayList<PolynomialFunction2D> arrayList = new ArrayList<PolynomialFunction2D>();
        while (voxelOrderDataSource.more()) {
            objectArray = new double[n3];
            for (int i = 0; i < n3; ++i) {
                objectArray[i] = voxelOrderDataSource.nextVoxel()[0];
            }
            arrayList.add(new PolynomialFunction2D(n2, (double[])objectArray));
        }
        objectArray = new PolynomialFunction2D[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    public String toString() {
        String string = "";
        int n = 0;
        for (int i = 0; i <= this.order; ++i) {
            for (int j = 0; j <= this.order; ++j) {
                if (i + j > this.order) continue;
                string = string + this.coeffs[n] + " * x^" + i + " * y^" + j + " + ";
                ++n;
            }
        }
        string = string.substring(0, string.length() - 3);
        return string;
    }

    @Override
    public int variables() {
        return 2;
    }
}

