/*
 * Decompiled with CFR 0.152.
 */
package numerics;

import data.VoxelOrderDataSource;
import java.util.ArrayList;
import misc.LoggedException;
import numerics.PolynomialFunction;

public class PolynomialFunction1D
extends PolynomialFunction {
    private final int order;
    private final double[] coeffs;

    public PolynomialFunction1D(int n, double[] dArray) {
        this.order = n;
        this.coeffs = new double[dArray.length];
        System.arraycopy(dArray, 0, this.coeffs, 0, dArray.length);
    }

    @Override
    public double evaluate(double[] dArray) {
        boolean bl = false;
        double d = 0.0;
        for (int i = 0; i <= this.order; ++i) {
            d += Math.pow(dArray[0], i) * this.coeffs[i];
        }
        return d;
    }

    public static PolynomialFunction1D[] readFunctions(String string) {
        Object[] objectArray;
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string, 1, "double");
        int n = (int)voxelOrderDataSource.nextVoxel()[0];
        if (n != 1) {
            throw new LoggedException("Tried to create function with 1 variable, but number of variables in function is " + n);
        }
        int n2 = (int)voxelOrderDataSource.nextVoxel()[0];
        int n3 = n2 + 1;
        ArrayList<PolynomialFunction1D> arrayList = new ArrayList<PolynomialFunction1D>();
        while (voxelOrderDataSource.more()) {
            objectArray = new double[n3];
            for (int i = 0; i < n3; ++i) {
                objectArray[i] = voxelOrderDataSource.nextVoxel()[0];
            }
            arrayList.add(new PolynomialFunction1D(n2, (double[])objectArray));
        }
        objectArray = new PolynomialFunction1D[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    public String toString() {
        String string = "";
        int n = 0;
        for (int i = 0; i <= this.order; ++i) {
            string = string + this.coeffs[n] + " * x^" + i + " + ";
        }
        string = string.substring(0, string.length() - 3);
        return string;
    }

    @Override
    public int variables() {
        return 1;
    }
}

