/*
 * Decompiled with CFR 0.152.
 */
package numerics;

public abstract class NumericalIntegration {
    private double TINY = 1.0E-14;
    private final boolean diagonalWeights;
    private int maxN = 10000;
    private int minN = 2;

    public NumericalIntegration(boolean bl) {
        this.diagonalWeights = bl;
    }

    public NumericalIntegration(boolean bl, int n, int n2) {
        this(bl);
        this.setMinN(n);
        this.setMaxN(n2);
    }

    public NumericalIntegration(boolean bl, int n, int n2, double d) {
        this(bl, n, n2);
        this.setThreshold(d);
    }

    public abstract double f(double var1, double var3);

    public double integrate() {
        double d = this.integrate(this.minN);
        double d2 = this.integrate(this.minN + 1);
        for (int i = this.minN + 2; i <= this.maxN; ++i) {
            if (Math.abs(d2 - d) <= this.TINY) {
                return d2;
            }
            d = d2;
            d2 = this.integrate(i + 1);
        }
        System.err.println("WARNING: integral conversion not reached in " + this.maxN + " terms with threshold " + this.TINY);
        return d2;
    }

    public double integrate(int n) {
        if (n < 2) {
            throw new RuntimeException("at least two points on the sphere needed for numerical integration");
        }
        if (this.diagonalWeights) {
            return this.diagIntegrate(n);
        }
        return this.nondiagIntegrate(n);
    }

    private double diagIntegrate(int n) {
        double[][] dArray = this.getSpiralPoints(n);
        double[] dArray2 = this.getDiagWeights(dArray, n);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray2[i] * this.f(dArray[i][0], dArray[i][1]);
        }
        return d;
    }

    private double[][] getSpiralPoints(int n) {
        int n2;
        double[][] dArray = new double[n][2];
        for (n2 = 1; n2 <= n; ++n2) {
            dArray[n2 - 1][0] = -1.0 + 2.0 * (double)(n2 - 1) / (double)(n - 1);
        }
        dArray[0][1] = 0.0;
        for (n2 = 1; n2 < n - 1; ++n2) {
            dArray[n2][1] = dArray[n2 - 1][1] + 3.6 / Math.sqrt(n) / Math.sqrt(1.0 - dArray[n2][0] * dArray[n2][0]);
        }
        dArray[n - 1][1] = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2][1] = Math.cos(dArray[n2][1]);
        }
        return dArray;
    }

    private double[] getDiagWeights(double[][] dArray, int n) {
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.getCubatureWeight(dArray[i], n);
        }
        return dArray2;
    }

    private double getCubatureWeight(double[] dArray, int n) {
        return Math.PI * 4 / (double)n;
    }

    private double nondiagIntegrate(int n) {
        return Math.PI * 4;
    }

    public int getMaxN() {
        return this.maxN;
    }

    public void setMaxN(int n) {
        if (n < this.minN + 2) {
            throw new RuntimeException("integration maximum must be at least 2 greater than minimum. min=" + this.minN + " attempt to set max to " + n);
        }
        this.maxN = n;
    }

    public double getThreshold() {
        return this.TINY;
    }

    public void setThreshold(double d) {
        this.TINY = d;
    }

    public int getMinN() {
        return this.minN;
    }

    public void setMinN(int n) {
        if (this.maxN < n + 2) {
            throw new RuntimeException("integration maximum must be at least 2 greater than minimum. max=" + this.maxN + ". attempt to set min to " + n);
        }
        this.minN = n;
    }
}

