/*
 * Decompiled with CFR 0.152.
 */
package numerics;

public abstract class NumDeriv {
    private static float CON = 1.4f;
    private static float CON2 = CON * CON;
    private static float BIG = 1.0E30f;
    private static int NTAB = 10;
    private static float SAFE = 2.0f;

    protected abstract float func(float var1);

    public float dfridr(float f, float f2, float[] fArray) {
        int n = 0;
        int n2 = 0;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (f2 == 0.0f) {
            throw new RuntimeException("h must be nonzero in dfridr.");
        }
        float[][] fArray2 = new float[NTAB + 1][NTAB + 1];
        f5 = f2;
        fArray2[1][1] = (this.func(f + f5) - this.func(f - f5)) / (2.0f * f5);
        fArray[0] = BIG;
        for (n = 2; n <= NTAB; ++n) {
            fArray2[1][n] = (this.func(f + (f5 /= CON)) - this.func(f - f5)) / (2.0f * f5);
            f4 = CON2;
            for (n2 = 2; n2 <= n; ++n2) {
                fArray2[n2][n] = (fArray2[n2 - 1][n] * f4 - fArray2[n2 - 1][n - 1]) / (f4 - 1.0f);
                f4 = CON2 * f4;
                f3 = Math.max(Math.abs(fArray2[n2][n] - fArray2[n2 - 1][n]), Math.abs(fArray2[n2][n] - fArray2[n2 - 1][n - 1]));
                if (!(f3 <= fArray[0])) continue;
                fArray[0] = f3;
                f6 = fArray2[n2][n];
            }
            if (Math.abs(fArray2[n][n] - fArray2[n - 1][n - 1]) >= SAFE * fArray[0]) break;
        }
        return f6;
    }
}

