/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.Random;
import misc.LoggedException;
import misc.OrderedAcqMinimizer;

public class OrderedAcqWeightedMinimizer
extends OrderedAcqMinimizer {
    private double[][] bestEverPoints;
    private double[] weights;
    private final double weightPower = 2.0;
    private double[] partialEnergy = null;
    private double[] candidatePartialEnergy = null;
    private int i = 0;
    private int j = 0;
    private double currentStateEnergy = 0.0;
    private double candidateStateEnergy = 0.0;
    private double bestEverStateEnergy = 0.0;

    public OrderedAcqWeightedMinimizer(int n, double d, int n2, String string, Random random) {
        super(n, d, n2, string, random);
        this.setWeights();
        this.partialEnergy = new double[this.noPairs];
        this.stateEnergy();
        this.saveStateAsLowestEnergy();
    }

    public OrderedAcqWeightedMinimizer(double[][] dArray, double d, int n, String string, Random random) {
        super(dArray, d, n, string, random);
        this.setWeights();
        this.partialEnergy = new double[this.noPairs];
        this.stateEnergy();
        this.saveStateAsLowestEnergy();
    }

    private void setWeights() {
        this.weights = new double[this.noPairs];
        for (int i = 1; i < this.noPairs; ++i) {
            this.weights[i] = 1.0 / Math.pow(i + 1, 2.0);
        }
    }

    @Override
    protected double stateEnergy() {
        for (int i = 0; i < this.noPairs; ++i) {
            this.partialEnergy[i] = 0.0;
            for (int j = 0; j < i; ++j) {
                int n = i;
                this.partialEnergy[n] = this.partialEnergy[n] + this.energy[i][j];
            }
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.noPairs; ++i) {
            d += this.partialEnergy[i];
            if (i <= 4) continue;
            d2 += d * this.weights[i];
        }
        this.currentStateEnergy = d2;
        return d2;
    }

    private double swappedStateEnergy() {
        this.candidatePartialEnergy = new double[this.noPairs];
        System.arraycopy(this.partialEnergy, 0, this.candidatePartialEnergy, 0, this.noPairs);
        for (int i = this.i + 1; i < this.j; ++i) {
            this.candidatePartialEnergy[i] = this.partialEnergy[i] + this.energy[i][this.j] - this.energy[i][this.i];
            int n = this.i;
            this.candidatePartialEnergy[n] = this.candidatePartialEnergy[n] + this.energy[i][this.i];
            int n2 = this.j;
            this.candidatePartialEnergy[n2] = this.candidatePartialEnergy[n2] - this.energy[i][this.j];
        }
        int n = this.i;
        this.candidatePartialEnergy[n] = this.candidatePartialEnergy[n] + this.energy[this.i][this.j];
        int n3 = this.j;
        this.candidatePartialEnergy[n3] = this.candidatePartialEnergy[n3] - this.energy[this.j][this.i];
        double d = this.candidatePartialEnergy[this.i];
        this.candidatePartialEnergy[this.i] = this.candidatePartialEnergy[this.j];
        this.candidatePartialEnergy[this.j] = d;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.noPairs; ++i) {
            d3 += this.candidatePartialEnergy[i];
            if (i <= 4) continue;
            d2 += d3 * this.weights[i];
        }
        this.candidateStateEnergy = d2;
        return d2;
    }

    private void calculateCandidateSwapPositions() {
        this.i = (int)(this.ran.nextFloat() * (float)this.noPairs);
        this.j = (int)(this.ran.nextFloat() * (float)this.noPairs);
        while (this.i < 5 && this.j < 5 || this.i == this.j) {
            this.j = (int)(this.ran.nextFloat() * (float)this.noPairs);
        }
        if (this.i > this.j) {
            int n = this.j;
            this.j = this.i;
            this.i = n;
        }
    }

    @Override
    protected double generateCandidateState() {
        this.calculateCandidateSwapPositions();
        return this.swappedStateEnergy();
    }

    @Override
    protected void acceptCandidateState() {
        this.partialEnergy = this.candidatePartialEnergy;
        if (this.candidateStateEnergy == 0.0) {
            throw new LoggedException("Attempting to set an invalid state.");
        }
        this.currentStateEnergy = this.candidateStateEnergy;
        this.candidatePartialEnergy = null;
        this.candidateStateEnergy = 0.0;
        this.swapPoints(this.i, this.j);
    }

    @Override
    protected void saveStateAsLowestEnergy() {
        this.bestEverPoints = this.getPoints();
        this.bestEverStateEnergy = this.currentStateEnergy;
    }

    @Override
    protected void setStateToLowestEnergy() {
        this.points = this.bestEverPoints;
        this.bestEverPoints = this.getPoints();
        this.buildEnergyMatrix();
        this.stateEnergy();
    }

    @Override
    public String state() {
        return this.state(this.points, this.temperature, this.currentStateEnergy);
    }

    @Override
    public String lowestEnergyState() {
        return this.state(this.bestEverPoints, this.temperature, this.bestEverStateEnergy);
    }

    private String state(double[][] dArray, double d, double d2) {
        String string = this.noPairs + " " + d + " " + d2 + "\n";
        for (int i = 0; i < this.noPairs; ++i) {
            string = string + dArray[i][0] + " " + dArray[i][1] + " " + dArray[i][2] + "\n";
        }
        return string;
    }
}

