/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggedException
extends RuntimeException {
    private static Logger logger = Logger.getLogger("camino.misc.LoggedException");
    private static boolean exceptionLogging = true;

    public static void setExceptionLogging(boolean bl) {
        exceptionLogging = bl;
    }

    public LoggedException() {
        if (exceptionLogging) {
            LoggedException.logExceptionSevere(this, Thread.currentThread().getName());
        }
    }

    public LoggedException(Throwable throwable) {
        super(throwable);
        if (exceptionLogging) {
            LoggedException.logExceptionSevere(this, Thread.currentThread().getName());
        }
    }

    public LoggedException(String string, Throwable throwable) {
        super(string, throwable);
        if (exceptionLogging) {
            LoggedException.logExceptionSevere(this, Thread.currentThread().getName());
        }
    }

    public LoggedException(String string) {
        super(string);
        if (exceptionLogging) {
            LoggedException.logExceptionSevere(this, Thread.currentThread().getName());
        }
    }

    public static void logExceptionSevere(Exception exception, String string, String string2) {
        LoggedException.logException(exception, string2, Level.SEVERE);
        logger.log(Level.SEVERE, string);
    }

    public static void logExceptionWarning(Exception exception, String string, String string2) {
        LoggedException.logException(exception, string2, Level.WARNING);
        logger.log(Level.WARNING, string);
    }

    public static void logExceptionSevere(Exception exception, String string) {
        LoggedException.logException(exception, string, Level.SEVERE);
    }

    public static void logExceptionWarning(Exception exception, String string) {
        LoggedException.logException(exception, string, Level.WARNING);
    }

    public static void logException(Exception exception, String string, Level level) {
        String string2 = "Exception in thread \"" + string + "\" " + exception.getClass() + ": " + exception.getMessage() + "\n";
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string2 = string2 + "\tat " + stackTraceElementArray[i] + "\n";
        }
        logger.log(level, string2);
    }
}

