/*
 * Decompiled with CFR 0.152.
 */
package misc;

import misc.LoggedException;
import misc.VoxelwiseStatisticalImage;
import numerics.Point3D;

public class DynamicScalarImage
implements VoxelwiseStatisticalImage {
    private double[][][] sum;
    private double[][][] min;
    private double[][][] max;
    private double[][][] norm;
    private boolean[][][] touchedVoxel;
    private final int[] dataDims;
    private final double[] voxelDims;

    public DynamicScalarImage(int[] nArray, double[] dArray) {
        this.dataDims = nArray;
        this.voxelDims = dArray;
        this.sum = new double[nArray[0]][nArray[1]][nArray[2]];
        this.min = new double[nArray[0]][nArray[1]][nArray[2]];
        this.max = new double[nArray[0]][nArray[1]][nArray[2]];
        this.norm = new double[nArray[0]][nArray[1]][nArray[2]];
        this.touchedVoxel = new boolean[nArray[0]][nArray[1]][nArray[2]];
    }

    @Override
    public void addValue(int n, int n2, int n3, double d) {
        this.addValue(n, n2, n3, d, 1.0);
    }

    @Override
    public void addValue(int n, int n2, int n3, double d, double d2) {
        if (d2 < 0.0) {
            throw new LoggedException("Weights must be non-negative");
        }
        if (!this.touchedVoxel[n][n2][n3]) {
            this.touchedVoxel[n][n2][n3] = true;
            this.min[n][n2][n3] = d;
            this.max[n][n2][n3] = d;
        }
        double[] dArray = this.sum[n][n2];
        int n4 = n3;
        dArray[n4] = dArray[n4] + d * d2;
        double[] dArray2 = this.norm[n][n2];
        int n5 = n3;
        dArray2[n5] = dArray2[n5] + d2;
        if (d < this.min[n][n2][n3]) {
            this.min[n][n2][n3] = d;
        }
        if (d > this.max[n][n2][n3]) {
            this.max[n][n2][n3] = d;
        }
    }

    @Override
    public void addValue(Point3D point3D, double d) {
        this.addValue(point3D, d, 1.0);
    }

    @Override
    public void addValue(Point3D point3D, double d, double d2) {
        if (d2 < 0.0) {
            throw new LoggedException("Weights must be non-negative");
        }
        int n = (int)(point3D.x / this.voxelDims[0]);
        int n2 = (int)(point3D.y / this.voxelDims[1]);
        int n3 = (int)(point3D.z / this.voxelDims[2]);
        this.addValue(n, n2, n3, d, d2);
    }

    @Override
    public double[][][] getVoxelStatistic(String string) {
        double[][][] dArray = new double[this.dataDims[0]][this.dataDims[1]][this.dataDims[2]];
        for (int i = 0; i < this.dataDims[0]; ++i) {
            for (int j = 0; j < this.dataDims[1]; ++j) {
                for (int k = 0; k < this.dataDims[2]; ++k) {
                    if (string.equals("mean")) {
                        dArray[i][j][k] = this.norm[i][j][k] > 0.0 ? this.sum[i][j][k] / this.norm[i][j][k] : 0.0;
                        continue;
                    }
                    if (string.equals("max")) {
                        dArray[i][j][k] = this.touchedVoxel[i][j][k] ? this.max[i][j][k] : 0.0;
                        continue;
                    }
                    if (string.equals("min")) {
                        dArray[i][j][k] = this.touchedVoxel[i][j][k] ? this.min[i][j][k] : 0.0;
                        continue;
                    }
                    throw new LoggedException("Unsupported statistic : " + string);
                }
            }
        }
        return dArray;
    }

    public int[] getDataDims() {
        return new int[]{this.dataDims[0], this.dataDims[1], this.dataDims[2]};
    }

    public double[] getVoxelDims() {
        return new double[]{this.voxelDims[0], this.voxelDims[1], this.voxelDims[2]};
    }
}

