/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import imaging.Scheme;
import inverters.DT_Inversion;
import inverters.DiffusionInversion;
import inverters.ModelIndex;
import inverters.ThreeTensorFitter;
import misc.DT;

public class ThreeTensorInversion
extends DiffusionInversion {
    protected DT_Inversion dtInverter;
    protected ThreeTensorFitter fitter;
    public static final int ITEMSPERVOX = 24;

    public ThreeTensorInversion(Scheme scheme) {
        this.init(scheme, ModelIndex.DTDTDT, ModelIndex.LDT);
    }

    public ThreeTensorInversion(Scheme scheme, ModelIndex modelIndex, ModelIndex modelIndex2) {
        this.init(scheme, modelIndex, modelIndex2);
    }

    protected void init(Scheme scheme, ModelIndex modelIndex, ModelIndex modelIndex2) {
        this.ip = scheme;
        this.dtInverter = DT_Inversion.getIndexedDT_Inversion(modelIndex2, scheme);
        int n = this.ip.numZeroMeasurements();
        double[] dArray = this.ip.getDiffusionTimes();
        double[][] dArray2 = new double[this.ip.numMeasurements() - n - this.ip.numZeroMeasurements()][3];
        for (int i = 0; i < dArray2.length; ++i) {
            double[] dArray3 = this.ip.getQ(i + n);
            dArray2[i][0] = dArray3[0];
            dArray2[i][1] = dArray3[1];
            dArray2[i][2] = dArray3[2];
        }
        double[] dArray4 = new double[this.ip.numMeasurements() - n - this.ip.numZeroMeasurements()];
        try {
            this.fitter = ThreeTensorFitter.getIndexedThreeTensorFitter(dArray2, dArray4, dArray, n, modelIndex);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public double[] invert(double[] dArray) {
        double[] dArray2 = this.ip.normalizeData(dArray);
        double[] dArray3 = this.dtInverter.invert(dArray);
        double d = dArray3[0];
        double d2 = dArray3[1];
        double[] dArray4 = new double[6];
        for (int i = 0; i < 6; ++i) {
            dArray4[i] = dArray3[i + 2];
        }
        DT dT = new DT(dArray4);
        try {
            this.fitter.newDepVals(dArray2);
            this.fitter.setStartFromSingleDT(dT);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        double[] dArray5 = dT.getComponents();
        double[] dArray6 = dT.getComponents();
        double[] dArray7 = dT.getComponents();
        double d3 = 0.3333333333333333;
        double d4 = 0.3333333333333333;
        try {
            this.fitter.minimise();
            dArray5 = this.fitter.getDT1().getComponents();
            dArray6 = this.fitter.getDT2().getComponents();
            dArray7 = this.fitter.getDT3().getComponents();
            d3 = this.fitter.getMix1();
            d4 = this.fitter.getMix2();
        }
        catch (Exception exception) {
            logger.info(exception.toString() + "Fitting failed.  Outputting single DT.");
            d = 2.0;
        }
        double[] dArray8 = new double[24];
        dArray8[0] = d;
        dArray8[1] = d2;
        dArray8[2] = 3.0;
        dArray8[3] = d3;
        dArray8[10] = d4;
        dArray8[17] = 1.0 - d3 - d4;
        for (int i = 0; i < 6; ++i) {
            dArray8[i + 4] = dArray5[i];
            dArray8[i + 11] = dArray6[i];
            dArray8[i + 18] = dArray7[i];
        }
        return dArray8;
    }

    @Override
    public int itemsPerVoxel() {
        return 24;
    }
}

