/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import inverters.DiffDataFitter;
import misc.DT;

public abstract class TensorModelFitter
extends DiffDataFitter {
    protected DT getDT_AxiSym(double[] dArray, int n) {
        double[] dArray2 = new double[4];
        for (int i = 0; i < 3; ++i) {
            dArray2[i] = dArray[i + n];
        }
        dArray2[3] = dArray[n + 3] * dArray[n + 3];
        return TensorModelFitter.fAndBetaToDT(dArray2);
    }

    protected static double[] getAxiSymParams(DT dT) {
        double[][] dArray = dT.sortedEigenSystem();
        double d = Math.abs(dArray[0][2]);
        double d2 = dArray[0][0] - dArray[0][2];
        double[] dArray2 = new double[4];
        double d3 = Math.sqrt(d2);
        dArray2[0] = d3 * dArray[1][0];
        dArray2[1] = d3 * dArray[2][0];
        dArray2[2] = d3 * dArray[3][0];
        dArray2[3] = Math.sqrt(d);
        return dArray2;
    }

    protected static DT getDT_Chol(double[] dArray, int n) {
        return new DT(dArray[n] * dArray[n], dArray[n] * dArray[n + 1], dArray[n] * dArray[n + 2], dArray[n + 1] * dArray[n + 1] + dArray[n + 3] * dArray[n + 3], dArray[n + 1] * dArray[n + 2] + dArray[n + 3] * dArray[n + 4], dArray[n + 2] * dArray[n + 2] + dArray[n + 4] * dArray[n + 4] + dArray[n + 5] * dArray[n + 5]);
    }

    protected static double[] getCholParams(DT dT) {
        double[] dArray = dT.getComponents();
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray[4];
        double d6 = dArray[5];
        double[] dArray2 = new double[6];
        dArray2[0] = d > 0.0 ? Math.sqrt(d) : 0.0;
        dArray2[1] = dArray2[0] > 0.0 ? d2 / dArray2[0] : 0.0;
        dArray2[2] = dArray2[0] > 0.0 ? d3 / dArray2[0] : 0.0;
        double d7 = d4 - dArray2[1] * dArray2[1];
        dArray2[3] = d7 > 0.0 ? Math.sqrt(d7) : 0.0;
        dArray2[4] = dArray2[3] > 0.0 ? (d5 - dArray2[1] * dArray2[2]) / dArray2[3] : 0.0;
        double d8 = d6 - dArray2[2] * dArray2[2] - dArray2[4] * dArray2[4];
        dArray2[5] = d8 > 0.0 ? Math.sqrt(d8) : 0.0;
        return dArray2;
    }

    protected static DT getDT_PosDiag(double[] dArray, int n) {
        return new DT(dArray[n] * dArray[n], dArray[n + 1], dArray[n + 2], dArray[n + 3] * dArray[n + 3], dArray[n + 4], dArray[n + 5] * dArray[n + 5]);
    }

    protected static double[] getPosDiagParams(DT dT) {
        double[] dArray = dT.getComponents();
        dArray[0] = Math.sqrt(dArray[0]);
        dArray[3] = Math.sqrt(dArray[3]);
        dArray[5] = Math.sqrt(dArray[5]);
        return dArray;
    }

    protected static void insertCholDerivs(double[] dArray, double d, int n, double[] dArray2, double d2, double d3, double d4, double d5, double d6) {
        dArray[n] = -2.0 * dArray2[0] * d2 * d5 * d * d6;
        dArray[n + 1] = -2.0 * dArray2[1] * d2 * d5 * d * d6;
        dArray[n + 2] = -2.0 * dArray2[2] * d2 * d5 * d * d6;
        dArray[n + 3] = -2.0 * dArray2[1] * d3 * d5 * d * d6;
        dArray[n + 4] = -2.0 * dArray2[2] * d3 * d5 * d * d6;
        dArray[n + 5] = -2.0 * dArray2[2] * d4 * d5 * d * d6;
    }

    protected static void insertPosDiagDerivs(double[] dArray, double d, int n, double[] dArray2, double d2, double d3, double d4, double d5, double d6) {
        dArray[n] = -2.0 * d2 * d5 * d * dArray2[0] * d6;
        dArray[n + 1] = -d5 * d * dArray2[1] * d6;
        dArray[n + 2] = -d5 * d * dArray2[2] * d6;
        dArray[n + 3] = -2.0 * d3 * d5 * d * dArray2[3] * d6;
        dArray[n + 4] = -d5 * d * dArray2[4] * d6;
        dArray[n + 5] = -2.0 * d4 * d5 * d * dArray2[5] * d6;
    }

    protected void insertAxiSymDerivs(double[] dArray, double d, int n, double[] dArray2, double d2, double d3, double d4, double d5) {
        dArray[n] = -2.0 * d * d4 * dArray2[0] * d3 * d5;
        dArray[n + 1] = -2.0 * d * d4 * dArray2[1] * d3 * d5;
        dArray[n + 2] = -2.0 * d * d4 * dArray2[2] * d3 * d5;
        dArray[n + 3] = -2.0 * d * d4 * d2 * d5;
    }

    public static double[] fsAndBetasFromSingleDT(DT dT) {
        double[][] dArray = dT.sortedEigenSystem();
        double d = Math.abs(dArray[0][2]);
        double d2 = Math.abs(dArray[0][2]);
        double d3 = 2.0 * (dArray[0][0] - dArray[0][2]);
        double d4 = 2.0 * (dArray[0][1] - dArray[0][2]);
        double[] dArray2 = new double[8];
        double d5 = Math.sqrt(d3);
        dArray2[0] = d5 * dArray[1][0];
        dArray2[1] = d5 * dArray[2][0];
        dArray2[2] = d5 * dArray[3][0];
        dArray2[6] = d;
        double d6 = Math.sqrt(d4);
        dArray2[3] = d6 * dArray[1][1];
        dArray2[4] = d6 * dArray[2][1];
        dArray2[5] = d6 * dArray[3][1];
        dArray2[7] = d2;
        return dArray2;
    }

    public static double[] fsAndBetasThreeFromSingleDT(DT dT) {
        double[][] dArray = dT.sortedEigenSystem();
        double d = 7.0;
        double d2 = Math.abs(dArray[0][0]);
        double d3 = Math.abs(dArray[0][1]);
        double d4 = Math.abs(dArray[0][2]);
        double d5 = 3.0 / (d * (d + 3.0));
        double d6 = d5 * (d2 * (d + 2.0) - d3 - d4);
        double d7 = d5 * (d3 * (d + 2.0) - d2 - d4);
        double d8 = d5 * (d4 * (d + 2.0) - d2 - d3);
        double d9 = d * d6;
        double d10 = d * d7;
        double d11 = d * d8;
        double[] dArray2 = new double[12];
        double d12 = Math.sqrt(d9);
        dArray2[0] = d12 * dArray[1][0];
        dArray2[1] = d12 * dArray[2][0];
        dArray2[2] = d12 * dArray[3][0];
        dArray2[9] = d6;
        double d13 = Math.sqrt(d10);
        dArray2[3] = d13 * dArray[1][1];
        dArray2[4] = d13 * dArray[2][1];
        dArray2[5] = d13 * dArray[3][1];
        dArray2[10] = d7;
        double d14 = Math.sqrt(d11);
        dArray2[6] = d14 * dArray[1][2];
        dArray2[7] = d14 * dArray[2][2];
        dArray2[8] = d14 * dArray[3][2];
        dArray2[11] = d8;
        return dArray2;
    }

    public static DT fAndBetaToDT(double[] dArray) {
        return new DT(dArray[0] * dArray[0] + dArray[3], dArray[0] * dArray[1], dArray[0] * dArray[2], dArray[1] * dArray[1] + dArray[3], dArray[1] * dArray[2], dArray[2] * dArray[2] + dArray[3]);
    }

    public static double invX2P1(double d) {
        return 1.0 / (d * d + 1.0);
    }
}

