/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import data.VoxelOrderDataSource;
import imaging.Scheme;
import inverters.DiffusionInversion;
import java.util.Vector;
import numerics.RealMatrix;

public class LinearInversion
extends DiffusionInversion {
    protected RealMatrix linearInv;
    protected boolean normalize;
    protected boolean useLog;

    public LinearInversion(Scheme scheme, String string, boolean bl, boolean bl2) {
        this.ip = scheme;
        this.normalize = bl;
        this.useLog = bl2;
        int n = this.ip.numMeasurements();
        if (this.normalize) {
            n -= this.ip.numZeroMeasurements();
        }
        VoxelOrderDataSource voxelOrderDataSource = new VoxelOrderDataSource(string, n, "double");
        Vector<double[]> vector = new Vector<double[]>();
        while (voxelOrderDataSource.more()) {
            try {
                vector.addElement(voxelOrderDataSource.nextVoxel());
            }
            catch (Exception exception) {
                System.err.println("Could not read the matrix.  Expecting " + n + " elements per row.");
                throw new RuntimeException(exception);
            }
        }
        int n2 = vector.size();
        this.linearInv = new RealMatrix(n2, n);
        for (int i = 0; i < n2; ++i) {
            double[] dArray = (double[])vector.elementAt(i);
            for (int j = 0; j < n; ++j) {
                this.linearInv.entries[i][j] = dArray[j];
            }
        }
    }

    @Override
    public double[] invert(double[] dArray) {
        double d = 0.0;
        double[] dArray2 = dArray;
        if (this.normalize) {
            dArray2 = this.ip.normalizeData(dArray);
        }
        RealMatrix realMatrix = new RealMatrix(dArray2.length, 1);
        for (int i = 0; i < dArray2.length; ++i) {
            if (this.useLog) {
                if (dArray[i] > 0.0) {
                    realMatrix.setEntry(i, 0, Math.log(dArray2[i]));
                    continue;
                }
                realMatrix.setEntry(i, 0, 0.0);
                d = 6.0;
                continue;
            }
            realMatrix.setEntry(i, 0, dArray2[i]);
        }
        RealMatrix realMatrix2 = this.linearInv.product(realMatrix);
        int n = this.normalize ? 2 : 1;
        double[] dArray3 = new double[this.linearInv.rows() + n];
        dArray3[0] = d;
        if (this.normalize) {
            double d2 = this.ip.geoMeanZeroMeas(dArray);
            dArray3[1] = d2 > 0.0 ? Math.log(d2) : 0.0;
        }
        for (int i = 0; i < this.linearInv.rows(); ++i) {
            dArray3[i + n] = realMatrix2.entry(i, 0);
        }
        return dArray3;
    }

    @Override
    public int itemsPerVoxel() {
        int n = this.linearInv.rows() + (this.normalize ? 2 : 1);
        return n;
    }

    public RealMatrix getMatrix() {
        return this.linearInv;
    }
}

