/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import misc.LoggedException;

public enum InversionIndex {
    LDT("ldt", 1, 1),
    LDT_ALIAS("dt", 1, 1),
    ALGDT("algdt", 0, 1),
    NLDT_POS("nldt_pos", 2, 1),
    NLDT("nldt", 4, 1),
    LDT_WTD("ldt_wtd", 7, 1),
    ADC("adc", -1, 0),
    RESTORE("restore", -2, 1),
    BALL_STICK("ball_stick", -3, 0),
    CYLCYL("cylcyl", 10, 2),
    CYLCYL_EQ("cylcyl_eq", 20, 2),
    POSPOS("pospos", 30, 2),
    POSPOS_EQ("pospos_eq", 40, 2),
    POSCYL("poscyl", 50, 2),
    POSCYL_EQ("poscyl_eq", 60, 2),
    DTDT("dtdt", 70, 2),
    CYLCYLCYL("cylcylcyl", 210, 3),
    CYLCYLCYL_EQ("cylcylcyl_eq", 220, 3),
    POSPOSPOS("pospospos", 230, 3),
    POSPOSPOS_EQ("pospospos_eq", 240, 3),
    POSPOSCYL("posposcyl", 250, 3),
    POSPOSCYL_EQ("posposcyl_eq", 260, 3),
    POSCYLCYL("poscylcyl", 270, 3),
    POSCYLCYL_EQ("poscylcyl_eq", 280, 3),
    DTDTDT("dtdtdt", 290, 2),
    MFR("mfr", 1000, 0);

    public final String name;
    public final int numIndex;
    public final int numDTs;

    private InversionIndex(String string2, int n2, int n3) {
        this.name = string2;
        this.numIndex = n2;
        this.numDTs = n3;
    }

    public String toString() {
        return this.name;
    }

    public static InversionIndex[] getIndices(String[] stringArray) {
        InversionIndex[] inversionIndexArray = null;
        if (stringArray.length == 1) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                inversionIndexArray = n > 10 ? new InversionIndex[]{InversionIndex.getIndex(n - n % 10), InversionIndex.getIndex(n % 10)} : new InversionIndex[]{InversionIndex.getIndex(n)};
                return inversionIndexArray;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        inversionIndexArray = new InversionIndex[stringArray.length];
        block4: for (int i = 0; i < inversionIndexArray.length; ++i) {
            for (InversionIndex inversionIndex : InversionIndex.values()) {
                if (!stringArray[i].equals(inversionIndex.name)) continue;
                inversionIndexArray[i] = inversionIndex;
                continue block4;
            }
            try {
                inversionIndexArray[i] = InversionIndex.getIndex(Integer.parseInt(stringArray[i]));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LoggedException("Unknown inversion code " + stringArray[i]);
            }
        }
        return inversionIndexArray;
    }

    public static InversionIndex getIndex(int n) {
        Object var1_1 = null;
        int n2 = n;
        if (n2 > 10 && n2 % 10 != 0) {
            n2 -= n2 % 10;
        }
        for (InversionIndex inversionIndex : InversionIndex.values()) {
            if (inversionIndex.numIndex != n2) continue;
            return inversionIndex;
        }
        throw new LoggedException("Unrecognized tensor inversion code " + n);
    }
}

