/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import imaging.Scheme;
import misc.SphericalPoints;
import numerics.Complex;
import numerics.IncompleteBeta;
import numerics.RealMatrix;
import numerics.SphericalHarmonics;

public class EvenSphHarmFitter {
    private RealMatrix invX;
    private RealMatrix X;
    private int maxOrder;
    private int numParams;
    private Scheme ip;
    private double FDT1 = 1.0E-20;
    private double FDT2 = 1.0E-7;
    private double FDT3 = 1.0E-7;
    protected static final double SVTHRESH = 1.0E12;

    public EvenSphHarmFitter(Scheme scheme, int n) {
        int n2;
        this.maxOrder = n;
        this.ip = scheme;
        this.numParams = (this.maxOrder + 1) * (this.maxOrder / 2 + 1);
        this.X = new RealMatrix(this.ip.numMeasurements(), this.numParams + 1);
        for (int i = 0; i < this.X.rows(); ++i) {
            double[] dArray = this.ip.getQ(i);
            double[] dArray2 = SphericalPoints.getSphPolars(dArray);
            double d = dArray2[0];
            double d2 = dArray2[1];
            double d3 = dArray2[2];
            double d4 = this.ip.getDiffusionTime(i) * d * d;
            this.X.setEntry(i, 0, 1.0);
            int n3 = 1;
            for (int j = 0; j <= this.maxOrder; j += 2) {
                try {
                    Complex complex = SphericalHarmonics.Y(j, 0, d2, d3);
                    this.X.setEntry(i, n3, -d4 * complex.real());
                    ++n3;
                    for (int k = 1; k <= j; ++k) {
                        complex = SphericalHarmonics.Y(j, k, d2, d3);
                        this.X.setEntry(i, n3, -2.0 * d4 * complex.real());
                        this.X.setEntry(i, n3 + 1, 2.0 * d4 * complex.imag());
                        n3 += 2;
                    }
                    continue;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        RealMatrix[] realMatrixArray = null;
        try {
            realMatrixArray = this.X.svd();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        double d = realMatrixArray[1].entry(0, 0);
        for (n2 = 0; n2 < realMatrixArray[1].rows() && n2 < realMatrixArray[1].columns(); ++n2) {
            if (!(realMatrixArray[1].entry(n2, n2) > d)) continue;
            d = realMatrixArray[1].entry(n2, n2);
        }
        for (n2 = 0; n2 < realMatrixArray[1].rows() && n2 < realMatrixArray[1].columns(); ++n2) {
            double d5 = realMatrixArray[1].entry(n2, n2);
            realMatrixArray[1].setEntry(n2, n2, d5 > d / 1.0E12 ? 1.0 / d5 : 0.0);
        }
        this.invX = realMatrixArray[2].product(realMatrixArray[1].transpose()).product(realMatrixArray[0].transpose());
    }

    public double[] fit(double[] dArray) {
        double d = 0.0;
        RealMatrix realMatrix = new RealMatrix(dArray.length, 1);
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] > 0.0) {
                realMatrix.setEntry(i, 0, Math.log(dArray[i]));
                continue;
            }
            realMatrix.setEntry(i, 0, 0.0);
            d = 6.0;
        }
        RealMatrix realMatrix2 = this.invX.product(realMatrix);
        double[] dArray2 = new double[this.numParams + 2];
        dArray2[0] = d;
        for (int i = 0; i < this.numParams + 1; ++i) {
            dArray2[i + 1] = realMatrix2.entry(i, 0);
        }
        return dArray2;
    }

    public int itemsPerVoxel() {
        return this.numParams + 2;
    }

    public void setF_TestThresholds(double d, double d2, double d3) {
        this.FDT1 = d;
        this.FDT2 = d2;
        this.FDT3 = d3;
    }

    public int getMaxOrder() {
        return this.maxOrder;
    }

    public int truncate(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.getF_TestProbabilities(dArray, dArray2);
        return this.selectModel(dArray3, this.FDT1, this.FDT2, this.FDT3);
    }

    public double[] getF_TestProbabilities(double[] dArray, double[] dArray2) {
        RealMatrix realMatrix = this.getFittedValues(dArray);
        double d = dArray[1];
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray3.length; ++i) {
            double d2 = dArray2[i] > 0.0 ? Math.log(dArray2[i]) : 0.0;
            dArray3[i] = d2 - d;
        }
        double[] dArray4 = this.getSumSqsAboutRegression(dArray3, realMatrix);
        double[] dArray5 = this.getSumSqsDueToRegression(dArray, dArray3.length);
        double[] dArray6 = this.modelProbabilities(dArray5, dArray4, dArray3.length);
        return dArray6;
    }

    private RealMatrix getFittedValues(double[] dArray) {
        double d = dArray[1];
        RealMatrix realMatrix = new RealMatrix(this.X.rows(), this.maxOrder / 2 + 1);
        for (int i = 0; i < this.X.rows(); ++i) {
            double d2 = 0.0;
            int n = 0;
            for (int j = 0; j < this.maxOrder + 1; j += 2) {
                for (int k = 0; k < 2 * j + 1; ++k) {
                    d2 += dArray[n + 2] * this.X.entries[i][n + 1];
                    ++n;
                }
                realMatrix.entries[i][j / 2] = d2;
            }
        }
        return realMatrix;
    }

    private void getRegressionStats(double[] dArray, RealMatrix realMatrix, double[] dArray2, double[] dArray3) {
        int n;
        int n2 = dArray.length;
        int n3 = realMatrix.columns();
        for (n = 0; n < n3; ++n) {
            dArray2[n] = 0.0;
            dArray3[n] = 0.0;
        }
        for (n = 0; n < n2; ++n) {
            int n4 = 0;
            while (n4 < n3) {
                double d = realMatrix.entries[n][0] - realMatrix.entries[n][n4];
                double d2 = dArray[n] - realMatrix.entries[n][n4];
                int n5 = n4;
                dArray2[n5] = dArray2[n5] + d * d;
                int n6 = n4++;
                dArray3[n6] = dArray3[n6] + d2 * d2;
            }
        }
    }

    private double[] getSumSqsAboutRegression(double[] dArray, RealMatrix realMatrix) {
        int n = dArray.length;
        int n2 = realMatrix.columns();
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            while (n3 < n2) {
                double d = dArray[i] - realMatrix.entries[i][n3];
                int n4 = n3++;
                dArray2[n4] = dArray2[n4] + d * d;
            }
        }
        return dArray2;
    }

    private double[] getSumSqsDueToRegression(double[] dArray, int n) {
        double[] dArray2 = new double[this.maxOrder / 2 + 1];
        int n2 = 2;
        double d = dArray[n2] / (2.0 * Math.sqrt(Math.PI));
        double d2 = 0.0;
        int n3 = this.ip.numZeroMeasurements();
        for (int i = 0; i <= this.maxOrder; i += 2) {
            d2 += dArray[n2] * dArray[n2];
            ++n2;
            for (int j = 1; j <= 2 * i; ++j) {
                d2 += 2.0 * dArray[n2] * dArray[n2];
                ++n2;
            }
            dArray2[i / 2] = (double)(n - n3) * (d2 / (Math.PI * 4) - d * d);
        }
        double d3 = this.ip.getMeanNonZeroModQ();
        double d4 = 0.0;
        for (int i = 0; d4 == 0.0 && i < this.ip.numMeasurements(); ++i) {
            d4 = this.ip.getDiffusionTime(i);
        }
        double d5 = d4 * d3 * d3;
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray2[i] * d5 * d5;
        }
        return dArray2;
    }

    private double[] modelProbabilities(double[] dArray, double[] dArray2, int n) {
        int n2 = dArray2.length;
        int n3 = n2 * (n2 - 1) / 2;
        double[] dArray3 = new double[n3];
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2 - 1; ++i) {
            try {
                int n6 = n4 += 4 * i + 1;
                for (int j = i + 1; j < n2; ++j) {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    double d5 = n - (n6 += 4 * j + 1) - 1;
                    dArray3[n5] = d4 = (d3 = d5 / ((d2 = (dArray[j] - dArray[i]) / (d = (double)(n6 - n4)) / (dArray2[j] / d5)) * (d + d5))) > 0.0 && d3 < 1.0 ? IncompleteBeta.betai(d5 / 2.0, d / 2.0, d3) : 1.0;
                    ++n5;
                }
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return dArray3;
    }

    public int selectModel(double[] dArray, double d, double d2, double d3) {
        return EvenSphHarmFitter.selectModel(dArray, this.maxOrder, d, d2, d3);
    }

    public static int selectModel(double[] dArray, int n, double d, double d2, double d3) {
        int n2 = n / 2 + 1;
        int n3 = 0;
        int n4 = 0;
        for (int i = 1; i < n2; ++i) {
            int n5 = n4 + i - n3 / 2 - 1;
            if (n3 == 0 && dArray[n5] < d) {
                n3 = 2 * i;
                n4 = n2 * i - i * (i + 1) / 2;
                continue;
            }
            if (n3 == 2 && dArray[n5] < d2) {
                n3 = 2 * i;
                n4 = n2 * i - i * (i + 1) / 2;
                continue;
            }
            if (n3 <= 2 || !(dArray[n5] < d3)) continue;
            n3 = 2 * i;
            n4 = n2 * i - i * (i + 1) / 2;
        }
        return n3;
    }
}

