/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import inverters.TensorModelFitter;
import java.util.logging.Logger;
import misc.DT;
import optimizers.MarquardtMinimiserException;

public class DiffTensorFitter
extends TensorModelFitter {
    private static Logger logger = Logger.getLogger("camino.inversions.DiffTensorFitter");

    public DiffTensorFitter() {
    }

    public DiffTensorFitter(double[][] dArray, double[] dArray2, double[] dArray3, int n) throws MarquardtMinimiserException {
        this.noParams = 6;
        this.initialize(dArray, dArray2, dArray3, n);
    }

    @Override
    protected void initAs() {
        this.a[5] = 0.0;
        this.a[3] = 0.0;
        this.a[2] = 0.0;
        double d = 2.1E-9;
        this.a[1] = Math.sqrt(d / 3.0);
        this.a[4] = Math.sqrt(d / 3.0);
        this.a[6] = Math.sqrt(d / 3.0);
    }

    public void setStartPoint(double[] dArray) {
        DT dT = new DT(dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7]);
        double[] dArray2 = DiffTensorFitter.getCholParams(dT);
        boolean bl = false;
        for (int i = 0; i < 6; ++i) {
            this.a[i + 1] = dArray2[i];
            if (dArray2[i] != 0.0) continue;
            bl = true;
        }
        if (bl) {
            double d = dArray[2] + dArray[5] + dArray[7];
            this.a[4] = this.a[6] = Math.sqrt(Math.abs(d / 3.0));
            this.a[1] = this.a[6];
            this.a[5] = 0.0;
            this.a[3] = 0.0;
            this.a[2] = 0.0;
            logger.info("Chol failure.  Negative evals in linear fitted DT.  Using identity for starting point. traceD = " + d);
        }
    }

    @Override
    protected double yfit(double[] dArray, int n) {
        DT dT = DiffTensorFitter.getDT_Chol(dArray, 1);
        double[] dArray2 = DiffTensorFitter.getQ(this.x, n);
        double d = Math.exp(-this.taus[n] * dT.contractBy(dArray2));
        return d;
    }

    @Override
    protected double[] dydas(double[] dArray, int n) {
        double[] dArray2 = new double[this.ma + 1];
        double[] dArray3 = DiffTensorFitter.getQ(this.x, n);
        double d = dArray3[0] * dArray[1] + dArray3[1] * dArray[2] + dArray3[2] * dArray[3];
        double d2 = dArray3[1] * dArray[4] + dArray3[2] * dArray[5];
        double d3 = dArray3[2] * dArray[6];
        DT dT = DiffTensorFitter.getDT_Chol(dArray, 1);
        double d4 = Math.exp(-this.taus[n] * dT.contractBy(dArray3));
        DiffTensorFitter.insertCholDerivs(dArray2, this.taus[n], 1, dArray3, d, d2, d3, 1.0, d4);
        return dArray2;
    }

    public DT getDiffTensor() {
        return DiffTensorFitter.getDT_Chol(this.a, 1);
    }
}

