/*
 * Decompiled with CFR 0.152.
 */
package inverters;

import imaging.Scheme;
import inverters.DT_Inversion;

public class AlgebraicDT_Inversion
extends DT_Inversion {
    protected double[][] qHatSq;
    protected double sumB;

    public AlgebraicDT_Inversion(Scheme scheme) {
        this.ip = scheme;
        int n = this.ip.numZeroMeasurements();
        this.qHatSq = new double[this.ip.numMeasurements() - n - this.ip.numZeroMeasurements()][6];
        this.sumB = 0.0;
        for (int i = 0; i < this.qHatSq.length; ++i) {
            double[] dArray = this.ip.getQ(i + n);
            double d = dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2];
            this.qHatSq[i][0] = dArray[0] * dArray[0] / d;
            this.qHatSq[i][1] = dArray[0] * dArray[1] / d;
            this.qHatSq[i][2] = dArray[0] * dArray[2] / d;
            this.qHatSq[i][3] = dArray[1] * dArray[1] / d;
            this.qHatSq[i][4] = dArray[1] * dArray[2] / d;
            this.qHatSq[i][5] = dArray[2] * dArray[2] / d;
            this.sumB += this.ip.getDiffusionTime(i + n) * d;
        }
    }

    @Override
    public double[] invert(double[] dArray) {
        int n;
        int n2;
        double[] dArray2 = this.ip.normalizeData(dArray);
        double[] dArray3 = new double[6];
        for (n2 = 0; n2 < 6; ++n2) {
            dArray3[n2] = 0.0;
        }
        for (n2 = 0; n2 < this.qHatSq.length; ++n2) {
            double d = -Math.log(dArray2[n2]);
            for (n = 0; n < 6; ++n) {
                int n3 = n;
                dArray3[n3] = dArray3[n3] + d * this.qHatSq[n2][n];
            }
        }
        n2 = 0;
        while (n2 < 6) {
            int n4 = n2++;
            dArray3[n4] = dArray3[n4] * (15.0 / (2.0 * this.sumB));
        }
        double d = dArray3[0] + dArray3[3] + dArray3[5];
        dArray3[0] = dArray3[0] - d / 5.0;
        dArray3[3] = dArray3[3] - d / 5.0;
        dArray3[5] = dArray3[5] - d / 5.0;
        double[] dArray4 = new double[8];
        dArray4[0] = 0.0;
        dArray4[1] = Math.log(this.ip.geoMeanZeroMeas(dArray));
        for (n = 0; n < dArray3.length; ++n) {
            dArray4[n + 2] = dArray3[n];
        }
        return dArray4;
    }
}

