/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import imaging.Scheme;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Logger;
import misc.LoggedException;

public class SchemeV1
implements Scheme {
    private static final transient Logger logger = Logger.getLogger("camino.imaging.SchemeV1");
    public static double GAMMA = 2.6751987E8;
    protected double[] modQ;
    protected double[][] gDir;
    protected double[] modG;
    protected double[] bigDel;
    protected double[] smallDel;
    protected double[] TE;
    protected boolean[] zero;
    protected boolean[] ignored;
    protected int numMeas;
    protected int numZeroMeas;
    protected double[] halfP90;
    protected int ignoreMeasurements = 0;
    private int numIgnoredMeasurements;

    public SchemeV1(String string) {
        Object object;
        Vector<String> vector = new Vector<String>();
        try {
            Scanner scanner = new Scanner(new File(string));
            scanner.useDelimiter("\r\n|\n");
            object = scanner.next();
            while (scanner.hasNext()) {
                String string2 = scanner.next();
                if (string2.length() <= 0) continue;
                vector.add(string2);
            }
            scanner.close();
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        this.numMeas = vector.size();
        this.gDir = new double[this.numMeas][3];
        this.modQ = new double[this.numMeas];
        this.modG = new double[this.numMeas];
        this.bigDel = new double[this.numMeas];
        this.smallDel = new double[this.numMeas];
        this.TE = new double[this.numMeas];
        this.zero = new boolean[this.numMeas];
        this.ignored = new boolean[this.numMeas];
        this.numZeroMeas = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            object = new Scanner((String)vector.elementAt(i));
            this.gDir[i][0] = ((Scanner)object).nextDouble();
            this.gDir[i][1] = ((Scanner)object).nextDouble();
            this.gDir[i][2] = ((Scanner)object).nextDouble();
            double d = Math.sqrt(this.gDir[i][0] * this.gDir[i][0] + this.gDir[i][1] * this.gDir[i][1] + this.gDir[i][2] * this.gDir[i][2]);
            if (d != 0.0 && Math.abs(1.0 - d) > 1.0E-5) {
                int n = 0;
                while (n < 3) {
                    double[] dArray = this.gDir[i];
                    int n2 = n++;
                    dArray[n2] = dArray[n2] / d;
                }
            }
            this.modG[i] = ((Scanner)object).nextDouble();
            this.bigDel[i] = ((Scanner)object).nextDouble();
            this.smallDel[i] = ((Scanner)object).nextDouble();
            this.TE[i] = ((Scanner)object).nextDouble();
            ((Scanner)object).close();
            this.modQ[i] = GAMMA * this.smallDel[i] * this.modG[i];
            boolean bl = this.zero[i] = this.modQ[i] == 0.0;
            if (this.zero[i]) {
                ++this.numZeroMeas;
            }
            this.ignored[i] = false;
        }
        this.halfP90 = new double[this.numMeas];
    }

    public SchemeV1(double[][] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        this(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, null);
    }

    public SchemeV1(double[][] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, boolean[] blArray) {
        this.numMeas = dArray.length;
        this.gDir = new double[this.numMeas][3];
        this.modQ = new double[this.numMeas];
        this.modG = new double[this.numMeas];
        this.bigDel = new double[this.numMeas];
        this.smallDel = new double[this.numMeas];
        this.TE = new double[this.numMeas];
        this.halfP90 = new double[this.numMeas];
        this.zero = new boolean[this.numMeas];
        this.numZeroMeas = 0;
        this.ignored = new boolean[this.numMeas];
        this.numIgnoredMeasurements = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            this.gDir[i][0] = dArray[i][0];
            this.gDir[i][1] = dArray[i][1];
            this.gDir[i][2] = dArray[i][2];
            this.modG[i] = dArray2[i];
            this.bigDel[i] = dArray3[i];
            this.smallDel[i] = dArray4[i];
            this.TE[i] = dArray5[i];
            this.halfP90[i] = dArray6[i];
            this.modQ[i] = GAMMA * this.smallDel[i] * this.modG[i];
            this.zero[i] = this.modQ[i] == 0.0;
            this.ignored[i] = blArray == null ? false : blArray[i];
            if (this.ignored[i]) {
                ++this.numIgnoredMeasurements;
                continue;
            }
            if (!this.zero[i]) continue;
            ++this.numZeroMeas;
        }
    }

    @Override
    public int numDWMeasurements() {
        return this.numMeas - this.numZeroMeas - this.numIgnoredMeasurements;
    }

    @Override
    public int numMeasurements() {
        return this.numMeas;
    }

    @Override
    public int numZeroMeasurements() {
        return this.numZeroMeas;
    }

    @Override
    public double[] getQ(int n) {
        double[] dArray = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray[i] = this.gDir[n][i] * this.modQ[n];
        }
        return dArray;
    }

    public double[] getDir(int n) {
        double[] dArray = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray[i] = this.gDir[n][i];
        }
        return dArray;
    }

    @Override
    public double getMeanNonZeroModQ() {
        double d = 0.0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i]) continue;
            d += this.modQ[i];
        }
        return d / (double)(this.numMeas - this.numZeroMeas);
    }

    @Override
    public double getDiffusionTime(int n) {
        return this.bigDel[n] - this.smallDel[n] / 3.0;
    }

    @Override
    public double[] getDiffusionTimes() {
        double[] dArray = new double[this.numMeas];
        for (int i = 0; i < this.numMeas; ++i) {
            dArray[i] = this.bigDel[i] - this.smallDel[i] / 3.0;
        }
        return dArray;
    }

    @Override
    public double[] getNonZeroQ_DiffusionTimes() {
        double[] dArray = new double[this.numMeas - this.numZeroMeas - this.numIgnoredMeasurements];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i] || this.ignored[i]) continue;
            dArray[n] = this.bigDel[i] - this.smallDel[i] / 3.0;
            ++n;
        }
        return dArray;
    }

    @Override
    public void setDiffusionTime(double d, int n) {
        logger.warning("Cannot set diffusion time in Scheme version 1.  Nothing changed.");
    }

    @Override
    public double[][] getNormNonZeroQs() {
        double[][] dArray = new double[this.numMeas - this.numZeroMeas - this.numIgnoredMeasurements][3];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i] || this.ignored[i]) continue;
            for (int j = 0; j < 3; ++j) {
                dArray[n][j] = this.gDir[i][j];
            }
            ++n;
        }
        return dArray;
    }

    @Override
    public double[][] getNonZeroQs() {
        double[][] dArray = new double[this.numMeas - this.numZeroMeas - this.numIgnoredMeasurements][3];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i] || this.ignored[i]) continue;
            for (int j = 0; j < 3; ++j) {
                dArray[n][j] = this.modQ[i] * this.gDir[i][j];
            }
            ++n;
        }
        return dArray;
    }

    @Override
    public double[] normalizeData(double[] dArray) {
        double d = this.geoMeanZeroMeas(dArray);
        if (d == 0.0) {
            logger.warning("Mean b=0 measurement is zero.  Cannot normalize.");
            d = 1.0;
        }
        double[] dArray2 = new double[this.numMeas - this.numZeroMeas - this.numIgnoredMeasurements];
        int n = 0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (this.zero[i] || this.ignored[i]) continue;
            dArray2[n] = dArray[i] / d;
            ++n;
        }
        return dArray2;
    }

    @Override
    public double geoMeanZeroMeas(double[] dArray) {
        if (this.numZeroMeas == 0) {
            return 0.0;
        }
        double d = 1.0;
        for (int i = 0; i < this.numMeas; ++i) {
            if (!this.zero[i] || this.ignored[i]) continue;
            d *= dArray[i];
        }
        return Math.pow(d, 1.0 / (double)this.numZeroMeas);
    }

    @Override
    public double getDelta(int n) {
        return this.smallDel[n];
    }

    @Override
    public void setDelta(double d, int n) {
        this.smallDel[n] = d;
    }

    @Override
    public double getDELTA(int n) {
        return this.bigDel[n];
    }

    @Override
    public void setDELTA(double d, int n) {
        this.bigDel[n] = d;
    }

    @Override
    public double getModG(int n) {
        return this.modG[n];
    }

    @Override
    public void setModG(double d, int n) {
        this.modG[n] = d;
    }

    public double getTE(int n) {
        return this.TE[n];
    }

    public void setTE(double d, int n) {
        this.TE[n] = d;
    }

    @Override
    public double getHalfP90(int n) {
        return this.halfP90[n];
    }

    @Override
    public void setHalfP90(double d, int n) {
        this.halfP90[n] = d;
    }

    @Override
    public double getModQ(int n) {
        return this.modQ[n];
    }

    @Override
    public int getIgnore() {
        return this.ignoreMeasurements;
    }

    @Override
    public void setIgnore(int n) {
        this.ignoreMeasurements = n;
    }

    public final double[] getNonZeroBigDeltas() {
        double[] dArray = new double[this.numMeas - this.numZeroMeas - this.numIgnoredMeasurements];
        int n = 0;
        for (int i = 0; i < this.bigDel.length; ++i) {
            if (this.zero[i] || this.ignored[i]) continue;
            dArray[n++] = this.bigDel[i];
        }
        return dArray;
    }

    public final double[] getNonZeroSmallDeltas() {
        double[] dArray = new double[this.numMeas - this.numZeroMeas - this.numIgnoredMeasurements];
        int n = 0;
        for (int i = 0; i < this.smallDel.length; ++i) {
            if (this.zero[i] || this.ignored[i]) continue;
            dArray[n++] = this.smallDel[i];
        }
        return dArray;
    }

    public final double[] getNonZeroModGs() {
        double[] dArray = new double[this.numMeas - this.numZeroMeas - this.numIgnoredMeasurements];
        int n = 0;
        for (int i = 0; i < this.modG.length; ++i) {
            if (this.zero[i] || this.ignored[i]) continue;
            dArray[n++] = this.modG[i];
        }
        return dArray;
    }

    @Override
    public final int getVersion() {
        return 1;
    }

    @Override
    public Scheme getSubsetScheme(int[] nArray) {
        int n = nArray.length;
        double[][] dArray = new double[n][3];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            dArray[i][0] = this.gDir[nArray[i]][0];
            dArray[i][1] = this.gDir[nArray[i]][1];
            dArray[i][2] = this.gDir[nArray[i]][2];
            dArray2[i] = this.modG[nArray[i]];
            dArray3[i] = this.bigDel[nArray[i]];
            dArray4[i] = this.smallDel[nArray[i]];
            dArray5[i] = this.TE[nArray[i]];
            dArray6[i] = this.halfP90[i];
            blArray[i] = this.ignored[nArray[i]];
        }
        return new SchemeV1(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, blArray);
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("   0.000000;  -0.000000");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("VERSION: 1");
        stringBuffer.append("\n");
        for (int i = 0; i < this.numMeas; ++i) {
            stringBuffer.append(decimalFormat.format(this.gDir[i][0]));
            stringBuffer.append(decimalFormat.format(this.gDir[i][1]));
            stringBuffer.append(decimalFormat.format(this.gDir[i][2]));
            stringBuffer.append(decimalFormat.format(this.modG[i]));
            stringBuffer.append(decimalFormat.format(this.bigDel[i]));
            stringBuffer.append(decimalFormat.format(this.smallDel[i]));
            stringBuffer.append(decimalFormat.format(this.TE[i]));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public void flipX() {
        for (int i = 0; i < this.gDir.length; ++i) {
            this.gDir[i][0] = -1.0 * this.gDir[i][0];
        }
    }

    @Override
    public void flipY() {
        for (int i = 0; i < this.gDir.length; ++i) {
            this.gDir[i][1] = -1.0 * this.gDir[i][1];
        }
    }

    @Override
    public void flipZ() {
        for (int i = 0; i < this.gDir.length; ++i) {
            this.gDir[i][2] = -1.0 * this.gDir[i][2];
        }
    }

    @Override
    public void gradOrder(int[] nArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.gDir.length; ++i) {
            d = this.gDir[i][nArray[0]];
            d2 = this.gDir[i][nArray[1]];
            d3 = this.gDir[i][nArray[2]];
            this.gDir[i][0] = d;
            this.gDir[i][1] = d2;
            this.gDir[i][2] = d3;
        }
    }

    public static void main(String[] stringArray) {
        SchemeV1 schemeV1 = new SchemeV1(stringArray[0]);
    }

    @Override
    public boolean isIgnored(int n) {
        return this.ignored[n];
    }

    @Override
    public int numIgnoredMeasurements() {
        return this.numIgnoredMeasurements;
    }
}

