/*
 * Decompiled with CFR 0.152.
 */
package imaging;

import data.DataSource;
import data.DataSourceException;
import data.ScannerOrderDataSource;
import data.VoxelOrderScaledDataSource;
import imaging.EndianCorrectInputStream;
import imaging.EndianCorrectOutputStream;
import imaging.ImageHeader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import misc.LoggedException;

public class Nifti1Dataset
extends ImageHeader {
    public static final String ANZ_HDR_EXT = ".hdr";
    public static final String ANZ_DAT_EXT = ".img";
    public static final String NI1_EXT = ".nii";
    public static final String GZIP_EXT = ".gz";
    public static final int ANZ_HDR_SIZE = 348;
    public static final long NII_HDR_SIZE = 352L;
    public static final int EXT_KEY_SIZE = 8;
    public static final String NII_MAGIC_STRING = "n+1";
    public static final String ANZ_MAGIC_STRING = "ni1";
    public static final short NIFTI_INTENT_NONE = 0;
    public static final short NIFTI_INTENT_CORREL = 2;
    public static final short NIFTI_INTENT_TTEST = 3;
    public static final short NIFTI_INTENT_FTEST = 4;
    public static final short NIFTI_INTENT_ZSCORE = 5;
    public static final short NIFTI_INTENT_CHISQ = 6;
    public static final short NIFTI_INTENT_BETA = 7;
    public static final short NIFTI_INTENT_BINOM = 8;
    public static final short NIFTI_INTENT_GAMMA = 9;
    public static final short NIFTI_INTENT_POISSON = 10;
    public static final short NIFTI_INTENT_NORMAL = 11;
    public static final short NIFTI_INTENT_FTEST_NONC = 12;
    public static final short NIFTI_INTENT_CHISQ_NONC = 13;
    public static final short NIFTI_INTENT_LOGISTIC = 14;
    public static final short NIFTI_INTENT_LAPLACE = 15;
    public static final short NIFTI_INTENT_UNIFORM = 16;
    public static final short NIFTI_INTENT_TTEST_NONC = 17;
    public static final short NIFTI_INTENT_WEIBULL = 18;
    public static final short NIFTI_INTENT_CHI = 19;
    public static final short NIFTI_INTENT_INVGAUSS = 20;
    public static final short NIFTI_INTENT_EXTVAL = 21;
    public static final short NIFTI_INTENT_PVAL = 22;
    public static final short NIFTI_INTENT_ESTIMATE = 1001;
    public static final short NIFTI_INTENT_LABEL = 1002;
    public static final short NIFTI_INTENT_NEURONAME = 1003;
    public static final short NIFTI_INTENT_GENMATRIX = 1004;
    public static final short NIFTI_INTENT_SYMMATRIX = 1005;
    public static final short NIFTI_INTENT_DISPVECT = 1006;
    public static final short NIFTI_INTENT_VECTOR = 1007;
    public static final short NIFTI_INTENT_POINTSET = 1008;
    public static final short NIFTI_INTENT_TRIANGLE = 1009;
    public static final short NIFTI_INTENT_QUATERNION = 1010;
    public static final short NIFTI_FIRST_STATCODE = 2;
    public static final short NIFTI_LAST_STATCODE = 22;
    public static final short DT_NONE = 0;
    public static final short DT_BINARY = 1;
    public static final short NIFTI_TYPE_UINT8 = 2;
    public static final short NIFTI_TYPE_INT16 = 4;
    public static final short NIFTI_TYPE_INT32 = 8;
    public static final short NIFTI_TYPE_FLOAT32 = 16;
    public static final short NIFTI_TYPE_COMPLEX64 = 32;
    public static final short NIFTI_TYPE_FLOAT64 = 64;
    public static final short NIFTI_TYPE_RGB24 = 128;
    public static final short DT_ALL = 255;
    public static final short NIFTI_TYPE_INT8 = 256;
    public static final short NIFTI_TYPE_UINT16 = 512;
    public static final short NIFTI_TYPE_UINT32 = 768;
    public static final short NIFTI_TYPE_INT64 = 1024;
    public static final short NIFTI_TYPE_UINT64 = 1280;
    public static final short NIFTI_TYPE_FLOAT128 = 1536;
    public static final short NIFTI_TYPE_COMPLEX128 = 1792;
    public static final short NIFTI_TYPE_COMPLEX256 = 2048;
    public static final short NIFTI_UNITS_UNKNOWN = 0;
    public static final short NIFTI_UNITS_METER = 1;
    public static final short NIFTI_UNITS_MM = 2;
    public static final short NIFTI_UNITS_MICRON = 3;
    public static final short NIFTI_UNITS_SEC = 8;
    public static final short NIFTI_UNITS_MSEC = 16;
    public static final short NIFTI_UNITS_USEC = 24;
    public static final short NIFTI_UNITS_HZ = 32;
    public static final short NIFTI_UNITS_PPM = 40;
    public static final short NIFTI_SLICE_SEQ_INC = 1;
    public static final short NIFTI_SLICE_SEQ_DEC = 2;
    public static final short NIFTI_SLICE_ALT_INC = 3;
    public static final short NIFTI_SLICE_ALT_DEC = 4;
    public static final short NIFTI_XFORM_UNKNOWN = 0;
    public static final short NIFTI_XFORM_SCANNER_ANAT = 1;
    public static final short NIFTI_XFORM_ALIGNED_ANAT = 2;
    public static final short NIFTI_XFORM_TALAIRACH = 3;
    public static final short NIFTI_XFORM_MNI_152 = 4;
    String ds_hdrname;
    String ds_datname;
    public boolean ds_is_nii;
    public boolean big_endian;
    public short XDIM;
    public short YDIM;
    public short ZDIM;
    public short TDIM;
    public short DIM5;
    public short DIM6;
    public short DIM7;
    public short freq_dim;
    public short phase_dim;
    public short slice_dim;
    public short xyz_unit_code;
    public short t_unit_code;
    public short qfac;
    Vector<Object> extensions_list;
    Vector<Object> extension_blobs;
    public int sizeof_hdr;
    public StringBuffer data_type_string;
    public StringBuffer db_name;
    public int extents;
    public short session_error;
    public StringBuffer regular;
    public StringBuffer dim_info;
    public short[] dim;
    public float[] intent;
    public short intent_code;
    short datatype;
    short bitpix;
    public short slice_start;
    public float[] pixdim;
    public float vox_offset;
    public float scl_slope;
    public float scl_inter;
    public short slice_end;
    public byte slice_code;
    public byte xyzt_units;
    public float cal_max;
    public float cal_min;
    public float slice_duration;
    public float toffset;
    public int glmax;
    public int glmin;
    public StringBuffer descrip;
    public StringBuffer aux_file;
    public short qform_code;
    public short sform_code;
    public float[] quatern;
    public float[] qoffset;
    public float[] srow_x;
    public float[] srow_y;
    public float[] srow_z;
    public StringBuffer intent_name;
    public StringBuffer magic;
    public byte[] extension;

    public Nifti1Dataset(String string) {
        this.setDefaults();
        this.checkName(string);
    }

    public Nifti1Dataset() {
        this.setDefaults();
    }

    public void readHeader() throws IOException, FileNotFoundException {
        EndianCorrectInputStream endianCorrectInputStream;
        DataInputStream dataInputStream = this.ds_hdrname.endsWith(GZIP_EXT) ? new DataInputStream(new GZIPInputStream(new FileInputStream(this.ds_hdrname))) : new DataInputStream(new FileInputStream(this.ds_hdrname));
        try {
            int n;
            dataInputStream.skipBytes(40);
            short s = dataInputStream.readShort();
            dataInputStream.close();
            this.big_endian = s >= 1 && s <= 7;
            endianCorrectInputStream = this.ds_hdrname.endsWith(GZIP_EXT) ? new EndianCorrectInputStream(new GZIPInputStream(new FileInputStream(this.ds_hdrname)), this.big_endian) : new EndianCorrectInputStream(this.ds_hdrname, this.big_endian);
            this.sizeof_hdr = endianCorrectInputStream.readIntCorrect();
            byte[] byArray = new byte[10];
            endianCorrectInputStream.readFully(byArray, 0, 10);
            this.data_type_string = new StringBuffer(new String(byArray));
            byArray = new byte[18];
            endianCorrectInputStream.readFully(byArray, 0, 18);
            this.db_name = new StringBuffer(new String(byArray));
            this.extents = endianCorrectInputStream.readIntCorrect();
            this.session_error = endianCorrectInputStream.readShortCorrect();
            this.regular = new StringBuffer();
            this.regular.append((char)endianCorrectInputStream.readUnsignedByte());
            this.dim_info = new StringBuffer();
            this.dim_info.append((char)endianCorrectInputStream.readUnsignedByte());
            short[] sArray = this.unpackDimInfo(this.dim_info.charAt(0));
            this.freq_dim = sArray[0];
            this.phase_dim = sArray[1];
            this.slice_dim = sArray[2];
            for (n = 0; n < 8; ++n) {
                this.dim[n] = endianCorrectInputStream.readShortCorrect();
            }
            if (this.dim[0] > 0) {
                this.XDIM = this.dim[1];
            }
            if (this.dim[0] > 1) {
                this.YDIM = this.dim[2];
            }
            if (this.dim[0] > 2) {
                this.ZDIM = this.dim[3];
            }
            if (this.dim[0] > 3) {
                this.TDIM = this.dim[4];
            }
            for (n = 0; n < 3; ++n) {
                this.intent[n] = endianCorrectInputStream.readFloatCorrect();
            }
            this.intent_code = endianCorrectInputStream.readShortCorrect();
            this.datatype = endianCorrectInputStream.readShortCorrect();
            this.bitpix = endianCorrectInputStream.readShortCorrect();
            this.slice_start = endianCorrectInputStream.readShortCorrect();
            for (n = 0; n < 8; ++n) {
                this.pixdim[n] = endianCorrectInputStream.readFloatCorrect();
            }
            this.qfac = (short)Math.floor(this.pixdim[0]);
            this.vox_offset = endianCorrectInputStream.readFloatCorrect();
            this.scl_slope = endianCorrectInputStream.readFloatCorrect();
            this.scl_inter = endianCorrectInputStream.readFloatCorrect();
            this.slice_end = endianCorrectInputStream.readShortCorrect();
            this.slice_code = (byte)endianCorrectInputStream.readUnsignedByte();
            this.xyzt_units = (byte)endianCorrectInputStream.readUnsignedByte();
            sArray = this.unpackUnits(this.xyzt_units);
            this.xyz_unit_code = sArray[0];
            this.t_unit_code = sArray[1];
            this.cal_max = endianCorrectInputStream.readFloatCorrect();
            this.cal_min = endianCorrectInputStream.readFloatCorrect();
            this.slice_duration = endianCorrectInputStream.readFloatCorrect();
            this.toffset = endianCorrectInputStream.readFloatCorrect();
            this.glmax = endianCorrectInputStream.readIntCorrect();
            this.glmin = endianCorrectInputStream.readIntCorrect();
            byArray = new byte[80];
            endianCorrectInputStream.readFully(byArray, 0, 80);
            this.descrip = new StringBuffer(new String(byArray));
            byArray = new byte[24];
            endianCorrectInputStream.readFully(byArray, 0, 24);
            this.aux_file = new StringBuffer(new String(byArray));
            this.qform_code = endianCorrectInputStream.readShortCorrect();
            this.sform_code = endianCorrectInputStream.readShortCorrect();
            for (n = 0; n < 3; ++n) {
                this.quatern[n] = endianCorrectInputStream.readFloatCorrect();
            }
            for (n = 0; n < 3; ++n) {
                this.qoffset[n] = endianCorrectInputStream.readFloatCorrect();
            }
            for (n = 0; n < 4; ++n) {
                this.srow_x[n] = endianCorrectInputStream.readFloatCorrect();
            }
            for (n = 0; n < 4; ++n) {
                this.srow_y[n] = endianCorrectInputStream.readFloatCorrect();
            }
            for (n = 0; n < 4; ++n) {
                this.srow_z[n] = endianCorrectInputStream.readFloatCorrect();
            }
            byArray = new byte[16];
            endianCorrectInputStream.readFully(byArray, 0, 16);
            this.intent_name = new StringBuffer(new String(byArray));
            byArray = new byte[4];
            endianCorrectInputStream.readFully(byArray, 0, 4);
            this.magic = new StringBuffer(new String(byArray));
        }
        catch (IOException iOException) {
            throw new IOException("Error: unable to read header file " + this.ds_hdrname + ": " + iOException.getMessage());
        }
        if (this.ds_is_nii) {
            this.readNiiExt(endianCorrectInputStream);
        } else {
            this.readNp1Ext(endianCorrectInputStream);
        }
        endianCorrectInputStream.close();
    }

    public void copyHeader(Nifti1Dataset nifti1Dataset) {
        int n;
        this.ds_hdrname = new String(nifti1Dataset.ds_hdrname);
        this.ds_datname = new String(nifti1Dataset.ds_datname);
        this.ds_is_nii = nifti1Dataset.ds_is_nii;
        this.big_endian = nifti1Dataset.big_endian;
        this.sizeof_hdr = nifti1Dataset.sizeof_hdr;
        this.data_type_string = new StringBuffer(nifti1Dataset.data_type_string.toString());
        this.db_name = new StringBuffer(nifti1Dataset.db_name.toString());
        this.extents = nifti1Dataset.extents;
        this.session_error = nifti1Dataset.session_error;
        this.regular = new StringBuffer(nifti1Dataset.regular.toString());
        this.dim_info = new StringBuffer(nifti1Dataset.dim_info.toString());
        this.freq_dim = nifti1Dataset.freq_dim;
        this.phase_dim = nifti1Dataset.phase_dim;
        this.slice_dim = nifti1Dataset.slice_dim;
        for (n = 0; n < 8; ++n) {
            this.dim[n] = nifti1Dataset.dim[n];
        }
        this.XDIM = nifti1Dataset.XDIM;
        this.YDIM = nifti1Dataset.YDIM;
        this.ZDIM = nifti1Dataset.ZDIM;
        this.TDIM = nifti1Dataset.TDIM;
        this.DIM5 = nifti1Dataset.DIM5;
        this.DIM6 = nifti1Dataset.DIM6;
        this.DIM7 = nifti1Dataset.DIM7;
        for (n = 0; n < 3; ++n) {
            this.intent[n] = nifti1Dataset.intent[n];
        }
        this.intent_code = nifti1Dataset.intent_code;
        this.datatype = nifti1Dataset.datatype;
        this.bitpix = nifti1Dataset.bitpix;
        this.slice_start = nifti1Dataset.slice_start;
        this.qfac = 1;
        for (n = 0; n < 8; ++n) {
            this.pixdim[n] = nifti1Dataset.pixdim[n];
        }
        this.vox_offset = nifti1Dataset.vox_offset;
        this.scl_slope = nifti1Dataset.scl_slope;
        this.scl_inter = nifti1Dataset.scl_inter;
        this.slice_end = nifti1Dataset.slice_end;
        this.slice_code = nifti1Dataset.slice_code;
        this.xyzt_units = nifti1Dataset.xyzt_units;
        this.xyz_unit_code = nifti1Dataset.xyz_unit_code;
        this.t_unit_code = nifti1Dataset.t_unit_code;
        this.cal_max = nifti1Dataset.cal_max;
        this.cal_min = nifti1Dataset.cal_min;
        this.slice_duration = nifti1Dataset.slice_duration;
        this.toffset = nifti1Dataset.toffset;
        this.glmax = nifti1Dataset.glmax;
        this.glmin = nifti1Dataset.glmin;
        this.descrip = new StringBuffer(nifti1Dataset.descrip.toString());
        this.aux_file = new StringBuffer(nifti1Dataset.aux_file.toString());
        this.qform_code = nifti1Dataset.qform_code;
        this.sform_code = nifti1Dataset.sform_code;
        for (n = 0; n < 3; ++n) {
            this.quatern[n] = nifti1Dataset.quatern[n];
            this.qoffset[n] = nifti1Dataset.qoffset[n];
        }
        for (n = 0; n < 4; ++n) {
            this.srow_x[n] = nifti1Dataset.srow_x[n];
            this.srow_y[n] = nifti1Dataset.srow_y[n];
            this.srow_z[n] = nifti1Dataset.srow_z[n];
        }
        this.intent_name = new StringBuffer(nifti1Dataset.intent_name.toString());
        this.magic = new StringBuffer(nifti1Dataset.magic.toString());
        for (n = 0; n < 4; ++n) {
            this.extension[n] = 0;
        }
    }

    private void readNiiExt(EndianCorrectInputStream endianCorrectInputStream) throws IOException {
        try {
            endianCorrectInputStream.readFully(this.extension, 0, 4);
        }
        catch (IOException iOException) {
            throw new IOException("Error: i/o error reading extension bytes on header file " + this.ds_hdrname + ": " + iOException.getMessage());
        }
        int[] nArray = new int[2];
        if (this.extension[0] != 0) {
            int n = 352;
            nArray[0] = 0;
            nArray[1] = 0;
            while (n < (int)this.vox_offset) {
                try {
                    nArray = new int[]{endianCorrectInputStream.readIntCorrect(), endianCorrectInputStream.readIntCorrect()};
                    byte[] byArray = new byte[nArray[0] - 8];
                    endianCorrectInputStream.readFully(byArray, 0, nArray[0] - 8);
                    this.extension_blobs.add(byArray);
                }
                catch (IOException iOException) {
                    this.printHeader();
                    throw new EOFException("Error: i/o error reading extension data for extension " + (this.extensions_list.size() + 1) + " on header file " + this.ds_hdrname + ": " + iOException.getMessage());
                }
                this.extensions_list.add(nArray);
                if ((n += nArray[0]) <= (int)this.vox_offset) continue;
                this.printHeader();
                throw new IOException("Error: Data  for extension " + this.extensions_list.size() + " on header file " + this.ds_hdrname + " appears to overrun start of image data.");
            }
        }
    }

    private void readNp1Ext(EndianCorrectInputStream endianCorrectInputStream) throws IOException, EOFException {
        try {
            endianCorrectInputStream.readFully(this.extension, 0, 4);
        }
        catch (EOFException eOFException) {
            return;
        }
        catch (IOException iOException) {
            throw new IOException("Error: i/o error reading extension bytes on header file " + this.ds_hdrname + ": " + iOException.getMessage());
        }
        int[] nArray = new int[2];
        if (this.extension[0] != 0) {
            nArray[0] = 0;
            nArray[1] = 0;
            while (true) {
                try {
                    nArray = new int[]{endianCorrectInputStream.readIntCorrect(), endianCorrectInputStream.readIntCorrect()};
                    byte[] byArray = new byte[nArray[0] - 8];
                    endianCorrectInputStream.readFully(byArray, 0, nArray[0] - 8);
                    this.extension_blobs.add(byArray);
                }
                catch (EOFException eOFException) {
                    return;
                }
                catch (IOException iOException) {
                    throw new EOFException("Error: i/o error reading extension data for extension " + (this.extensions_list.size() + 1) + " on header file " + this.ds_hdrname + ": " + iOException.getMessage());
                }
                this.extensions_list.add(nArray);
            }
        }
    }

    public int[][] getExtensionsList() {
        int[] nArray = new int[2];
        int n = this.extensions_list.size();
        int[][] nArray2 = new int[n][2];
        for (int i = 0; i < n; ++i) {
            nArray = (int[])this.extensions_list.get(i);
            nArray2[i][0] = nArray[0];
            nArray2[i][1] = nArray[1];
        }
        return nArray2;
    }

    public void removeExtension(int n) {
        int[] nArray = new int[2];
        int n2 = this.extensions_list.size();
        if (n >= n2) {
            System.out.println("\nERROR: could not remove extension " + n + 1 + " from " + this.ds_hdrname + ". It only has " + n2 + " extensions.");
            return;
        }
        nArray = (int[])this.extensions_list.get(n);
        this.extensions_list.remove(n);
        this.extension_blobs.remove(n);
        if (this.ds_is_nii) {
            this.vox_offset -= (float)nArray[0];
        }
    }

    public void addExtension(int n, String string) throws IOException {
        int[] nArray = new int[2];
        File file = new File(string);
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("Error: maximum extension size is 2147483647bytes. " + string + " is " + l + " bytes.");
        }
        int n2 = (int)l;
        int n3 = (n2 + 8) % 16;
        if (n3 != 0) {
            n3 = 16 - n3;
        }
        byte[] byArray = new byte[n2 + n3];
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            dataInputStream.readFully(byArray, 0, n2);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new IOException("Error reading extension data for " + this.ds_hdrname + " from file " + string + ". :" + iOException.getMessage());
        }
        for (int i = n2; i < n2 + n3; ++i) {
            byArray[i] = 0;
        }
        nArray[0] = n2 + n3 + 8;
        nArray[1] = n;
        this.extensions_list.add(nArray);
        this.extension_blobs.add(byArray);
        this.extension[0] = 1;
        if (this.ds_is_nii) {
            this.vox_offset += (float)nArray[0];
        }
    }

    public void writeHeader() throws IOException, FileNotFoundException {
        int n;
        EndianCorrectOutputStream endianCorrectOutputStream;
        FileOutputStream fileOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        int n2 = 348;
        if (this.ds_is_nii || this.extension[0] != 0) {
            n2 += 4;
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream(n2);
            fileOutputStream = new FileOutputStream(this.ds_hdrname);
            endianCorrectOutputStream = new EndianCorrectOutputStream(byteArrayOutputStream, this.big_endian);
            endianCorrectOutputStream.writeIntCorrect(this.sizeof_hdr);
            if (this.data_type_string.length() >= 10) {
                endianCorrectOutputStream.writeBytes(this.data_type_string.substring(0, 10));
            } else {
                endianCorrectOutputStream.writeBytes(this.data_type_string.toString());
                for (n = 0; n < 10 - this.data_type_string.length(); ++n) {
                    endianCorrectOutputStream.writeByte(0);
                }
            }
            if (this.db_name.length() >= 18) {
                endianCorrectOutputStream.writeBytes(this.db_name.substring(0, 18));
            } else {
                endianCorrectOutputStream.writeBytes(this.db_name.toString());
                for (n = 0; n < 18 - this.db_name.length(); ++n) {
                    endianCorrectOutputStream.writeByte(0);
                }
            }
            endianCorrectOutputStream.writeIntCorrect(this.extents);
            endianCorrectOutputStream.writeShortCorrect(this.session_error);
            endianCorrectOutputStream.writeByte(this.regular.charAt(0));
            byte by = this.packDimInfo(this.freq_dim, this.phase_dim, this.slice_dim);
            endianCorrectOutputStream.writeByte(by);
            for (n = 0; n < 8; ++n) {
                endianCorrectOutputStream.writeShortCorrect(this.dim[n]);
            }
            for (n = 0; n < 3; ++n) {
                endianCorrectOutputStream.writeFloatCorrect(this.intent[n]);
            }
            endianCorrectOutputStream.writeShortCorrect(this.intent_code);
            endianCorrectOutputStream.writeShortCorrect(this.datatype);
            endianCorrectOutputStream.writeShortCorrect(this.bitpix);
            endianCorrectOutputStream.writeShortCorrect(this.slice_start);
            for (n = 0; n < 8; ++n) {
                endianCorrectOutputStream.writeFloatCorrect(this.pixdim[n]);
            }
            endianCorrectOutputStream.writeFloatCorrect(this.vox_offset);
            endianCorrectOutputStream.writeFloatCorrect(this.scl_slope);
            endianCorrectOutputStream.writeFloatCorrect(this.scl_inter);
            endianCorrectOutputStream.writeShortCorrect(this.slice_end);
            endianCorrectOutputStream.writeByte(this.slice_code);
            endianCorrectOutputStream.writeByte(this.packUnits(this.xyz_unit_code, this.t_unit_code));
            endianCorrectOutputStream.writeFloatCorrect(this.cal_max);
            endianCorrectOutputStream.writeFloatCorrect(this.cal_min);
            endianCorrectOutputStream.writeFloatCorrect(this.slice_duration);
            endianCorrectOutputStream.writeFloatCorrect(this.toffset);
            endianCorrectOutputStream.writeIntCorrect(this.glmax);
            endianCorrectOutputStream.writeIntCorrect(this.glmin);
            endianCorrectOutputStream.write(this.setStringSize(this.descrip, 80), 0, 80);
            endianCorrectOutputStream.write(this.setStringSize(this.aux_file, 24), 0, 24);
            endianCorrectOutputStream.writeShortCorrect(this.qform_code);
            endianCorrectOutputStream.writeShortCorrect(this.sform_code);
            for (n = 0; n < 3; ++n) {
                endianCorrectOutputStream.writeFloatCorrect(this.quatern[n]);
            }
            for (n = 0; n < 3; ++n) {
                endianCorrectOutputStream.writeFloatCorrect(this.qoffset[n]);
            }
            for (n = 0; n < 4; ++n) {
                endianCorrectOutputStream.writeFloatCorrect(this.srow_x[n]);
            }
            for (n = 0; n < 4; ++n) {
                endianCorrectOutputStream.writeFloatCorrect(this.srow_y[n]);
            }
            for (n = 0; n < 4; ++n) {
                endianCorrectOutputStream.writeFloatCorrect(this.srow_z[n]);
            }
            endianCorrectOutputStream.write(this.setStringSize(this.intent_name, 16), 0, 16);
            endianCorrectOutputStream.write(this.setStringSize(this.magic, 4), 0, 4);
            if (this.ds_is_nii || this.extension[0] != 0) {
                for (n = 0; n < 4; ++n) {
                    endianCorrectOutputStream.writeByte(this.extension[n]);
                }
            }
            byteArrayOutputStream.writeTo(fileOutputStream);
        }
        catch (IOException iOException) {
            throw new IOException("Error: unable to write header file " + this.ds_hdrname + ": " + iOException.getMessage());
        }
        try {
            if (this.extension[0] != 0) {
                byteArrayOutputStream = new ByteArrayOutputStream(8);
                endianCorrectOutputStream = new EndianCorrectOutputStream(byteArrayOutputStream, this.big_endian);
                int[][] nArray = this.getExtensionsList();
                int n3 = nArray.length;
                for (n = 0; n < n3; ++n) {
                    endianCorrectOutputStream.writeIntCorrect(nArray[n][0]);
                    endianCorrectOutputStream.writeIntCorrect(nArray[n][1]);
                    byteArrayOutputStream.writeTo(fileOutputStream);
                    byteArrayOutputStream.reset();
                    byte[] byArray = (byte[])this.extension_blobs.get(n);
                    fileOutputStream.write(byArray, 0, nArray[n][0] - 8);
                }
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new IOException("Error: unable to write header extensions for file " + this.ds_hdrname + ": " + iOException.getMessage());
        }
    }

    public void printHeader() {
        System.out.print(this.toString());
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append("Dataset header file:\t\t\t\t" + this.ds_hdrname + "\n");
        stringBuffer.append("Dataset data file:\t\t\t\t" + this.ds_datname + "\n");
        stringBuffer.append("Size of header:\t\t\t\t\t" + this.sizeof_hdr + "\n");
        stringBuffer.append("File offset to data blob:\t\t\t" + this.vox_offset + "\n");
        stringBuffer.append("Endianness:\t\t\t\t\t");
        if (this.big_endian) {
            stringBuffer.append("big\n");
        } else {
            stringBuffer.append("little\n");
        }
        stringBuffer.append("Magic filetype string:\t\t\t\t" + this.magic + "\n");
        stringBuffer.append("Datatype:\t\t\t\t\t" + this.datatype + " (" + this.decodeDatatype(this.datatype) + ")\n");
        stringBuffer.append("Bits per voxel:\t\t\t\t\t" + this.bitpix + "\n");
        stringBuffer.append("Scaling slope and intercept:\t\t\t" + this.scl_slope + " " + this.scl_inter + "\n");
        stringBuffer.append("Dataset dimensions (Count, X,Y,Z,T...):\t\t");
        for (n = 0; n <= this.dim[0]; ++n) {
            stringBuffer.append(this.dim[n] + " ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Grid spacings (X,Y,Z,T,...):\t\t\t");
        for (n = 1; n <= this.dim[0]; ++n) {
            stringBuffer.append(this.pixdim[n] + " ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("XYZ  units:\t\t\t\t\t" + this.xyz_unit_code + " (" + this.decodeUnits(this.xyz_unit_code) + ")\n");
        stringBuffer.append("T units:\t\t\t\t\t" + this.t_unit_code + " (" + this.decodeUnits(this.t_unit_code) + ")\n");
        stringBuffer.append("T offset:\t\t\t\t\t" + this.toffset + "\n");
        stringBuffer.append("Intent parameters:\t\t\t\t");
        for (n = 0; n < 3; ++n) {
            stringBuffer.append(this.intent[n] + " ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Intent code:\t\t\t\t\t" + this.intent_code + " (" + this.decodeIntent(this.intent_code) + ")\n");
        stringBuffer.append("Cal. (display) max/min:\t\t\t\t" + this.cal_max + " " + this.cal_min + "\n");
        stringBuffer.append("Slice timing code:\t\t\t\t" + this.slice_code + " (" + this.decodeSliceOrder(this.slice_code) + ")\n");
        stringBuffer.append("MRI slice ordering (freq, phase, slice index):\t" + this.freq_dim + " " + this.phase_dim + " " + this.slice_dim + "\n");
        stringBuffer.append("Start/end slice:\t\t\t\t" + this.slice_start + " " + this.slice_end + "\n");
        stringBuffer.append("Slice duration:\t\t\t\t\t" + this.slice_duration + "\n");
        stringBuffer.append("Q factor:\t\t\t\t\t" + this.qfac + "\n");
        stringBuffer.append("Qform transform code:\t\t\t\t" + this.qform_code + " (" + this.decodeXform(this.qform_code) + ")\n");
        stringBuffer.append("Quaternion b,c,d params:\t\t\t" + this.quatern[0] + " " + this.quatern[1] + " " + this.quatern[2] + "\n");
        stringBuffer.append("Quaternion x,y,z shifts:\t\t\t" + this.qoffset[0] + " " + this.qoffset[1] + " " + this.qoffset[2] + "\n");
        stringBuffer.append("Affine transform code:\t\t\t\t" + this.sform_code + " (" + this.decodeXform(this.sform_code) + ")\n");
        stringBuffer.append("1st row affine transform:\t\t\t");
        for (n = 0; n < 4; ++n) {
            stringBuffer.append(this.srow_x[n] + " ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("2nd row affine transform:\t\t\t");
        for (n = 0; n < 4; ++n) {
            stringBuffer.append(this.srow_y[n] + " ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("3rd row affine transform:\t\t\t");
        for (n = 0; n < 4; ++n) {
            stringBuffer.append(this.srow_z[n] + " ");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Description:\t\t\t\t\t" + this.descrip + "\n");
        stringBuffer.append("Intent name:\t\t\t\t\t" + this.intent_name + "\n");
        stringBuffer.append("Auxiliary file:\t\t\t\t\t" + this.aux_file + "\n");
        stringBuffer.append("Extension byte 1:\t\t\t\t\t" + this.extension[0] + "\n");
        stringBuffer.append("\n\nUnused Fields\n");
        stringBuffer.append("----------------------------------------------------------------------\n");
        stringBuffer.append("Data type string:\t\t\t" + this.data_type_string + "\n");
        stringBuffer.append("db_name:\t\t\t\t\t" + this.db_name + "\n");
        stringBuffer.append("extents:\t\t\t\t\t" + this.extents + "\n");
        stringBuffer.append("session_error:\t\t\t\t\t" + this.session_error + "\n");
        stringBuffer.append("regular:\t\t\t\t\t" + this.regular + "\n");
        stringBuffer.append("glmax/glmin:\t\t\t\t\t" + this.glmax + " " + this.glmin + "\n");
        stringBuffer.append("Extension bytes 2-4:\t\t\t\t" + this.extension[1] + " " + this.extension[2] + " " + this.extension[3] + "\n");
        if (this.extension[0] != 0) {
            int[][] nArray = this.getExtensionsList();
            int n2 = nArray.length;
            stringBuffer.append("\n\nExtensions\n");
            stringBuffer.append("----------------------------------------------------------------------\n");
            stringBuffer.append("#\tCode\tSize\n");
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(n + 1 + "\t" + nArray[n][1] + "\t" + nArray[n][0] + "\n");
            }
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    public void printDoubleTmcrs(double[] dArray) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(6);
        numberFormat.setGroupingUsed(false);
        for (short s = 0; s < this.TDIM; s = (short)(s + 1)) {
            System.out.println(numberFormat.format(dArray[s]));
        }
    }

    public boolean exists() {
        return this.existsHdr() && this.existsDat();
    }

    public boolean existsHdr() {
        File file = new File(this.ds_hdrname);
        if (file.exists()) {
            return true;
        }
        file = new File(this.ds_hdrname + GZIP_EXT);
        return file.exists();
    }

    public boolean existsDat() {
        File file = new File(this.ds_datname);
        if (file.exists()) {
            return true;
        }
        file = new File(this.ds_datname + GZIP_EXT);
        return file.exists();
    }

    public void setHeaderFilename(String string) {
        if (string.endsWith(NI1_EXT)) {
            this.setToNii();
        } else {
            this.setToNi1();
        }
        this.ds_hdrname = string;
        if (this.ds_is_nii) {
            if (!this.ds_hdrname.endsWith(NI1_EXT)) {
                this.ds_hdrname = this.ds_hdrname + NI1_EXT;
            }
        } else if (!this.ds_hdrname.endsWith(ANZ_HDR_EXT)) {
            this.ds_hdrname = this.ds_hdrname + ANZ_HDR_EXT;
        }
    }

    public String getHeaderFilename() {
        return this.ds_hdrname;
    }

    public void setDataFilename(String string) {
        this.ds_datname = string;
        if (this.ds_is_nii) {
            if (!this.ds_datname.endsWith(NI1_EXT)) {
                this.ds_datname = this.ds_datname + NI1_EXT;
            }
        } else if (!this.ds_datname.endsWith(ANZ_DAT_EXT)) {
            this.ds_datname = this.ds_datname + ANZ_DAT_EXT;
        }
    }

    public String getDataFilename() {
        return this.ds_datname;
    }

    private void setToNii() {
        this.ds_is_nii = true;
        this.magic = new StringBuffer(NII_MAGIC_STRING);
        this.vox_offset = 352.0f;
        if (this.extension[0] != 0) {
            int[][] nArray = this.getExtensionsList();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                this.vox_offset += (float)nArray[i][0];
            }
        }
    }

    private void setToNi1() {
        this.ds_is_nii = false;
        this.magic = new StringBuffer(ANZ_MAGIC_STRING);
        this.vox_offset = 0.0f;
    }

    public void setDims(short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8) {
        this.dim[0] = s;
        this.dim[1] = s2;
        this.dim[2] = s3;
        this.dim[3] = s4;
        this.dim[4] = s5;
        this.dim[5] = s6;
        this.dim[6] = s7;
        this.dim[7] = s8;
        this.XDIM = s2;
        this.YDIM = s3;
        this.ZDIM = s4;
        this.TDIM = s5;
    }

    public void setDatatype(short s) {
        this.datatype = s;
        this.bitpix = (short)(this.bytesPerVoxel(s) * 8);
    }

    public short getDatatype() {
        return this.datatype;
    }

    public short getBitpix() {
        return this.bitpix;
    }

    public String decodeIntent(short s) {
        switch (s) {
            case 0: {
                return "NIFTI_INTENT_NONE";
            }
            case 2: {
                return "NIFTI_INTENT_CORREL";
            }
            case 3: {
                return "NIFTI_INTENT_TTEST";
            }
            case 4: {
                return "NIFTI_INTENT_FTEST";
            }
            case 5: {
                return "NIFTI_INTENT_ZSCORE";
            }
            case 6: {
                return "NIFTI_INTENT_CHISQ";
            }
            case 7: {
                return "NIFTI_INTENT_BETA";
            }
            case 8: {
                return "NIFTI_INTENT_BINOM";
            }
            case 9: {
                return "NIFTI_INTENT_GAMMA";
            }
            case 10: {
                return "NIFTI_INTENT_POISSON";
            }
            case 11: {
                return "NIFTI_INTENT_NORMAL";
            }
            case 12: {
                return "NIFTI_INTENT_FTEST_NONC";
            }
            case 13: {
                return "NIFTI_INTENT_CHISQ_NONC";
            }
            case 14: {
                return "NIFTI_INTENT_LOGISTIC";
            }
            case 15: {
                return "NIFTI_INTENT_LAPLACE";
            }
            case 16: {
                return "NIFTI_INTENT_UNIFORM";
            }
            case 17: {
                return "NIFTI_INTENT_TTEST_NONC";
            }
            case 18: {
                return "NIFTI_INTENT_WEIBULL";
            }
            case 19: {
                return "NIFTI_INTENT_CHI";
            }
            case 20: {
                return "NIFTI_INTENT_INVGAUSS";
            }
            case 21: {
                return "NIFTI_INTENT_EXTVAL";
            }
            case 22: {
                return "NIFTI_INTENT_PVAL";
            }
            case 1001: {
                return "NIFTI_INTENT_ESTIMATE";
            }
            case 1002: {
                return "NIFTI_INTENT_LABEL";
            }
            case 1003: {
                return "NIFTI_INTENT_NEURONAME";
            }
            case 1004: {
                return "NIFTI_INTENT_GENMATRIX";
            }
            case 1005: {
                return "NIFTI_INTENT_SYMMATRIX";
            }
            case 1006: {
                return "NIFTI_INTENT_DISPVECT";
            }
            case 1007: {
                return "NIFTI_INTENT_VECTOR";
            }
            case 1008: {
                return "NIFTI_INTENT_POINTSET";
            }
            case 1009: {
                return "NIFTI_INTENT_TRIANGLE";
            }
            case 1010: {
                return "NIFTI_INTENT_QUATERNION";
            }
        }
        return "INVALID_NIFTI_INTENT_CODE";
    }

    public String decodeDatatype(short s) {
        switch (s) {
            case 0: {
                return "DT_NONE";
            }
            case 1: {
                return "DT_BINARY";
            }
            case 2: {
                return "NIFTI_TYPE_UINT8";
            }
            case 4: {
                return "NIFTI_TYPE_INT16";
            }
            case 8: {
                return "NIFTI_TYPE_INT32";
            }
            case 16: {
                return "NIFTI_TYPE_FLOAT32";
            }
            case 32: {
                return "NIFTI_TYPE_COMPLEX64";
            }
            case 64: {
                return "NIFTI_TYPE_FLOAT64";
            }
            case 128: {
                return "NIFTI_TYPE_RGB24";
            }
            case 255: {
                return "DT_ALL";
            }
            case 256: {
                return "NIFTI_TYPE_INT8";
            }
            case 512: {
                return "NIFTI_TYPE_UINT16";
            }
            case 768: {
                return "NIFTI_TYPE_UINT32";
            }
            case 1024: {
                return "NIFTI_TYPE_INT64";
            }
            case 1280: {
                return "NIFTI_TYPE_UINT64";
            }
            case 1536: {
                return "NIFTI_TYPE_FLOAT128";
            }
            case 1792: {
                return "NIFTI_TYPE_COMPLEX128";
            }
            case 2048: {
                return "NIFTI_TYPE_COMPLEX256";
            }
        }
        return "INVALID_NIFTI_DATATYPE_CODE";
    }

    public short bytesPerVoxel(short s) {
        switch (s) {
            case 0: {
                return 0;
            }
            case 1: {
                return -1;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 4;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 8;
            }
            case 64: {
                return 8;
            }
            case 128: {
                return 3;
            }
            case 255: {
                return 0;
            }
            case 256: {
                return 1;
            }
            case 512: {
                return 2;
            }
            case 768: {
                return 4;
            }
            case 1024: {
                return 8;
            }
            case 1280: {
                return 8;
            }
            case 1536: {
                return 16;
            }
            case 1792: {
                return 16;
            }
            case 2048: {
                return 32;
            }
        }
        return 0;
    }

    public String decodeSliceOrder(short s) {
        switch (s) {
            case 1: {
                return "NIFTI_SLICE_SEQ_INC";
            }
            case 2: {
                return "NIFTI_SLICE_SEQ_DEC";
            }
            case 3: {
                return "NIFTI_SLICE_ALT_INC";
            }
            case 4: {
                return "NIFTI_SLICE_ALT_DEC";
            }
        }
        return "INVALID_NIFTI_SLICE_SEQ_CODE";
    }

    public String decodeXform(short s) {
        switch (s) {
            case 0: {
                return "NIFTI_XFORM_UNKNOWN";
            }
            case 1: {
                return "NIFTI_XFORM_SCANNER_ANAT";
            }
            case 2: {
                return "NIFTI_XFORM_ALIGNED_ANAT";
            }
            case 3: {
                return "NIFTI_XFORM_TALAIRACH";
            }
            case 4: {
                return "NIFTI_XFORM_MNI_152";
            }
        }
        return "INVALID_NIFTI_XFORM_CODE";
    }

    public String decodeUnits(short s) {
        switch (s) {
            case 0: {
                return "NIFTI_UNITS_UNKNOWN";
            }
            case 1: {
                return "NIFTI_UNITS_METER";
            }
            case 2: {
                return "NIFTI_UNITS_MM";
            }
            case 3: {
                return "NIFTI_UNITS_MICRON";
            }
            case 8: {
                return "NIFTI_UNITS_SEC";
            }
            case 16: {
                return "NIFTI_UNITS_MSEC";
            }
            case 24: {
                return "NIFTI_UNITS_USEC";
            }
            case 32: {
                return "NIFTI_UNITS_HZ";
            }
            case 40: {
                return "NIFTI_UNITS_PPM";
            }
        }
        return "INVALID_NIFTI_UNITS_CODE";
    }

    public short checkHeader() {
        return 0;
    }

    private void checkName(String string) {
        String string2 = new String(string);
        if (string2.endsWith(GZIP_EXT)) {
            string2 = string2.substring(0, string2.length() - GZIP_EXT.length());
        }
        if (!(string2.endsWith(ANZ_HDR_EXT) || string2.endsWith(ANZ_DAT_EXT) || string2.endsWith(NI1_EXT))) {
            File file = new File(string2 + NI1_EXT);
            File file2 = new File(string2 + NI1_EXT + GZIP_EXT);
            File file3 = new File(string2 + ANZ_HDR_EXT);
            File file4 = new File(string2 + ANZ_HDR_EXT + GZIP_EXT);
            File file5 = new File(string2 + ANZ_DAT_EXT);
            File file6 = new File(string2 + ANZ_DAT_EXT + GZIP_EXT);
            if (file.exists()) {
                string2 = string2 + NI1_EXT;
            } else if (file2.exists()) {
                string2 = string2 + NI1_EXT;
            } else if (file3.exists()) {
                string2 = string2 + ANZ_HDR_EXT;
            } else if (file4.exists()) {
                string2 = string2 + ANZ_HDR_EXT;
            } else if (file5.exists()) {
                string2 = string2 + ANZ_HDR_EXT;
            } else if (file6.exists()) {
                string2 = string2 + ANZ_HDR_EXT;
            }
        }
        if (string2.endsWith(ANZ_HDR_EXT)) {
            this.ds_hdrname = new String(string2);
            this.ds_datname = string2.substring(0, string2.length() - ANZ_HDR_EXT.length()) + ANZ_DAT_EXT;
        } else if (string2.endsWith(ANZ_DAT_EXT)) {
            this.ds_datname = new String(string2);
            this.ds_hdrname = string2.substring(0, string2.length() - ANZ_DAT_EXT.length()) + ANZ_HDR_EXT;
        } else if (string2.endsWith(NI1_EXT)) {
            this.ds_datname = new String(string2);
            this.ds_hdrname = new String(string2);
            this.ds_is_nii = true;
        }
        File file = new File(this.ds_hdrname + GZIP_EXT);
        if (file.exists()) {
            this.ds_hdrname = this.ds_hdrname + GZIP_EXT;
        }
        if ((file = new File(this.ds_datname + GZIP_EXT)).exists()) {
            this.ds_datname = this.ds_datname + GZIP_EXT;
        }
    }

    private void setDefaults() {
        int n;
        this.ds_hdrname = new String("");
        this.ds_datname = new String("");
        this.ds_is_nii = false;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        this.big_endian = byteOrder == ByteOrder.BIG_ENDIAN;
        this.sizeof_hdr = 348;
        this.data_type_string = new StringBuffer();
        for (n = 0; n < 10; ++n) {
            this.data_type_string.append("\u0000");
        }
        this.db_name = new StringBuffer();
        for (n = 0; n < 18; ++n) {
            this.db_name.append("\u0000");
        }
        this.extents = 0;
        this.session_error = 0;
        this.regular = new StringBuffer("\u0000");
        this.dim_info = new StringBuffer("\u0000");
        this.freq_dim = 0;
        this.phase_dim = 0;
        this.slice_dim = 0;
        this.dim = new short[8];
        for (n = 0; n < 8; ++n) {
            this.dim[n] = 0;
        }
        this.XDIM = 0;
        this.YDIM = 0;
        this.ZDIM = 0;
        this.TDIM = 0;
        this.intent = new float[3];
        for (n = 0; n < 3; ++n) {
            this.intent[n] = 0.0f;
        }
        this.intent_code = 0;
        this.datatype = 0;
        this.bitpix = 0;
        this.slice_start = 0;
        this.pixdim = new float[8];
        this.pixdim[0] = 1.0f;
        this.qfac = 1;
        for (n = 1; n < 8; ++n) {
            this.pixdim[n] = 0.0f;
        }
        this.vox_offset = 0.0f;
        this.scl_slope = 0.0f;
        this.scl_inter = 0.0f;
        this.slice_end = 0;
        this.slice_code = 0;
        this.xyzt_units = 0;
        this.xyz_unit_code = 0;
        this.t_unit_code = 0;
        this.cal_max = 0.0f;
        this.cal_min = 0.0f;
        this.slice_duration = 0.0f;
        this.toffset = 0.0f;
        this.glmax = 0;
        this.glmin = 0;
        this.descrip = new StringBuffer();
        for (n = 0; n < 80; ++n) {
            this.descrip.append("\u0000");
        }
        this.aux_file = new StringBuffer();
        for (n = 0; n < 24; ++n) {
            this.aux_file.append("\u0000");
        }
        this.qform_code = 0;
        this.sform_code = 0;
        this.quatern = new float[3];
        this.qoffset = new float[3];
        for (n = 0; n < 3; ++n) {
            this.quatern[n] = 0.0f;
            this.qoffset[n] = 0.0f;
        }
        this.srow_x = new float[4];
        this.srow_y = new float[4];
        this.srow_z = new float[4];
        for (n = 0; n < 4; ++n) {
            this.srow_x[n] = 0.0f;
            this.srow_y[n] = 0.0f;
            this.srow_z[n] = 0.0f;
        }
        this.intent_name = new StringBuffer();
        for (n = 0; n < 16; ++n) {
            this.intent_name.append("\u0000");
        }
        this.magic = new StringBuffer(NII_MAGIC_STRING);
        this.extension = new byte[4];
        for (n = 0; n < 4; ++n) {
            this.extension[n] = 0;
        }
        this.extensions_list = new Vector(5);
        this.extension_blobs = new Vector(5);
    }

    private short[] unpackDimInfo(int n) {
        short[] sArray = new short[]{(short)(n & 3), (short)(n >>> 2 & 3), (short)(n >>> 4 & 3)};
        return sArray;
    }

    private byte packDimInfo(short s, short s2, short s3) {
        int n = 0;
        n = (n & (s3 & 3)) << 2;
        n = (n & (s2 & 3)) << 2;
        return (byte)(n &= s & 3);
    }

    private short[] unpackUnits(int n) {
        short[] sArray = new short[]{(short)(n & 7), (short)(n & 0x38)};
        return sArray;
    }

    private byte packUnits(short s, short s2) {
        return (byte)(s & 7 | s2 & 0x38);
    }

    public double[][][] readDoubleVol(short s) throws IOException {
        int n = this.ZDIM;
        if (this.dim[0] == 2) {
            n = 1;
        }
        double[][][] dArray = new double[n][this.YDIM][this.XDIM];
        byte[] byArray = this.readVolBlob(s);
        EndianCorrectInputStream endianCorrectInputStream = new EndianCorrectInputStream(new ByteArrayInputStream(byArray), this.big_endian);
        switch (this.datatype) {
            case 2: 
            case 256: {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < this.YDIM; ++j) {
                        for (int k = 0; k < this.XDIM; ++k) {
                            dArray[i][j][k] = endianCorrectInputStream.readByte();
                            if (this.datatype == 2 && dArray[i][j][k] < 0.0) {
                                dArray[i][j][k] = Math.abs(dArray[i][j][k]) + 128.0;
                            }
                            if (this.scl_slope == 0.0f) continue;
                            dArray[i][j][k] = dArray[i][j][k] * (double)this.scl_slope + (double)this.scl_inter;
                        }
                    }
                }
                break;
            }
            case 4: 
            case 512: {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < this.YDIM; ++j) {
                        for (int k = 0; k < this.XDIM; ++k) {
                            dArray[i][j][k] = endianCorrectInputStream.readShortCorrect();
                            if (this.datatype == 512 && dArray[i][j][k] < 0.0) {
                                dArray[i][j][k] = Math.abs(dArray[i][j][k]) + 32768.0;
                            }
                            if (this.scl_slope == 0.0f) continue;
                            dArray[i][j][k] = dArray[i][j][k] * (double)this.scl_slope + (double)this.scl_inter;
                        }
                    }
                }
                break;
            }
            case 8: 
            case 768: {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < this.YDIM; ++j) {
                        for (int k = 0; k < this.XDIM; ++k) {
                            dArray[i][j][k] = endianCorrectInputStream.readIntCorrect();
                            if (this.datatype == 768 && dArray[i][j][k] < 0.0) {
                                dArray[i][j][k] = Math.abs(dArray[i][j][k]) + -2.147483648E9;
                            }
                            if (this.scl_slope == 0.0f) continue;
                            dArray[i][j][k] = dArray[i][j][k] * (double)this.scl_slope + (double)this.scl_inter;
                        }
                    }
                }
                break;
            }
            case 1024: 
            case 1280: {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < this.YDIM; ++j) {
                        for (int k = 0; k < this.XDIM; ++k) {
                            dArray[i][j][k] = endianCorrectInputStream.readLongCorrect();
                            if (this.datatype == 1280 && dArray[i][j][k] < 0.0) {
                                dArray[i][j][k] = Math.abs(dArray[i][j][k]) + -2.147483648E9;
                            }
                            if (this.scl_slope == 0.0f) continue;
                            dArray[i][j][k] = dArray[i][j][k] * (double)this.scl_slope + (double)this.scl_inter;
                        }
                    }
                }
                break;
            }
            case 16: {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < this.YDIM; ++j) {
                        for (int k = 0; k < this.XDIM; ++k) {
                            dArray[i][j][k] = endianCorrectInputStream.readFloatCorrect();
                            if (this.scl_slope == 0.0f) continue;
                            dArray[i][j][k] = dArray[i][j][k] * (double)this.scl_slope + (double)this.scl_inter;
                        }
                    }
                }
                break;
            }
            case 64: {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < this.YDIM; ++j) {
                        for (int k = 0; k < this.XDIM; ++k) {
                            dArray[i][j][k] = endianCorrectInputStream.readDoubleCorrect();
                            if (this.scl_slope == 0.0f) continue;
                            dArray[i][j][k] = dArray[i][j][k] * (double)this.scl_slope + (double)this.scl_inter;
                        }
                    }
                }
                break;
            }
            default: {
                throw new IOException("Sorry, cannot yet read nifti-1 datatype " + this.decodeDatatype(this.datatype));
            }
        }
        endianCorrectInputStream.close();
        byArray = null;
        return dArray;
    }

    public void writeVol(double[][][] dArray, short s) throws IOException {
        short s2 = this.ZDIM;
        if (this.dim[0] == 2) {
            s2 = 1;
        }
        int n = this.XDIM * this.YDIM * s2 * this.bytesPerVoxel(this.datatype);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        EndianCorrectOutputStream endianCorrectOutputStream = new EndianCorrectOutputStream(byteArrayOutputStream, this.big_endian);
        switch (this.datatype) {
            case 2: 
            case 4: 
            case 256: 
            case 512: {
                for (short s3 = 0; s3 < s2; s3 = (short)(s3 + 1)) {
                    for (short s4 = 0; s4 < this.YDIM; s4 = (short)(s4 + 1)) {
                        for (short s5 = 0; s5 < this.XDIM; s5 = (short)(s5 + 1)) {
                            if (this.scl_slope == 0.0f) {
                                endianCorrectOutputStream.writeShortCorrect((short)dArray[s3][s4][s5]);
                                continue;
                            }
                            endianCorrectOutputStream.writeShortCorrect((short)((dArray[s3][s4][s5] - (double)this.scl_inter) / (double)this.scl_slope));
                        }
                    }
                }
                break;
            }
            case 8: 
            case 768: {
                for (short s6 = 0; s6 < s2; s6 = (short)(s6 + 1)) {
                    for (short s7 = 0; s7 < this.YDIM; s7 = (short)(s7 + 1)) {
                        for (short s8 = 0; s8 < this.XDIM; s8 = (short)(s8 + 1)) {
                            if (this.scl_slope == 0.0f) {
                                endianCorrectOutputStream.writeIntCorrect((int)dArray[s6][s7][s8]);
                                continue;
                            }
                            endianCorrectOutputStream.writeIntCorrect((int)((dArray[s6][s7][s8] - (double)this.scl_inter) / (double)this.scl_slope));
                        }
                    }
                }
                break;
            }
            case 1024: 
            case 1280: {
                for (short s9 = 0; s9 < s2; s9 = (short)(s9 + 1)) {
                    for (short s10 = 0; s10 < this.YDIM; s10 = (short)(s10 + 1)) {
                        for (short s11 = 0; s11 < this.XDIM; s11 = (short)(s11 + 1)) {
                            if (this.scl_slope == 0.0f) {
                                endianCorrectOutputStream.writeLongCorrect((long)Math.rint(dArray[s9][s10][s11]));
                                continue;
                            }
                            endianCorrectOutputStream.writeLongCorrect((long)Math.rint((dArray[s9][s10][s11] - (double)this.scl_inter) / (double)this.scl_slope));
                        }
                    }
                }
                break;
            }
            case 16: {
                for (short s12 = 0; s12 < s2; s12 = (short)(s12 + 1)) {
                    for (short s13 = 0; s13 < this.YDIM; s13 = (short)(s13 + 1)) {
                        for (short s14 = 0; s14 < this.XDIM; s14 = (short)(s14 + 1)) {
                            if (this.scl_slope == 0.0f) {
                                endianCorrectOutputStream.writeFloatCorrect((float)dArray[s12][s13][s14]);
                                continue;
                            }
                            endianCorrectOutputStream.writeFloatCorrect((float)((dArray[s12][s13][s14] - (double)this.scl_inter) / (double)this.scl_slope));
                        }
                    }
                }
                break;
            }
            case 64: {
                for (short s15 = 0; s15 < s2; s15 = (short)(s15 + 1)) {
                    for (short s16 = 0; s16 < this.YDIM; s16 = (short)(s16 + 1)) {
                        for (short s17 = 0; s17 < this.XDIM; s17 = (short)(s17 + 1)) {
                            if (this.scl_slope == 0.0f) {
                                endianCorrectOutputStream.writeDoubleCorrect(dArray[s15][s16][s17]);
                                continue;
                            }
                            endianCorrectOutputStream.writeDoubleCorrect((dArray[s15][s16][s17] - (double)this.scl_inter) / (double)this.scl_slope);
                        }
                    }
                }
                break;
            }
            default: {
                throw new IOException("Sorry, cannot yet write nifti-1 datatype " + this.decodeDatatype(this.datatype));
            }
        }
        this.writeVolBlob(byteArrayOutputStream, s);
        endianCorrectOutputStream.close();
    }

    private byte[] readVolBlob(short s) throws IOException {
        short s2 = this.ZDIM;
        if (this.dim[0] == 2) {
            s2 = 1;
        }
        int n = this.XDIM * this.YDIM * s2 * this.bytesPerVoxel(this.datatype);
        byte[] byArray = new byte[n];
        long l = (long)this.vox_offset;
        long l2 = s * n;
        if (this.ds_datname.endsWith(GZIP_EXT)) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.ds_datname)));
            bufferedInputStream.skip(l + l2);
            bufferedInputStream.read(byArray, 0, n);
            bufferedInputStream.close();
        } else {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.ds_datname, "r");
            randomAccessFile.seek(l + l2);
            randomAccessFile.readFully(byArray, 0, n);
            randomAccessFile.close();
        }
        return byArray;
    }

    private void writeVolBlob(ByteArrayOutputStream byteArrayOutputStream, short s) throws IOException {
        short s2 = this.ZDIM;
        if (this.dim[0] == 2) {
            s2 = 1;
        }
        long l = (long)this.vox_offset;
        long l2 = s * this.XDIM * this.YDIM * s2 * this.bytesPerVoxel(this.datatype);
        if (this.ds_datname.endsWith(GZIP_EXT)) {
            throw new IOException("Sorry, can't write to compressed image data file: " + this.ds_datname);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.ds_datname, "rwd");
        randomAccessFile.seek(l + l2);
        randomAccessFile.write(byteArrayOutputStream.toByteArray());
        randomAccessFile.close();
    }

    public byte[] readData() throws IOException {
        long l = 1L;
        for (int i = 1; i <= this.dim[0]; ++i) {
            l *= (long)this.dim[i];
        }
        if ((l *= (long)this.bytesPerVoxel(this.datatype)) > Integer.MAX_VALUE) {
            throw new IOException("\nSorry, cannot yet handle data arrays bigger than 2147483647 bytes.  " + this.ds_datname + " has " + l + " bytes.");
        }
        byte[] byArray = new byte[(int)l];
        long l2 = (long)this.vox_offset;
        DataInputStream dataInputStream = this.ds_datname.endsWith(GZIP_EXT) ? new DataInputStream(new GZIPInputStream(new FileInputStream(this.ds_datname))) : new DataInputStream(new FileInputStream(this.ds_datname));
        dataInputStream.skipBytes((int)l2);
        dataInputStream.readFully(byArray, 0, (int)l);
        dataInputStream.close();
        return byArray;
    }

    public void writeData(byte[] byArray) throws IOException {
        int n = (int)this.vox_offset;
        if (this.ds_datname.endsWith(GZIP_EXT)) {
            throw new IOException("Sorry, can't write to compressed image data file: " + this.ds_datname);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.ds_datname, "rwd");
        randomAccessFile.seek(n);
        randomAccessFile.write(byArray, 0, byArray.length);
        randomAccessFile.close();
    }

    public double[] readDoubleTmcrs(short s, short s2, short s3) throws IOException {
        short s4 = this.ZDIM;
        if (this.dim[0] == 2) {
            s4 = 1;
        }
        double[] dArray = new double[this.TDIM];
        long l = (long)this.vox_offset;
        long l2 = (s3 * this.XDIM * this.YDIM + s2 * this.XDIM + s) * this.bytesPerVoxel(this.datatype);
        long l3 = this.XDIM * this.YDIM * s4 * this.bytesPerVoxel(this.datatype) - this.bytesPerVoxel(this.datatype);
        long l4 = 0L;
        EndianCorrectInputStream endianCorrectInputStream = this.ds_datname.endsWith(GZIP_EXT) ? new EndianCorrectInputStream(new GZIPInputStream(new FileInputStream(this.ds_datname)), this.big_endian) : new EndianCorrectInputStream(new FileInputStream(this.ds_datname), this.big_endian);
        endianCorrectInputStream.skip((int)(l + l2));
        block8: for (short s5 = 0; s5 < this.TDIM; s5 = (short)(s5 + 1)) {
            endianCorrectInputStream.skip(l4);
            l4 = l3;
            switch (this.datatype) {
                case 2: 
                case 256: {
                    dArray[s5] = endianCorrectInputStream.readByte();
                    if (this.datatype == 2 && dArray[s5] < 0.0) {
                        dArray[s5] = Math.abs(dArray[s5]) + 128.0;
                    }
                    if (this.scl_slope == 0.0f) continue block8;
                    dArray[s5] = dArray[s5] * (double)this.scl_slope + (double)this.scl_inter;
                    continue block8;
                }
                case 4: 
                case 512: {
                    dArray[s5] = endianCorrectInputStream.readShortCorrect();
                    if (this.datatype == 512 && dArray[s5] < 0.0) {
                        dArray[s5] = Math.abs(dArray[s5]) + 32768.0;
                    }
                    if (this.scl_slope == 0.0f) continue block8;
                    dArray[s5] = dArray[s5] * (double)this.scl_slope + (double)this.scl_inter;
                    continue block8;
                }
                case 8: 
                case 768: {
                    dArray[s5] = endianCorrectInputStream.readIntCorrect();
                    if (this.datatype == 768 && dArray[s5] < 0.0) {
                        dArray[s5] = Math.abs(dArray[s5]) + -2.147483648E9;
                    }
                    if (this.scl_slope == 0.0f) continue block8;
                    dArray[s5] = dArray[s5] * (double)this.scl_slope + (double)this.scl_inter;
                    continue block8;
                }
                case 1024: 
                case 1280: {
                    dArray[s5] = endianCorrectInputStream.readLongCorrect();
                    if (this.datatype == 1280 && dArray[s5] < 0.0) {
                        dArray[s5] = Math.abs(dArray[s5]) + -2.147483648E9;
                    }
                    if (this.scl_slope == 0.0f) continue block8;
                    dArray[s5] = dArray[s5] * (double)this.scl_slope + (double)this.scl_inter;
                    continue block8;
                }
                case 16: {
                    dArray[s5] = endianCorrectInputStream.readFloatCorrect();
                    if (this.scl_slope == 0.0f) continue block8;
                    dArray[s5] = dArray[s5] * (double)this.scl_slope + (double)this.scl_inter;
                    continue block8;
                }
                case 64: {
                    dArray[s5] = endianCorrectInputStream.readDoubleCorrect();
                    if (this.scl_slope == 0.0f) continue block8;
                    dArray[s5] = dArray[s5] * (double)this.scl_slope + (double)this.scl_inter;
                    continue block8;
                }
                default: {
                    throw new IOException("Sorry, cannot yet read nifti-1 datatype " + this.decodeDatatype(this.datatype));
                }
            }
        }
        endianCorrectInputStream.close();
        return dArray;
    }

    private byte[] setStringSize(StringBuffer stringBuffer, int n) {
        int n2;
        int n3 = stringBuffer.length();
        if (n3 >= n) {
            return stringBuffer.toString().substring(0, n).getBytes();
        }
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray[n2] = (byte)stringBuffer.charAt(n2);
        }
        for (n2 = n3; n2 < n; ++n2) {
            byArray[n2] = 0;
        }
        return byArray;
    }

    @Override
    public int xDataDim() {
        return this.XDIM;
    }

    @Override
    public int yDataDim() {
        return this.YDIM;
    }

    @Override
    public int zDataDim() {
        return this.ZDIM;
    }

    @Override
    public int[] getDataDims() {
        return new int[]{this.XDIM, this.YDIM, this.ZDIM};
    }

    @Override
    public double xVoxelDim() {
        return this.pixdim[1];
    }

    @Override
    public double yVoxelDim() {
        return this.pixdim[2];
    }

    @Override
    public double zVoxelDim() {
        return this.pixdim[3];
    }

    @Override
    public double[] getVoxelDims() {
        return new double[]{this.pixdim[1], this.pixdim[2], this.pixdim[3]};
    }

    @Override
    public double[] getOrigin() {
        return new double[]{this.qoffset[0], this.qoffset[1], this.qoffset[2]};
    }

    @Override
    public int components() {
        if (this.dim[0] < 3) {
            throw new LoggedException("Can't handle " + this.dim[0] + "D images");
        }
        if (this.dim[0] == 3) {
            return 1;
        }
        if (this.dim[0] == 4) {
            return this.dim[4] > 0 ? this.dim[4] : 1;
        }
        if (this.dim[4] > 1 && this.dim[5] > 1) {
            throw new LoggedException("Can't handle multi-component images with multiple time points");
        }
        return this.dim[5] > 0 ? this.dim[5] : 1;
    }

    @Override
    public DataSource getImageDataSource() {
        if (!this.existsDat()) {
            throw new DataSourceException("Can't find data source for header " + this.ds_hdrname);
        }
        try {
            this.readHeader();
        }
        catch (IOException iOException) {
            throw new DataSourceException("Can't read header for file " + this.ds_hdrname);
        }
        double d = (double)this.scl_slope == 0.0 ? 1.0 : (double)this.scl_slope;
        double d2 = (double)this.scl_slope == 0.0 ? 0.0 : (double)this.scl_inter;
        boolean bl = !this.big_endian;
        String string = this.caminoDataTypeString();
        int n = (int)this.vox_offset;
        String string2 = this.ds_datname;
        if (this.dim[0] <= 2 || this.dim[0] >= 6) {
            throw new LoggedException("Can't handle this " + this.dim[0] + "-dimensional dataset. Camino " + "supports 3D or 4D scalar volumes (where fourth dimension is 1) " + "or 5D multivariate datasets");
        }
        int n2 = this.dim[1] * this.dim[2] * this.dim[3];
        int n3 = this.components();
        if (n3 == 1) {
            return new VoxelOrderScaledDataSource(this.ds_datname, 1, string, bl, n, d, d2);
        }
        double[][] dArray = new double[n2][n3];
        try {
            for (int i = 0; i < n3; ++i) {
                double[][][] dArray2 = this.readDoubleVol((short)i);
                int n4 = 0;
                for (int j = 0; j < this.dim[3]; ++j) {
                    for (int k = 0; k < this.dim[2]; ++k) {
                        for (int i2 = 0; i2 < this.dim[1]; ++i2) {
                            dArray[n4++][i] = dArray2[j][k][i2];
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        ScannerOrderDataSource scannerOrderDataSource = new ScannerOrderDataSource(dArray);
        return scannerOrderDataSource;
    }

    @Override
    public double[][][][] readVolumeData() {
        if (!this.existsDat()) {
            throw new DataSourceException("Can't find data source for header " + this.ds_hdrname);
        }
        int n = this.components();
        double[][][][] dArray = new double[this.XDIM][this.YDIM][this.ZDIM][n];
        try {
            for (int i = 0; i < n; ++i) {
                double[][][] dArray2 = this.readDoubleVol((short)i);
                boolean bl = false;
                for (int j = 0; j < this.ZDIM; ++j) {
                    for (int k = 0; k < this.YDIM; ++k) {
                        for (int i2 = 0; i2 < this.XDIM; ++i2) {
                            dArray[i2][k][j][i] = dArray2[j][k][i2];
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        return dArray;
    }

    @Override
    public double[][][] readVolume(int n) {
        if (!this.existsDat()) {
            throw new DataSourceException("Can't find data source for header " + this.ds_hdrname);
        }
        int n2 = this.components();
        if (n < 0 || n >= n2) {
            throw new LoggedException("Attempted to read non-existent volume " + n);
        }
        double[][][] dArray = new double[this.XDIM][this.YDIM][this.ZDIM];
        try {
            double[][][] dArray2 = this.readDoubleVol((short)n);
            for (int i = 0; i < this.ZDIM; ++i) {
                for (int j = 0; j < this.YDIM; ++j) {
                    for (int k = 0; k < this.XDIM; ++k) {
                        dArray[k][j][i] = dArray2[i][j][k];
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        return dArray;
    }

    public String caminoDataTypeString() {
        switch (this.datatype) {
            case 2: {
                return "char";
            }
            case 256: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 512: {
                return "ushort";
            }
            case 8: {
                return "int";
            }
            case 768: {
                return "uint";
            }
            case 1024: {
                return "long";
            }
            case 16: {
                return "float";
            }
            case 64: {
                return "double";
            }
        }
        throw new LoggedException("Camino does not support this data type: " + this.decodeDatatype(this.datatype));
    }

    public static ImageHeader readHeader(String string) throws IOException {
        Nifti1Dataset nifti1Dataset = new Nifti1Dataset(string);
        nifti1Dataset.readHeader();
        return nifti1Dataset;
    }

    public static void convertTo3D(String string, String string2, String string3) throws IOException {
        Nifti1Dataset nifti1Dataset = new Nifti1Dataset(string);
        nifti1Dataset.readHeader();
        int n = nifti1Dataset.components();
        DecimalFormat decimalFormat = new DecimalFormat("000");
        for (int i = 0; i < n; ++i) {
            double[][][] dArray = nifti1Dataset.readDoubleVol((short)i);
            Nifti1Dataset nifti1Dataset2 = new Nifti1Dataset();
            nifti1Dataset2.copyHeader(nifti1Dataset);
            nifti1Dataset2.dim[0] = 4;
            nifti1Dataset2.dim[4] = 1;
            nifti1Dataset2.setHeaderFilename(string2 + decimalFormat.format(i + 1) + "." + string3);
            nifti1Dataset2.setDataFilename(string2 + decimalFormat.format(i + 1));
            nifti1Dataset2.writeHeader();
            nifti1Dataset2.writeVol(dArray, (short)0);
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-readheader")) continue;
            Nifti1Dataset nifti1Dataset = new Nifti1Dataset(stringArray[i + 1]);
            try {
                nifti1Dataset.readHeader();
                nifti1Dataset.printHeader();
            }
            catch (IOException iOException) {
                System.out.println("\nCould not read header file for " + stringArray[0] + ": " + iOException.getMessage());
            }
            return;
        }
    }
}

